/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.serviceregistry.ServiceExceptionTests;
import org.eclipse.osgi.tests.serviceregistry.ServiceHookTests;
import org.eclipse.osgi.tests.serviceregistry.ServiceTrackerTests;
import org.eclipse.osgi.tests.util.MapDictionary;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistryTests
extends AbstractBundleTests {
    public static Test suite() {
        TestSuite suite = new TestSuite(ServiceRegistryTests.class.getName());
        suite.addTest((Test)new TestSuite(ServiceRegistryTests.class));
        suite.addTest(ServiceExceptionTests.suite());
        suite.addTest(ServiceHookTests.suite());
        suite.addTest(ServiceTrackerTests.suite());
        return suite;
    }

    public void testServiceListener01() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        final boolean[] results = new boolean[4];
        ServiceListener testListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        results[0] = true;
                        break;
                    }
                    case 2: {
                        results[1] = true;
                        break;
                    }
                    case 8: {
                        results[2] = true;
                        break;
                    }
                    case 4: {
                        results[3] = true;
                    }
                }
            }
        };
        try {
            OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        }
        catch (InvalidSyntaxException e) {
            ServiceRegistryTests.fail((String)"filter error", (Throwable)e);
        }
        ServiceRegistration reg = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.TRUE);
            reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            reg.unregister();
            reg = null;
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    public void testServiceListener02() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        final boolean[] results = new boolean[4];
        ServiceListener testListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        results[0] = true;
                        break;
                    }
                    case 2: {
                        results[1] = true;
                        break;
                    }
                    case 8: {
                        results[2] = true;
                        break;
                    }
                    case 4: {
                        results[3] = true;
                    }
                }
            }
        };
        try {
            OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        }
        catch (InvalidSyntaxException e) {
            ServiceRegistryTests.fail((String)"filter error", (Throwable)e);
        }
        ServiceRegistration reg = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.FALSE);
            reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertTrue((String)"Did not get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
            reg.unregister();
            reg = null;
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.REGISTERED", (boolean)results[0]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED", (boolean)results[1]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (boolean)results[2]);
            ServiceRegistryTests.assertFalse((String)"Did get ServiceEvent.UNREGISTERING", (boolean)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    public void testServiceListener03() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        final int[] results = new int[4];
        ServiceListener testListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        results[0] = results[0] + 1;
                        break;
                    }
                    case 2: {
                        results[1] = results[1] + 1;
                        break;
                    }
                    case 8: {
                        results[2] = results[2] + 1;
                        break;
                    }
                    case 4: {
                        results[3] = results[3] + 1;
                    }
                }
            }
        };
        try {
            OSGiTestsActivator.getContext().addServiceListener(testListener, "(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))");
        }
        catch (InvalidSyntaxException e) {
            ServiceRegistryTests.fail((String)"filter error", (Throwable)e);
        }
        ServiceRegistration reg1 = null;
        ServiceRegistration reg2 = null;
        try {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            props.put(testMethodName, Boolean.FALSE);
            reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg1.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg1.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)1, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)1, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg1.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)1, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)1, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg1.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)1, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg2.setProperties(props);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)1, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg1.unregister();
            reg1 = null;
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
            reg2.unregister();
            reg2 = null;
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.REGISTERED", (int)0, (int)results[0]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED", (int)0, (int)results[1]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.MODIFIED_ENDMATCH", (int)0, (int)results[2]);
            ServiceRegistryTests.assertEquals((String)"Did get ServiceEvent.UNREGISTERING", (int)0, (int)results[3]);
            this.clearResults(results);
        }
        finally {
            OSGiTestsActivator.getContext().removeServiceListener(testListener);
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
        }
    }

    public void testServiceOrdering01() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", testMethodName);
        props.put("service.description", "min value");
        props.put("service.ranking", new Integer(Integer.MIN_VALUE));
        ServiceRegistration reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value first");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value second");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration reg3 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            ServiceReference ref = null;
            ref = OSGiTestsActivator.getContext().getServiceReference(Runnable.class.getName());
            ServiceRegistryTests.assertNotNull((String)"service ref is null", (Object)ref);
            ServiceRegistryTests.assertEquals("Wrong references", reg2.getReference(), ref);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    public void testDuplicateObjectClass() {
        ServiceRegistration reg = null;
        try {
            try {
                reg = OSGiTestsActivator.getContext().registerService(new String[]{Runnable.class.getName(), Object.class.getName(), Object.class.getName()}, (Object)new Runnable(){

                    @Override
                    public void run() {
                    }
                }, null);
            }
            catch (Throwable t) {
                ServiceRegistryTests.fail((String)"Failed to register service with duplicate objectClass names", (Throwable)t);
                if (reg != null) {
                    reg.unregister();
                }
            }
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    public void testServiceReferenceCompare01() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", testMethodName);
        props.put("service.description", "min value");
        props.put("service.ranking", new Integer(Integer.MIN_VALUE));
        ServiceRegistration reg1 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value first");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration reg2 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "max value second");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration reg3 = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            ServiceReference ref = OSGiTestsActivator.getContext().getServiceReference(Runnable.class.getName());
            ServiceReference ref1 = reg1.getReference();
            ServiceReference ref2 = reg2.getReference();
            ServiceReference ref3 = reg3.getReference();
            ServiceRegistryTests.assertNotNull((String)"service ref is null", (Object)ref);
            ServiceRegistryTests.assertEquals("Wrong reference", ref2, ref);
            ServiceRegistryTests.assertEquals((String)"Wrong references", (int)0, (int)ref2.compareTo((Object)ref));
            ServiceRegistryTests.assertEquals((String)"Wrong references", (int)0, (int)ref.compareTo((Object)ref2));
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref1)), (ref1.compareTo((Object)ref1) == 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref2)), (ref1.compareTo((Object)ref2) < 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref1.compareTo((Object)ref3)), (ref1.compareTo((Object)ref3) < 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref1)), (ref2.compareTo((Object)ref1) > 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref2)), (ref2.compareTo((Object)ref2) == 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref2.compareTo((Object)ref3)), (ref2.compareTo((Object)ref3) > 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref1)), (ref3.compareTo((Object)ref1) > 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref2)), (ref3.compareTo((Object)ref2) < 0 ? 1 : 0) != 0);
            ServiceRegistryTests.assertTrue((String)("Wrong compareTo value: " + ref3.compareTo((Object)ref3)), (ref3.compareTo((Object)ref3) == 0 ? 1 : 0) != 0);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    public void testModifiedRanking() {
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
        props.put(this.getName(), Boolean.TRUE);
        props.put("service.ranking", new Integer(15));
        ServiceRegistration reg1 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.ranking", new Integer(10));
        ServiceRegistration reg2 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        try {
            ServiceRegistryTests.assertEquals("wrong service reference", reg1.getReference(), this.getContext().getServiceReference("java.lang.Runnable"));
            props.put("service.ranking", new Integer(20));
            reg2.setProperties(props);
            ServiceRegistryTests.assertEquals("wrong service reference", reg2.getReference(), this.getContext().getServiceReference("java.lang.Runnable"));
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
        }
    }

    public void testInvalidRanking() {
        final CountDownLatch warning = new CountDownLatch(1);
        FrameworkListener warningListener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (16 == event.getType() && OSGiTestsActivator.getContext().getBundle().equals(event.getBundle())) {
                    warning.countDown();
                }
            }
        };
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(this.getName(), Boolean.TRUE);
        props.put("service.ranking", "15");
        ServiceRegistration reg1 = null;
        try {
            OSGiTestsActivator.getContext().addFrameworkListener(warningListener);
            reg1 = this.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        }
        finally {
            if (reg1 != null) {
                reg1.unregister();
            }
            OSGiTestsActivator.getContext().removeFrameworkListener(warningListener);
        }
        try {
            ServiceRegistryTests.assertTrue((String)"Timeout waiting for the warning.", (boolean)warning.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            ServiceRegistryTests.fail((String)"Interrupted.", (Throwable)e);
        }
    }

    public void testNullValue() throws InvalidSyntaxException {
        ServiceRegistration reg = null;
        try {
            MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
            ((Dictionary)nullProps).put("test.null", null);
            ((Dictionary)nullProps).put("test.non.null", "v1");
            reg = OSGiTestsActivator.getContext().registerService(Object.class, new Object(), nullProps);
            ServiceRegistryTests.assertFalse((boolean)OSGiTestsActivator.getContext().createFilter("(test.null=*)").match(reg.getReference()));
            ServiceRegistryTests.assertFalse((boolean)OSGiTestsActivator.getContext().createFilter("(test.null=*)").match(reg.getReference().getProperties()));
            ServiceRegistryTests.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(&(!(test.null=*))(test.non.null=v1))").match(reg.getReference()));
            ServiceRegistryTests.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(&(!(test.null=*))(test.non.null=v1))").match(reg.getReference().getProperties()));
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    public void testNullKey() throws InvalidSyntaxException {
        ServiceRegistration reg = null;
        try {
            MapDictionary<String, String> nullProps = new MapDictionary<String, String>();
            ((Dictionary)nullProps).put(null, "null.v1");
            ((Dictionary)nullProps).put("test.non.null", "v1");
            reg = OSGiTestsActivator.getContext().registerService(Object.class, new Object(), nullProps);
            ServiceRegistryTests.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(test.non.null=v1)").match(reg.getReference()));
            ServiceRegistryTests.assertTrue((boolean)OSGiTestsActivator.getContext().createFilter("(test.non.null=v1)").match(reg.getReference().getProperties()));
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
        }
    }

    private void clearResults(boolean[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = false;
            ++i;
        }
    }

    private void clearResults(int[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = 0;
            ++i;
        }
    }
}

