/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(ServiceTrackerTests.class);
    }

    public void testServiceTracker01() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.TRUE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            try {
                testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))")), testCustomizer);
            }
            catch (InvalidSyntaxException e) {
                ServiceTrackerTests.fail((String)"filter error", (Throwable)e);
            }
            testTracker.open();
            ServiceTrackerTests.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            ServiceTrackerTests.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    public void testServiceTracker02() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.FALSE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            try {
                testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))")), testCustomizer);
            }
            catch (InvalidSyntaxException e) {
                ServiceTrackerTests.fail((String)"filter error", (Throwable)e);
            }
            testTracker.open();
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            ServiceTrackerTests.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.TRUE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    public void testServiceTracker03() {
        String testMethodName = this.getName();
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        props.put(testMethodName, Boolean.TRUE);
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(Runnable.class.getName(), (Object)runIt, props);
        ServiceTracker testTracker = null;
        try {
            final boolean[] results = new boolean[3];
            ServiceTrackerCustomizer testCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    results[0] = true;
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    results[1] = true;
                }

                public void removedService(ServiceReference reference, Object service) {
                    results[2] = true;
                }
            };
            try {
                testTracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectclass=java.lang.Runnable)(" + testMethodName.toLowerCase() + "=true))")), testCustomizer);
            }
            catch (InvalidSyntaxException e) {
                ServiceTrackerTests.fail((String)"filter error", (Throwable)e);
            }
            testTracker.open();
            ServiceTrackerTests.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertTrue((String)"Did not call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put(testMethodName, Boolean.TRUE);
            reg.setProperties(props);
            ServiceTrackerTests.assertTrue((String)"Did not call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertFalse((String)"Did call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
            props.put("testChangeProp", Boolean.FALSE);
            reg.setProperties(props);
            ServiceTrackerTests.assertFalse((String)"Did call addingService", (boolean)results[0]);
            ServiceTrackerTests.assertTrue((String)"Did not call modifiedService", (boolean)results[1]);
            ServiceTrackerTests.assertFalse((String)"Did call removedService", (boolean)results[2]);
            this.clearResults(results);
        }
        finally {
            if (reg != null) {
                reg.unregister();
            }
            if (testTracker != null) {
                testTracker.close();
            }
        }
    }

    private void clearResults(boolean[] results) {
        int i = 0;
        while (i < results.length) {
            results[i] = false;
            ++i;
        }
    }
}

