/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.tests.OSGiTest;

public class FileManagerTests
extends OSGiTest {
    StorageManager manager1;
    StorageManager manager2;
    File base;

    public FileManagerTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FileManagerTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.base = new File(Platform.getConfigurationLocation().getURL().getPath(), "FileManagerTests");
        this.manager1 = null;
        this.manager2 = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.manager1 != null) {
            this.manager1.close();
        }
        if (this.manager2 != null) {
            this.manager2.close();
        }
        this.rm(this.base);
    }

    private void rm(File file) {
        File[] list;
        if (file.isDirectory() && (list = file.listFiles()) != null) {
            int idx = 0;
            while (idx < list.length) {
                this.rm(list[idx]);
                ++idx;
            }
        }
        file.delete();
    }

    public void testReadOnly() {
        File testDir = new File(this.base, "readOnlyManager");
        String fileName = "testReadOnly";
        testDir.mkdirs();
        String[] files = testDir.list();
        FileManagerTests.assertEquals((int)files.length, (int)0);
        this.manager1 = new StorageManager(testDir, null, true);
        try {
            this.manager1.open(true);
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
        files = testDir.list();
        FileManagerTests.assertEquals((int)files.length, (int)0);
        try {
            this.manager1.add(fileName);
            FileManagerTests.fail((String)"add succedded");
        }
        catch (IOException iOException) {}
        try {
            this.manager1.lookup(fileName, true);
            FileManagerTests.fail((String)"lookup succedded");
        }
        catch (IOException iOException) {}
        try {
            this.manager1.createTempFile(fileName);
            FileManagerTests.fail((String)"create temp file succedded");
        }
        catch (IOException iOException) {}
        files = testDir.list();
        FileManagerTests.assertEquals((int)files.length, (int)0);
        this.manager1.close();
        this.manager1 = null;
        try {
            this.manager2 = new StorageManager(testDir, null, false);
            this.manager2.open(true);
            this.manager2.lookup(fileName, true);
            File tmpFile = this.manager2.createTempFile(fileName);
            this.writeToFile(tmpFile, "This file exists");
            this.manager2.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            this.manager2.close();
            this.manager2 = null;
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
    }

    void writeToFile(File file, String str) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(str.getBytes());
            fos.flush();
            fos.getFD().sync();
        }
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte[] data = new byte[64];
        try {
            int len;
            while ((len = is.read(data)) != -1) {
                sb.append(new String(data, 0, len));
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    public void testExistingVersion() {
        String testFile = "testExistingVersion.txt";
        this.manager1 = new StorageManager(this.base, null);
        try {
            this.manager1.open(false);
            File file1 = new File(this.base, String.valueOf(testFile) + ".1");
            File file2 = new File(this.base, String.valueOf(testFile) + ".2");
            File file3 = new File(this.base, String.valueOf(testFile) + ".3");
            File file4 = new File(this.base, String.valueOf(testFile) + ".4");
            if (file1.exists() || file2.exists() || file3.exists() || file4.exists()) {
                FileManagerTests.fail((String)"Test files already exists.");
                return;
            }
            this.manager1.add(testFile);
            File file = this.manager1.createTempFile(testFile);
            this.writeToFile(file, "contents irrelevant");
            this.manager1.update(new String[]{testFile}, new String[]{file.getName()});
            if (!file1.exists() || file2.exists() || file3.exists() || file4.exists()) {
                FileManagerTests.fail((String)"Failed to create a single test file");
                return;
            }
            this.writeToFile(file2, "file2 exists");
            file = this.manager1.createTempFile(testFile);
            this.writeToFile(file, "file 3 contents");
            this.manager1.update(new String[]{testFile}, new String[]{file.getName()});
            if (!file3.exists() || file4.exists()) {
                FileManagerTests.fail((String)"Failed to skip existing filemanager file.");
                return;
            }
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            file = this.manager2.lookup(testFile, false);
            if (file == null) {
                FileManagerTests.fail((String)"Unable to lookup exising file");
                return;
            }
            FileManagerTests.assertTrue((boolean)file.getName().endsWith(".3"));
            FileManagerTests.assertTrue((boolean)file.exists());
            FileInputStream fis = new FileInputStream(file);
            FileManagerTests.assertEquals((String)this.getInputStreamContents(fis), (String)"file 3 contents");
            this.manager2.close();
            this.manager2 = null;
            this.manager1.close();
            this.manager1 = null;
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
    }

    public void testNotOpen() {
        String permanentFile = "testNotOpen.txt";
        String scratchFile = "testNotOpenScratch";
        this.manager1 = new StorageManager(this.base, null);
        try {
            this.manager1.open(true);
            this.manager1.add(permanentFile);
            File tmpFile = this.manager1.createTempFile(permanentFile);
            this.writeToFile(tmpFile, "File exists");
            this.manager1.update(new String[]{permanentFile}, new String[]{tmpFile.getName()});
            this.manager1.add(scratchFile);
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
        this.manager2 = new StorageManager(this.base, null);
        this.checkOpen(false, permanentFile, scratchFile);
        try {
            this.manager2.open(true);
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
        this.checkOpen(true, permanentFile, scratchFile);
        this.manager2.close();
        this.checkOpen(false, permanentFile, scratchFile);
        this.manager2 = null;
        this.manager1.close();
        this.manager1 = null;
    }

    void checkOpen(boolean open, String permanentFile, String scratchFile) {
        block19: {
            block18: {
                File tmpFile;
                block17: {
                    block16: {
                        try {
                            this.manager2.add("failFile");
                            if (!open) {
                                FileManagerTests.fail((String)"add did not fail.");
                            }
                            this.manager2.remove("failFile");
                        }
                        catch (IOException e) {
                            if (!open) break block16;
                            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                        }
                    }
                    try {
                        this.manager2.lookup(permanentFile, false);
                        if (!open) {
                            FileManagerTests.fail((String)"lookup did not fail.");
                        }
                    }
                    catch (IOException e) {
                        if (!open) break block17;
                        FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                    }
                }
                try {
                    tmpFile = this.manager2.createTempFile("openTest");
                    this.writeToFile(tmpFile, "contents irrelevant");
                }
                catch (IOException e) {
                    FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                    tmpFile = null;
                }
                if (tmpFile != null) {
                    try {
                        this.manager2.update(new String[]{permanentFile}, new String[]{tmpFile.getName()});
                        if (!open) {
                            FileManagerTests.fail((String)"update did not fail.");
                        }
                    }
                    catch (IOException e) {
                        if (!open) break block18;
                        FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                    }
                }
            }
            try {
                this.manager2.remove(scratchFile);
                if (!open) {
                    FileManagerTests.fail((String)"remove did not fail");
                } else {
                    this.manager2.add(scratchFile);
                }
            }
            catch (IOException e) {
                if (!open) break block19;
                FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
            }
        }
    }

    public void testRemoveThenAdd() {
        String fileName = "testRemoveThenAdd.txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        File file3 = new File(this.base, String.valueOf(fileName) + ".3");
        this.manager1 = new StorageManager(this.base, null);
        try {
            this.manager1.open(true);
            this.manager1.add(fileName);
            File tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            tmpFile = this.manager1.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #2");
            this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            this.manager1.close();
            this.manager1 = null;
            if (file1.exists() || !file2.exists() || file3.exists()) {
                FileManagerTests.fail((String)"Failed creating a file revision");
            }
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            this.manager2.remove(fileName);
            File testFile = this.manager2.lookup(fileName, false);
            FileManagerTests.assertNull((Object)testFile);
            this.manager2.add(fileName);
            testFile = this.manager2.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)testFile);
            FileManagerTests.assertTrue((boolean)testFile.getName().endsWith(".0"));
            tmpFile = this.manager2.createTempFile(fileName);
            this.writeToFile(tmpFile, "File exists #3");
            this.manager2.update(new String[]{fileName}, new String[]{tmpFile.getName()});
            testFile = this.manager2.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)testFile);
            FileManagerTests.assertTrue((boolean)testFile.getName().endsWith(".3"));
            FileManagerTests.assertTrue((boolean)file3.exists());
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            testFile = this.manager1.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)testFile);
            FileManagerTests.assertTrue((boolean)testFile.getName().endsWith(".3"));
            this.manager1.close();
            this.manager1 = null;
            this.manager2.close();
            this.manager2 = null;
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
    }

    public void testMultipleFileManagers() {
        String ee = System.getProperty("org.osgi.framework.executionenvironment");
        if (!"win32".equalsIgnoreCase(System.getProperty("osgi.os")) && ee.indexOf("JavaSE-1.6") == -1) {
            return;
        }
        String fileName = "testMultipleFileManagers.txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        this.manager1 = new StorageManager(this.base, null);
        try {
            this.manager1.open(true);
            File file = this.manager1.lookup(fileName, true);
            FileManagerTests.assertNotNull((Object)file);
            file = this.manager1.createTempFile(fileName);
            this.writeToFile(file, "test contents #1");
            this.manager1.update(new String[]{fileName}, new String[]{file.getName()});
            file = this.manager1.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)file);
            FileManagerTests.assertTrue((boolean)file.getName().endsWith(".1"));
            FileManagerTests.assertTrue((boolean)file1.exists());
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            file = this.manager2.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)file);
            FileManagerTests.assertTrue((boolean)file.getName().endsWith(".1"));
            FileManagerTests.assertTrue((file1.exists() && !file2.exists() ? 1 : 0) != 0);
            file = this.manager1.createTempFile(fileName);
            this.writeToFile(file, "test contents #2");
            this.manager1.update(new String[]{fileName}, new String[]{file.getName()});
            FileManagerTests.assertTrue((boolean)file1.exists());
            FileManagerTests.assertTrue((boolean)file2.exists());
            this.manager1.close();
            this.manager1 = null;
            FileManagerTests.assertTrue((boolean)file1.exists());
            FileManagerTests.assertTrue((boolean)file2.exists());
            file = this.manager2.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)file);
            FileManagerTests.assertTrue((boolean)file.getName().endsWith(".1"));
            this.manager2.close();
            this.manager2 = null;
            FileManagerTests.assertTrue((!file1.exists() ? 1 : 0) != 0);
            FileManagerTests.assertTrue((boolean)file2.exists());
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            file = this.manager1.lookup(fileName, false);
            FileManagerTests.assertNotNull((Object)file);
            FileManagerTests.assertTrue((boolean)file.getName().endsWith(".2"));
            this.manager1.close();
            this.manager1 = null;
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
    }

    public void testJavaIOLocking() {
        if (!"win32".equalsIgnoreCase(System.getProperty("osgi.os"))) {
            return;
        }
        String fileName = "testJavaIOLocking";
        File lockFile = new File(new File(this.base, ".manager"), ".fileTableLock");
        lockFile.getParentFile().mkdirs();
        try {
            new FileOutputStream(lockFile).close();
        }
        catch (IOException e) {
            FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
        }
        FileManagerTests.assertTrue((boolean)lockFile.exists());
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(lockFile);
                this.manager1 = new StorageManager(this.base, "java.io");
                try {
                    this.manager1.open(true);
                    FileManagerTests.fail((String)"open with lock succedded");
                }
                catch (IOException iOException) {}
                this.manager1.open(false);
                try {
                    this.manager1.add(fileName);
                    FileManagerTests.fail((String)"add succedded");
                }
                catch (IOException iOException) {}
                FileManagerTests.assertNull((Object)this.manager1.lookup(fileName, false));
                this.manager1.close();
                this.manager1 = null;
            }
            catch (IOException e) {
                FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    FileManagerTests.fail((String)"unexpected exception", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
            }
        }
    }

    public void testCleanupOnOpen() {
        String fileName = String.valueOf(this.getName()) + ".txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        File file3 = new File(this.base, String.valueOf(fileName) + ".3");
        System.setProperty("osgi.embedded.cleanupOnOpen", "true");
        try {
            try {
                this.manager1 = new StorageManager(this.base, null);
                this.manager1.open(true);
                this.manager1.add(fileName);
                File tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #1");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertFalse((String)file3.toString(), (boolean)file3.exists());
                tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #2");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertTrue((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertFalse((String)file3.toString(), (boolean)file3.exists());
                tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #3");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertTrue((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
                String ee = System.getProperty("org.osgi.framework.executionenvironment");
                if ("win32".equalsIgnoreCase(System.getProperty("osgi.os")) || ee.indexOf("JavaSE-1.6") != -1) {
                    this.manager2 = new StorageManager(this.base, null);
                    this.manager2.open(true);
                    this.manager2.close();
                    FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                    FileManagerTests.assertTrue((String)file2.toString(), (boolean)file2.exists());
                    FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
                }
                this.manager1.close();
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
                this.writeToFile(file1, "File exists #1");
                this.writeToFile(file2, "File exists #2");
                FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertTrue((String)file2.toString(), (boolean)file2.exists());
                this.manager1.open(true);
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
                this.manager1.close();
                this.manager1 = null;
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
            }
            catch (IOException e) {
                FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                System.setProperty("osgi.embedded.cleanupOnOpen", "false");
            }
        }
        finally {
            System.setProperty("osgi.embedded.cleanupOnOpen", "false");
        }
    }

    public void testCleanupOnSave() {
        String fileName = String.valueOf(this.getName()) + ".txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        File file3 = new File(this.base, String.valueOf(fileName) + ".3");
        System.setProperty("osgi.embedded.cleanupOnSave", "true");
        try {
            try {
                this.manager1 = new StorageManager(this.base, null);
                this.manager1.open(true);
                this.manager1.add(fileName);
                File tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #1");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertTrue((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertFalse((String)file3.toString(), (boolean)file3.exists());
                tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #2");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertTrue((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertFalse((String)file3.toString(), (boolean)file3.exists());
                tmpFile = this.manager1.createTempFile(fileName);
                this.writeToFile(tmpFile, "File exists #3");
                this.manager1.update(new String[]{fileName}, new String[]{tmpFile.getName()});
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
                this.manager1.close();
                this.manager1 = null;
                FileManagerTests.assertFalse((String)file1.toString(), (boolean)file1.exists());
                FileManagerTests.assertFalse((String)file2.toString(), (boolean)file2.exists());
                FileManagerTests.assertTrue((String)file3.toString(), (boolean)file3.exists());
            }
            catch (IOException e) {
                FileManagerTests.fail((String)"unexpected exception", (Throwable)e);
                System.setProperty("osgi.embedded.cleanupOnSave", "false");
            }
        }
        finally {
            System.setProperty("osgi.embedded.cleanupOnSave", "false");
        }
    }
}

