/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.tests.OSGiTest;

public class StreamManagerTests
extends OSGiTest {
    StorageManager manager1;
    StorageManager manager2;
    File base;
    String reliableFile;

    public StreamManagerTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(StreamManagerTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.base = new File(Platform.getConfigurationLocation().getURL().getPath(), "StreamManagerTests");
        this.manager1 = null;
        this.manager2 = null;
        this.reliableFile = System.getProperty("osgi.useReliableFiles");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.manager1 != null) {
            this.manager1.close();
        }
        if (this.manager2 != null) {
            this.manager2.close();
        }
        this.rm(this.base);
        if (this.reliableFile == null) {
            System.getProperties().remove("osgi.useReliableFiles");
        } else {
            System.setProperty("osgi.useReliableFiles", this.reliableFile);
        }
    }

    private void rm(File file) {
        File[] list;
        if (file.isDirectory() && (list = file.listFiles()) != null) {
            int idx = 0;
            while (idx < list.length) {
                this.rm(list[idx]);
                ++idx;
            }
        }
        file.delete();
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte[] data = new byte[64];
        try {
            int len;
            while ((len = is.read(data)) != -1) {
                sb.append(new String(data, 0, len));
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    void writeToFile(File file, String str) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(str.getBytes());
            fos.flush();
            fos.getFD().sync();
        }
    }

    public void testReliableFile() {
        String fileName = "testReliableFile.txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        File file3 = new File(this.base, String.valueOf(fileName) + ".3");
        String contents1 = "test reliable file cOntents #1";
        String contents2 = "test reliable file cOntents #2";
        try {
            try {
                System.setProperty("osgi.useReliableFiles", "true");
                this.manager1 = new StorageManager(this.base, null);
                this.manager1.open(true);
                ManagedOutputStream fmos = this.manager1.getOutputStream(fileName);
                StreamManagerTests.assertNotNull((Object)fmos);
                fmos.write(contents1.getBytes());
                fmos.close();
                fmos = this.manager1.getOutputStream(fileName);
                StreamManagerTests.assertNotNull((Object)fmos);
                fmos.write(contents2.getBytes());
                fmos.close();
                StreamManagerTests.assertTrue((boolean)file1.exists());
                StreamManagerTests.assertTrue((boolean)file2.exists());
                StreamManagerTests.assertTrue((!file3.exists() ? 1 : 0) != 0);
                this.manager1.close();
                this.manager1 = null;
                System.setProperty("osgi.useReliableFiles", "true");
                this.manager2 = new StorageManager(this.base, null);
                this.manager2.open(true);
                InputStream is = this.manager2.getInputStream(fileName);
                StreamManagerTests.assertNotNull((Object)is);
                StreamManagerTests.assertEquals((String)contents2, (String)this.getInputStreamContents(is));
                this.manager2.close();
                this.manager2 = null;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                RandomAccessFile raf = new RandomAccessFile(file2, "rw");
                raf.seek(20L);
                raf.write(48);
                raf.close();
                System.setProperty("osgi.useReliableFiles", "true");
                this.manager1 = new StorageManager(this.base, null);
                this.manager1.open(true);
                is = this.manager1.getInputStream(fileName);
                StreamManagerTests.assertNotNull((Object)is);
                StreamManagerTests.assertEquals((String)contents1, (String)this.getInputStreamContents(is));
                try {
                    InputStream[] isSet = this.manager1.getInputStreamSet(new String[]{fileName});
                    int i = 0;
                    while (i < isSet.length) {
                        if (isSet[i] != null) {
                            isSet[i].close();
                        }
                        ++i;
                    }
                    StreamManagerTests.fail((String)"getInputStreamSet was successful");
                }
                catch (IOException iOException) {}
                raf = new RandomAccessFile(file1, "rw");
                raf.seek(20L);
                raf.write(48);
                raf.close();
                try {
                    is = this.manager1.getInputStream(fileName);
                    StreamManagerTests.fail((String)"get input stream succedded");
                }
                catch (IOException iOException) {}
                this.manager1.close();
                this.manager1 = null;
            }
            catch (IOException e) {
                StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
                System.setProperty("osgi.useReliableFiles", "false");
            }
        }
        finally {
            System.setProperty("osgi.useReliableFiles", "false");
        }
    }

    public void testBigReliableFile() {
        String fileName = String.valueOf(this.getName()) + ".txt";
        try {
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            ManagedOutputStream fmos = this.manager1.getOutputStream(fileName);
            StreamManagerTests.assertNotNull((Object)fmos);
            DataOutputStream bufferedOut = new DataOutputStream(new BufferedOutputStream((OutputStream)fmos));
            int i = 0;
            while (i < 51200) {
                bufferedOut.writeInt(i);
                ++i;
            }
            bufferedOut.close();
            this.manager1.close();
            this.manager1 = null;
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            InputStream is = this.manager2.getInputStream(fileName);
            StreamManagerTests.assertNotNull((Object)is);
            DataInputStream bufferedIn = new DataInputStream(new BufferedInputStream(is));
            int i2 = 0;
            while (i2 < 51200) {
                StreamManagerTests.assertEquals((String)"Wrong content found", (int)i2, (int)bufferedIn.readInt());
                ++i2;
            }
            this.manager2.close();
            this.manager2 = null;
        }
        catch (IOException e) {
            StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
        }
    }

    public void testMigration() {
        File testDir = new File(this.base, "testMigrationManager");
        File managerDir = new File(testDir, ".manager");
        String fileName = "testMigration.txt";
        File file2 = new File(testDir, String.valueOf(fileName) + ".2");
        File file5 = new File(testDir, String.valueOf(fileName) + ".5");
        File fileTable = new File(managerDir, ".fileTable");
        File fileTable1 = new File(managerDir, ".fileTable.1");
        File fileTable2 = new File(managerDir, ".fileTable.2");
        File fileTable3 = new File(managerDir, ".fileTable.3");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        String contents3 = "test reliable file contents #3";
        try {
            managerDir.mkdirs();
            this.writeToFile(fileTable, "#safe table\n" + fileName + "=2\n");
            this.writeToFile(file2, contents1);
            this.manager1 = new StorageManager(testDir, null);
            this.manager1.open(true);
            File test = this.manager1.lookup(fileName, false);
            StreamManagerTests.assertNotNull((Object)test);
            StreamManagerTests.assertTrue((boolean)test.exists());
            File testFile = this.manager1.createTempFile(fileName);
            this.writeToFile(testFile, contents2);
            this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
            testFile = this.manager1.createTempFile(fileName);
            this.writeToFile(testFile, contents3);
            this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
            testFile = this.manager1.createTempFile(fileName);
            this.writeToFile(testFile, contents1);
            this.manager1.update(new String[]{fileName}, new String[]{testFile.getName()});
            this.manager1.close();
            this.manager1 = null;
            String[] files = managerDir.list();
            StreamManagerTests.assertEquals((int)4, (int)files.length);
            StreamManagerTests.assertTrue((boolean)fileTable.exists());
            StreamManagerTests.assertFalse((boolean)fileTable1.exists());
            StreamManagerTests.assertTrue((boolean)fileTable2.exists());
            StreamManagerTests.assertTrue((boolean)fileTable3.exists());
            files = testDir.list();
            StreamManagerTests.assertEquals((int)2, (int)files.length);
            StreamManagerTests.assertTrue((boolean)file5.exists());
            this.manager2 = new StorageManager(testDir, null);
            this.manager2.open(true);
            testFile = this.manager2.lookup(fileName, false);
            StreamManagerTests.assertNotNull((Object)testFile);
            StreamManagerTests.assertTrue((boolean)testFile.exists());
            StreamManagerTests.assertTrue((boolean)testFile.getName().endsWith(".5"));
            this.manager2.close();
            this.manager2 = null;
        }
        catch (IOException e) {
            StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
        }
    }

    public void testAbort() {
        this.testAbort(true);
        this.testAbort(false);
    }

    private void testAbort(boolean reliable) {
        String fileName = reliable ? "abortFileReliable.txt" : "abortFileStd.txt";
        File file1 = new File(this.base, String.valueOf(fileName) + ".1");
        File file2 = new File(this.base, String.valueOf(fileName) + ".2");
        File file3 = new File(this.base, String.valueOf(fileName) + ".3");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        try {
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager1 = new StorageManager(this.base, null);
            this.manager1.open(true);
            ManagedOutputStream smos = this.manager1.getOutputStream(fileName);
            smos.write(contents1.getBytes());
            smos.close();
            smos = this.manager1.getOutputStream(fileName);
            smos.write(contents2.getBytes());
            smos.abort();
            smos.close();
            StreamManagerTests.assertEquals((int)1, (int)this.manager1.getId(fileName));
            InputStream is = this.manager1.getInputStream(fileName);
            StreamManagerTests.assertNotNull((Object)is);
            StreamManagerTests.assertEquals((String)contents1, (String)this.getInputStreamContents(is));
            this.manager1.close();
            this.manager1 = null;
            System.setProperty("osgi.useReliableFiles", "true");
            this.manager2 = new StorageManager(this.base, null);
            this.manager2.open(true);
            StreamManagerTests.assertEquals((int)1, (int)this.manager2.getId(fileName));
            is = this.manager2.getInputStream(fileName);
            StreamManagerTests.assertNotNull((Object)is);
            StreamManagerTests.assertEquals((String)contents1, (String)this.getInputStreamContents(is));
            this.manager2.close();
            this.manager2 = null;
            StreamManagerTests.assertTrue((boolean)file1.exists());
            StreamManagerTests.assertFalse((boolean)file2.exists());
            StreamManagerTests.assertFalse((boolean)file3.exists());
        }
        catch (IOException e) {
            StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
        }
    }

    public void testGetOutputStreamSet() {
        this.testGetOutputStreamSet(true);
        this.testGetOutputStreamSet(false);
    }

    private void testGetOutputStreamSet(boolean reliable) {
        File mgrDir = reliable ? new File(this.base, "getSetReliable") : new File(this.base, "getSetStd");
        String fileName1 = "testSet1.txt";
        String fileName2 = "testSet2.txt";
        File file1_1 = new File(mgrDir, String.valueOf(fileName1) + ".1");
        File file1_2 = new File(mgrDir, String.valueOf(fileName1) + ".2");
        File file2_1 = new File(mgrDir, String.valueOf(fileName2) + ".1");
        File file2_2 = new File(mgrDir, String.valueOf(fileName2) + ".2");
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        try {
            System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
            this.manager1 = new StorageManager(mgrDir, null);
            this.manager1.open(true);
            ManagedOutputStream[] outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2});
            StreamManagerTests.assertNotNull((Object)outs);
            StreamManagerTests.assertEquals((int)2, (int)outs.length);
            outs[0].write(contents1.getBytes());
            outs[1].write(contents2.getBytes());
            outs[1].close();
            StreamManagerTests.assertFalse((boolean)file1_1.exists());
            StreamManagerTests.assertFalse((boolean)file2_1.exists());
            outs[0].close();
            StreamManagerTests.assertTrue((boolean)file1_1.exists());
            StreamManagerTests.assertTrue((boolean)file2_1.exists());
            outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2});
            StreamManagerTests.assertNotNull((Object)outs);
            outs[0].write("new data #1".getBytes());
            outs[1].write("new data #2".getBytes());
            outs[0].close();
            StreamManagerTests.assertFalse((boolean)file1_2.exists());
            StreamManagerTests.assertFalse((boolean)file2_2.exists());
            outs[1].close();
            StreamManagerTests.assertTrue((boolean)file1_2.exists());
            StreamManagerTests.assertTrue((boolean)file2_2.exists());
            this.manager1.close();
            this.manager1 = null;
            if (reliable) {
                StreamManagerTests.assertTrue((boolean)file1_1.exists());
                StreamManagerTests.assertTrue((boolean)file2_1.exists());
            } else {
                StreamManagerTests.assertFalse((boolean)file1_1.exists());
                StreamManagerTests.assertFalse((boolean)file2_1.exists());
            }
        }
        catch (IOException e) {
            StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
        }
    }

    public void testAbortStreamSet() {
        this.testAbortSet(true);
        this.testAbortSet(false);
    }

    private void testAbortSet(boolean reliable) {
        File mgrDir = reliable ? new File(this.base, "abortSetReliable") : new File(this.base, "abortSetStd");
        String fileName1 = "test1.txt";
        String fileName2 = "test2.txt";
        String fileName3 = "test3.txt";
        String fileName4 = "test4.txt";
        String contents1 = "test reliable file contents #1";
        String contents2 = "test reliable file contents #2";
        try {
            mgrDir.mkdirs();
            String[] list = mgrDir.list();
            StreamManagerTests.assertEquals((int)0, (int)list.length);
            System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
            this.manager1 = new StorageManager(mgrDir, null);
            this.manager1.open(true);
            ManagedOutputStream[] outs = this.manager1.getOutputStreamSet(new String[]{fileName1, fileName2, fileName3, fileName4});
            StreamManagerTests.assertNotNull((Object)outs);
            outs[0].write(contents1.getBytes());
            outs[1].write(contents2.getBytes());
            outs[2].write(contents2.getBytes());
            outs[3].write(contents1.getBytes());
            list = mgrDir.list();
            StreamManagerTests.assertEquals((int)5, (int)list.length);
            outs[2].close();
            outs[1].abort();
            outs[0].close();
            outs[3].close();
            outs[2].close();
            outs[1].close();
            list = mgrDir.list();
            StreamManagerTests.assertEquals((int)1, (int)list.length);
            StreamManagerTests.assertNull((Object)this.manager1.lookup(fileName1, false));
            StreamManagerTests.assertNull((Object)this.manager1.lookup(fileName2, false));
            StreamManagerTests.assertNull((Object)this.manager1.lookup(fileName3, false));
            StreamManagerTests.assertNull((Object)this.manager1.lookup(fileName4, false));
            this.manager1.close();
            this.manager1 = null;
            System.setProperty("osgi.useReliableFiles", reliable ? "true" : "false");
            this.manager2 = new StorageManager(mgrDir, null);
            this.manager2.open(true);
            StreamManagerTests.assertNull((Object)this.manager2.lookup(fileName1, false));
            StreamManagerTests.assertNull((Object)this.manager2.lookup(fileName2, false));
            StreamManagerTests.assertNull((Object)this.manager2.lookup(fileName3, false));
            StreamManagerTests.assertNull((Object)this.manager2.lookup(fileName4, false));
            list = mgrDir.list();
            StreamManagerTests.assertEquals((int)1, (int)list.length);
            this.manager2.close();
            this.manager2 = null;
        }
        catch (IOException e) {
            StreamManagerTests.fail((String)"unexepected exception", (Throwable)e);
        }
    }
}

