/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.OSGiTest;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractStateTest
extends OSGiTest {
    private ServiceReference platformAdminRef;
    protected PlatformAdmin platformAdminService;

    protected void setUp() throws Exception {
        this.platformAdminRef = OSGiTestsActivator.getContext().getServiceReference(PlatformAdmin.class);
        this.platformAdminService = (PlatformAdmin)OSGiTestsActivator.getContext().getService(this.platformAdminRef);
    }

    protected void tearDown() throws Exception {
        OSGiTestsActivator.getContext().ungetService(this.platformAdminRef);
    }

    public AbstractStateTest(String testName) {
        super(testName);
    }

    public void assertContains(String tag, Object[] array, Object element) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return;
            }
            ++i;
        }
        AbstractStateTest.fail((String)tag);
    }

    public void assertEquals(State original, State copy) {
        this.assertEquals("", original, copy);
    }

    public void assertEquals(String tag, BundleDescription original, BundleDescription copy) {
        if (original == copy) {
            return;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".0"), (long)original.getBundleId(), (long)copy.getBundleId());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (String)original.getSymbolicName(), (String)copy.getSymbolicName());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (Object)original.getVersion(), (Object)copy.getVersion());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".3"), (String)original.getLocation(), (String)copy.getLocation());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".4"), (boolean)original.isResolved(), (boolean)copy.isResolved());
        this.assertEquals(String.valueOf(tag) + ".5", original.getHost(), copy.getHost());
        ExportPackageDescription[] originalExportPackages = original.getExportPackages();
        ExportPackageDescription[] copyExportPackages = copy.getExportPackages();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".6"), (int)originalExportPackages.length, (int)copyExportPackages.length);
        int i = 0;
        while (i < originalExportPackages.length) {
            this.assertEquals(String.valueOf(tag) + ".7." + i, originalExportPackages[i], copyExportPackages[i]);
            ++i;
        }
        ImportPackageSpecification[] originalImportPackages = original.getImportPackages();
        ImportPackageSpecification[] copyImportPackages = copy.getImportPackages();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".8"), (int)originalImportPackages.length, (int)copyImportPackages.length);
        int i2 = 0;
        while (i2 < originalImportPackages.length) {
            this.assertEquals(String.valueOf(tag) + ".9." + i2, originalImportPackages[i2], copyImportPackages[i2]);
            ++i2;
        }
        BundleSpecification[] originalRequiredBundles = original.getRequiredBundles();
        BundleSpecification[] copyRequiredBundles = copy.getRequiredBundles();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".10"), (int)originalRequiredBundles.length, (int)copyRequiredBundles.length);
        int i3 = 0;
        while (i3 < originalRequiredBundles.length) {
            this.assertEquals(String.valueOf(tag) + ".11." + i3, originalRequiredBundles[i3], copyRequiredBundles[i3]);
            ++i3;
        }
        ExportPackageDescription[] originalResolvedImports = original.getResolvedImports();
        ExportPackageDescription[] copyResolvedImports = copy.getResolvedImports();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".12"), (int)originalResolvedImports.length, (int)copyResolvedImports.length);
        int i4 = 0;
        while (i4 < originalResolvedImports.length) {
            this.assertEquals(String.valueOf(tag) + ".13." + i4, originalResolvedImports[i4], copyResolvedImports[i4]);
            ++i4;
        }
        BundleDescription[] originalResolvedRequires = original.getResolvedRequires();
        BundleDescription[] copyResolvedRequires = copy.getResolvedRequires();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".14"), (int)originalResolvedRequires.length, (int)copyResolvedRequires.length);
        int i5 = 0;
        while (i5 < originalResolvedRequires.length) {
            this.assertEquals(String.valueOf(tag) + ".15." + i5, originalResolvedRequires[i5], copyResolvedRequires[i5]);
            ++i5;
        }
    }

    public void assertEquals(String tag, ExportPackageDescription original, ExportPackageDescription copy) {
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".0"), (String)original.getName(), (String)copy.getName());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (Object)original.getVersion(), (Object)copy.getVersion());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (Object)original.getAttributes(), (Object)copy.getAttributes());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".3"), (Object)original.getDirectives(), (Object)original.getDirectives());
    }

    public void assertEquals(String tag, State original, State copy) {
        BundleDescription[] originalBundles = original.getBundles();
        BundleDescription[] copyBundles = copy.getBundles();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (int)originalBundles.length, (int)copyBundles.length);
        int i = 0;
        while (i < originalBundles.length) {
            this.assertEquals(String.valueOf(tag) + ".2." + i, originalBundles[i], copyBundles[i]);
            ++i;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".3"), (boolean)original.isResolved(), (boolean)copy.isResolved());
        BundleDescription[] originalResolvedBundles = original.getResolvedBundles();
        BundleDescription[] copyResolvedBundles = copy.getResolvedBundles();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".4"), (int)originalResolvedBundles.length, (int)copyResolvedBundles.length);
        int i2 = 0;
        while (i2 < originalResolvedBundles.length) {
            this.assertEquals(String.valueOf(tag) + ".5." + i2, originalResolvedBundles[i2], copyResolvedBundles[i2]);
            ++i2;
        }
    }

    private void assertVersionConstraintEquals(String tag, VersionConstraint original, VersionConstraint copy) {
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".0"), (original == null ? 1 : 0) != 0, (copy == null ? 1 : 0) != 0);
        if (original == null) {
            return;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (String)original.getName(), (String)copy.getName());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (Object)original.getVersionRange(), (Object)copy.getVersionRange());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".4"), (original.getSupplier() == null ? 1 : 0) != 0, (copy.getSupplier() == null ? 1 : 0) != 0);
        if (original.getSupplier() != null) {
            BaseDescription o = original.getSupplier();
            if (o instanceof BundleDescription) {
                this.assertEquals(String.valueOf(tag) + ".5", (BundleDescription)original.getSupplier(), (BundleDescription)copy.getSupplier());
            } else {
                this.assertEquals(String.valueOf(tag) + ".5", (ExportPackageDescription)original.getSupplier(), (ExportPackageDescription)copy.getSupplier());
            }
        }
    }

    public void assertEquals(String tag, BundleSpecification original, BundleSpecification copy) {
        this.assertVersionConstraintEquals(String.valueOf(tag) + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (boolean)original.isExported(), (boolean)copy.isExported());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (boolean)original.isOptional(), (boolean)copy.isOptional());
    }

    public void assertEquals(String tag, ImportPackageSpecification original, ImportPackageSpecification copy) {
        this.assertVersionConstraintEquals(String.valueOf(tag) + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (Object)original.getAttributes(), (Object)copy.getAttributes());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (String)original.getBundleSymbolicName(), (String)copy.getBundleSymbolicName());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".3"), (Object)original.getBundleVersionRange(), (Object)copy.getBundleVersionRange());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".5"), (Object)original.getDirectives(), (Object)original.getDirectives());
    }

    public void assertEquals(String tag, HostSpecification original, HostSpecification copy) {
        this.assertVersionConstraintEquals(String.valueOf(tag) + ".0", (VersionConstraint)original, (VersionConstraint)copy);
        if (original == null) {
            return;
        }
        BundleDescription[] originalHosts = original.getHosts();
        BundleDescription[] copyHosts = copy.getHosts();
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".1"), (originalHosts == null ? 1 : 0) != 0, (copyHosts == null ? 1 : 0) != 0);
        if (originalHosts == null) {
            return;
        }
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".2"), (int)originalHosts.length, (int)copyHosts.length);
        int i = 0;
        while (i < originalHosts.length) {
            this.assertEquals(String.valueOf(tag) + ".3." + i, originalHosts[i], copyHosts[i]);
            ++i;
        }
    }

    public void assertFullyResolved(String tag, BundleDescription bundle) {
        AbstractStateTest.assertTrue((String)(String.valueOf(tag) + "a"), (boolean)bundle.isResolved());
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i = 0;
        while (i < packages.length) {
            AbstractStateTest.assertNotNull((String)(String.valueOf(tag) + "b_" + i), (Object)packages[i].getSupplier());
            ++i;
        }
        HostSpecification host = bundle.getHost();
        if (host != null) {
            AbstractStateTest.assertNotNull((String)(String.valueOf(tag) + "c"), (Object)host.getHosts());
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            AbstractStateTest.assertNotNull((String)(String.valueOf(tag) + "d_" + i2), (Object)requiredBundles[i2].getSupplier());
            ++i2;
        }
    }

    public void assertFullyUnresolved(String tag, BundleDescription bundle) {
        AbstractStateTest.assertFalse((String)(String.valueOf(tag) + "a"), (boolean)bundle.isResolved());
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i = 0;
        while (i < packages.length) {
            AbstractStateTest.assertNull((String)(String.valueOf(tag) + "b_" + i), (Object)packages[i].getSupplier());
            ++i;
        }
        HostSpecification host = bundle.getHost();
        if (host != null) {
            AbstractStateTest.assertNull((String)(String.valueOf(tag) + "c"), (Object)host.getHosts());
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            AbstractStateTest.assertNull((String)(String.valueOf(tag) + "d_" + i2), (Object)requiredBundles[i2].getSupplier());
            ++i2;
        }
    }

    public void assertIdentical(String tag, State original, State copy) {
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".0a"), (boolean)original.isResolved(), (boolean)copy.isResolved());
        AbstractStateTest.assertEquals((String)(String.valueOf(tag) + ".0b"), (long)original.getTimeStamp(), (long)copy.getTimeStamp());
        this.assertEquals(tag, original, copy);
    }

    public State buildComplexState() throws BundleException {
        State state = this.buildEmptyState();
        BundleDescription b1 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2"), "org.eclipse.b1", 1L);
        state.addBundle(b1);
        BundleDescription b2 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1"), "org.eclipse.b2", 2L);
        state.addBundle(b2);
        BundleDescription b3 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2; specification-version=2.0"), "org.eclipse.b3", 3L);
        state.addBundle(b3);
        BundleDescription b4 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b4\nBundle-Version: 2.0\nRequire-Bundle: org.eclipse.b1"), "org.eclipse.b4", 4L);
        state.addBundle(b4);
        BundleDescription b5 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b5\nBundle-Version: 1.0\nFragment-Host: org.eclipse.b3"), "org.eclipse.b5", 5L);
        state.addBundle(b5);
        BundleDescription b6 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b6\nBundle-Version: 1.0\nRequire-Bundle: org.eclipse.b4"), "org.eclipse.b6", 6L);
        state.addBundle(b6);
        return state;
    }

    public State buildEmptyState() {
        return StateObjectFactory.defaultFactory.createState(true);
    }

    public State buildInitialState() throws BundleException {
        State state = this.buildEmptyState();
        BundleDescription b0 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.osgi.framework\nBundle-Version: 3.0\nExport-Package: org.osgi.framework; specification-version=3.0"), "org.eclipse.b1", 0L);
        state.addBundle(b0);
        return state;
    }

    public State buildSimpleState() throws BundleException {
        State state = this.buildEmptyState();
        BundleDescription b1 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\nExport-Package: org.eclipse.p1;specification-version=1.0\nImport-Package: org.eclipse.p2"), "org.eclipse.b1", 1L);
        state.addBundle(b1);
        BundleDescription b2 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nExport-Package: org.eclipse.p2\nImport-Package: org.eclipse.p1"), "org.eclipse.b2", 2L);
        state.addBundle(b2);
        BundleDescription b3 = state.getFactory().createBundleDescription(AbstractStateTest.parseManifest("Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nImport-Package: org.eclipse.p1; specification-version=2.0"), "org.eclipse.b3", 3L);
        state.addBundle(b3);
        return state;
    }

    public static Dictionary parseManifest(String manifest) {
        Hashtable<String, String> entries = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(manifest, ":\n");
        while (tokenizer.hasMoreTokens()) {
            String key = tokenizer.nextToken();
            String value = tokenizer.hasMoreTokens() ? tokenizer.nextToken().trim() : "";
            ((Dictionary)entries).put(key, value);
        }
        return entries;
    }
}

