/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DisabledInfoTest
extends AbstractStateTest {
    private final String B1_LOCATION = "b1";
    private final String B2_LOCATION = "b2";
    private final String B3_LOCATION = "b3";
    private final String POLICY = "test.policy";

    public static Test suite() {
        return new TestSuite(DisabledInfoTest.class);
    }

    public DisabledInfoTest(String name) {
        super(name);
    }

    public void testDisabledInfo01() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        State copy = state.getFactory().createState(state);
        BundleDescription copyB1 = copy.getBundleByLocation("b1");
        BundleDescription copyB2 = copy.getBundleByLocation("b2");
        BundleDescription copyB3 = copy.getBundleByLocation("b3");
        DisabledInfo copyInfo1 = copy.getDisabledInfo(copyB1, "test.policy");
        DisabledInfo copyInfo2 = copy.getDisabledInfo(copyB2, "test.policy");
        DisabledInfo copyInfo3 = copy.getDisabledInfo(copyB3, "test.policy");
        DisabledInfoTest.assertNotNull((String)"copyInfo1", (Object)copyInfo1);
        DisabledInfoTest.assertNotNull((String)"copyInfo2", (Object)copyInfo2);
        DisabledInfoTest.assertNotNull((String)"copyInfo3", (Object)copyInfo3);
        DisabledInfoTest.assertTrue((String)"copyInfo1 bundle", (copyInfo1.getBundle() == copyB1 ? 1 : 0) != 0);
        DisabledInfoTest.assertTrue((String)"copyInfo2 bundle", (copyInfo2.getBundle() == copyB2 ? 1 : 0) != 0);
        DisabledInfoTest.assertTrue((String)"copyInfo3 bundle", (copyInfo3.getBundle() == copyB3 ? 1 : 0) != 0);
    }

    public void testDisabledInfo02() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.resolve();
        DisabledInfoTest.assertTrue((String)"b1 resolved", (boolean)b1.isResolved());
        DisabledInfoTest.assertTrue((String)"b2 resolved", (boolean)b2.isResolved());
        DisabledInfoTest.assertTrue((String)"b3 resolved", (boolean)b3.isResolved());
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        state.resolve(false);
        DisabledInfoTest.assertFalse((String)"b1 resolved", (boolean)b1.isResolved());
        DisabledInfoTest.assertFalse((String)"b2 resolved", (boolean)b2.isResolved());
        DisabledInfoTest.assertFalse((String)"b3 resolved", (boolean)b3.isResolved());
    }

    public void testDisabledInfo03() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        BundleContext context = OSGiTestsActivator.getContext();
        File stateDir = context.getDataFile("testDisabledInfo03");
        stateDir.mkdirs();
        try {
            state.getFactory().writeState(state, stateDir);
            State copy = state.getFactory().readState(stateDir);
            BundleDescription copyB1 = copy.getBundleByLocation("b1");
            BundleDescription copyB2 = copy.getBundleByLocation("b2");
            BundleDescription copyB3 = copy.getBundleByLocation("b3");
            DisabledInfo copyInfo1 = copy.getDisabledInfo(copyB1, "test.policy");
            DisabledInfo copyInfo2 = copy.getDisabledInfo(copyB2, "test.policy");
            DisabledInfo copyInfo3 = copy.getDisabledInfo(copyB3, "test.policy");
            DisabledInfoTest.assertNotNull((String)"copyInfo1", (Object)copyInfo1);
            DisabledInfoTest.assertNotNull((String)"copyInfo2", (Object)copyInfo2);
            DisabledInfoTest.assertNotNull((String)"copyInfo3", (Object)copyInfo3);
            DisabledInfoTest.assertTrue((String)"copyInfo1 bundle", (copyInfo1.getBundle() == copyB1 ? 1 : 0) != 0);
            DisabledInfoTest.assertTrue((String)"copyInfo2 bundle", (copyInfo2.getBundle() == copyB2 ? 1 : 0) != 0);
            DisabledInfoTest.assertTrue((String)"copyInfo3 bundle", (copyInfo3.getBundle() == copyB3 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            DisabledInfoTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testDisabledInfo04() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        BundleDescription b3 = state.getBundleByLocation("b3");
        DisabledInfo info1 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info2 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info3 = new DisabledInfo("test.policy", "message 1", b3);
        state.resolve();
        DisabledInfoTest.assertTrue((String)"b1 resolved", (boolean)b1.isResolved());
        DisabledInfoTest.assertTrue((String)"b2 resolved", (boolean)b2.isResolved());
        DisabledInfoTest.assertTrue((String)"b3 resolved", (boolean)b3.isResolved());
        state.addDisabledInfo(info1);
        state.addDisabledInfo(info2);
        state.addDisabledInfo(info3);
        BundleDescription[] disabledBundles = state.getDisabledBundles();
        DisabledInfoTest.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        DisabledInfoTest.assertEquals((String)"disabledBundles length", (int)3, (int)disabledBundles.length);
        DisabledInfoTest.assertTrue((String)"b1 not found", (disabledBundles[0] == b1 || disabledBundles[1] == b1 || disabledBundles[2] == b1 ? 1 : 0) != 0);
        DisabledInfoTest.assertTrue((String)"b2 not found", (disabledBundles[0] == b2 || disabledBundles[1] == b2 || disabledBundles[2] == b2 ? 1 : 0) != 0);
        DisabledInfoTest.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 || disabledBundles[1] == b3 || disabledBundles[2] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info1);
        disabledBundles = state.getDisabledBundles();
        DisabledInfoTest.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        DisabledInfoTest.assertEquals((String)"disabledBundles length", (int)2, (int)disabledBundles.length);
        DisabledInfoTest.assertTrue((String)"b2 not found", (disabledBundles[0] == b2 || disabledBundles[1] == b2 ? 1 : 0) != 0);
        DisabledInfoTest.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 || disabledBundles[1] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info2);
        disabledBundles = state.getDisabledBundles();
        DisabledInfoTest.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        DisabledInfoTest.assertEquals((String)"disabledBundles length", (int)1, (int)disabledBundles.length);
        DisabledInfoTest.assertTrue((String)"b3 not found", (disabledBundles[0] == b3 ? 1 : 0) != 0);
        state.removeDisabledInfo(info3);
        disabledBundles = state.getDisabledBundles();
        DisabledInfoTest.assertNotNull((String)"disabledBundles", (Object)disabledBundles);
        DisabledInfoTest.assertEquals((String)"disabledBundles length", (int)0, (int)disabledBundles.length);
    }

    public void testBug251427() throws BundleException {
        State state = this.buildTestState();
        BundleDescription b1 = state.getBundleByLocation("b1");
        BundleDescription b2 = state.getBundleByLocation("b2");
        DisabledInfo info11 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info12 = new DisabledInfo("test.policy", "message 1", b1);
        DisabledInfo info21 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfo info22 = new DisabledInfo("test.policy", "message 1", b2);
        DisabledInfoTest.assertEquals((String)"infos not equal", (Object)info11, (Object)info12);
        DisabledInfoTest.assertEquals((String)"infos hashCode not equal", (int)info11.hashCode(), (int)info12.hashCode());
        DisabledInfoTest.assertEquals((String)"infos not equal", (Object)info21, (Object)info22);
        DisabledInfoTest.assertEquals((String)"infos hashCode not equal", (int)info21.hashCode(), (int)info22.hashCode());
    }

    private State buildTestState() throws BundleException {
        State state = this.buildEmptyState();
        BundleDescription b1 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b1\nBundle-Version: 1.0\nImport-Package: b2"), "b1", 1L);
        state.addBundle(b1);
        BundleDescription b2 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b2\nBundle-Version: 1.0\nExport-Package: b2\nImport-Package: b3"), "b2", 2L);
        state.addBundle(b2);
        BundleDescription b3 = state.getFactory().createBundleDescription(state, DisabledInfoTest.parseManifest("Bundle-ManifestVersion: 1\nBundle-SymbolicName: b3\nBundle-Version: 1.0\nExport-Package: b3; version=1.0"), "b3", 3L);
        state.addBundle(b3);
        return state;
    }
}

