/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class GenericCapabilityTest
extends AbstractStateTest {
    static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";

    public static Test suite() {
        return new TestSuite(GenericCapabilityTest.class);
    }

    public GenericCapabilityTest(String name) {
        super(name);
    }

    public void testGenericsBasics() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer required = new StringBuffer();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)genCap.getGenericCapabilities()[3]);
    }

    public void testGenericsUpdate() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer required = new StringBuffer();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version>=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)genCap.getGenericCapabilities()[3]);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "2.0.0");
        capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.2\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.2\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.1\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), genCap.getBundleId());
        state.updateBundle(genCap2);
        state.resolve(new BundleDescription[]{genCap2});
        GenericCapabilityTest.assertTrue((String)"3.0", (boolean)genCap2.isResolved());
        GenericCapabilityTest.assertTrue((String)"3.1", (boolean)genReq.isResolved());
        genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"4.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"4.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap2.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"4.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap2.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"4.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap2.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"4.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.4.1", (Object)genSpecs[3].getSupplier(), (Object)genCap2.getGenericCapabilities()[3]);
    }

    public void testGenericsRefresh() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer required = new StringBuffer();
        required.append("genericCapability:osgi.identity; selection-filter=\"(version>=1.0)\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)genCap.getGenericCapabilities()[3]);
        state.resolve(new BundleDescription[]{genCap});
        GenericCapabilityTest.assertTrue((String)"3.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"3.1", (boolean)genReq.isResolved());
        genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"4.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"4.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"4.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"4.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"4.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"4.4.1", (Object)genSpecs[3].getSupplier(), (Object)genCap.getGenericCapabilities()[3]);
    }

    public void testGenericsFrags() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability.frag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "genericCapability;bundle-version=\"[1.0.0,2.0.0)\"");
        capabililty = new StringBuffer();
        capabililty.append("fragmentStuff");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCapFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer required = new StringBuffer();
        required.append("genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("fragmentStuff,");
        required.append("genericCapability.frag1:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genCapFrag);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.2", (boolean)genCapFrag.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericDescription[] selectedHostCapabilities = genCap.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragCapabilities = genCapFrag.getSelectedGenericCapabilities();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 6 ? 1 : 0) != 0);
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected capabilities", (int)5, (int)selectedHostCapabilities.length);
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected capabilities", (int)1, (int)selectedFragCapabilities.length);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)selectedHostCapabilities[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)selectedHostCapabilities[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)selectedHostCapabilities[2]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)selectedHostCapabilities[3]);
        GenericCapabilityTest.assertTrue((String)"2.5", (boolean)genSpecs[4].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.5.1", (Object)genSpecs[4].getSupplier(), (Object)selectedHostCapabilities[4]);
        GenericCapabilityTest.assertTrue((String)"2.6", (boolean)genSpecs[5].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.6.1", (Object)genSpecs[5].getSupplier(), (Object)selectedFragCapabilities[0]);
    }

    public void testGenericsIntraFrags() throws BundleException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.frag.a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.equinox.generic.host;bundle-version=\"1.0.0\"");
        manifest.put(GENERIC_CAPABILITY, "frag.a");
        BundleDescription genFragA = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.host");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription genHost = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.equinox.generic.frag.b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.equinox.generic.host;bundle-version=\"1.0.0\"");
        StringBuffer required = new StringBuffer();
        required.append("org.eclipse.equinox.generic.host:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("frag.a,");
        required.append("org.eclipse.equinox.generic.frag.a:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\",");
        required.append("org.eclipse.equinox.generic.frag.b:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.fragment))\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genFragB = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genHost);
        state.addBundle(genFragA);
        state.addBundle(genFragB);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genHost.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genFragA.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.2", (boolean)genFragB.isResolved());
        GenericSpecification[] genSpecs = genFragB.getGenericRequires();
        GenericDescription[] selected = genHost.getSelectedGenericCapabilities();
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected", (int)2, (int)selected.length);
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericDescription[] selectedHostCapabilities = genHost.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragACapabilities = genFragA.getSelectedGenericCapabilities();
        GenericDescription[] selectedFragBCapabilities = genFragB.getSelectedGenericCapabilities();
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected capabilities", (int)2, (int)selectedHostCapabilities.length);
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected capabilities", (int)1, (int)selectedFragACapabilities.length);
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected capabilities", (int)1, (int)selectedFragBCapabilities.length);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)selectedHostCapabilities[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)selectedHostCapabilities[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)selectedFragACapabilities[0]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)selectedFragBCapabilities[0]);
    }

    public void testGenericsAliases() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] allPlatProps = state.getPlatformProperties();
        Dictionary platProps = (Dictionary)((Hashtable)allPlatProps[0]).clone();
        platProps.put("osgi.genericAliases", "Export-Service:Import-Service:service,TJW-Export:TJW-Import:tjw");
        state.setPlatformProperties(platProps);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Service", "org.osgi.service.log.LogService; version=1.2");
        manifest.put("TJW-Export", "my.great.stuff; aLong:long=5150; aDouble:double=3.14; aVersion:version=1.2.0");
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Service", "org.osgi.service.log.LogService; selection-filter=(version>=1.0.0)");
        manifest.put("TJW-Import", "my.great.stuff; selection-filter=(&(aLong<=10000)(aLong>=5000))");
        manifest.put(GENERIC_REQUIRE, "genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\"");
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 3 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
    }

    public void testGenericsOptionalMultiple() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\",");
        capabililty.append("test.real.optional:thisisoptional,");
        capabililty.append("test.real.multiple:thisismultiple; version=1.0,");
        capabililty.append("test.real.multiple:thisismultiple; version=2.0");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer required = new StringBuffer();
        required.append("genericCapability:osgi.identity; selection-filter=\"(&(version=1.0.0)(type=osgi.bundle))\",");
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("test.optional:thisisoptional; optional=true,");
        required.append("test.real.optional:thisisoptional; optional=true,");
        required.append("test.real.multiple:thisismultiple; multiple=true");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 7 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)genCap.getGenericCapabilities()[0]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)genCap.getGenericCapabilities()[1]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)genCap.getGenericCapabilities()[2]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[3].getSupplier(), (Object)genCap.getGenericCapabilities()[3]);
        GenericCapabilityTest.assertFalse((String)"2.4", (boolean)genSpecs[4].isResolved());
        GenericCapabilityTest.assertTrue((String)"2.5", (boolean)genSpecs[5].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.5.1", (Object)genSpecs[5].getSupplier(), (Object)genCap.getGenericCapabilities()[4]);
        GenericCapabilityTest.assertTrue((String)"2.6", (boolean)genSpecs[6].isResolved());
        GenericDescription[] suppliers = genSpecs[6].getSuppliers();
        GenericCapabilityTest.assertTrue((String)"2.6.1", (suppliers != null && suppliers.length == 2 ? 1 : 0) != 0);
        GenericCapabilityTest.assertEquals((String)"2.6.2", (Object)suppliers[0], (Object)genCap.getGenericCapabilities()[6]);
        GenericCapabilityTest.assertEquals((String)"2.6.3", (Object)suppliers[1], (Object)genCap.getGenericCapabilities()[5]);
    }

    public void testGenericsCycles() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapablity");
        manifest.put("Bundle-Version", "1.0.0");
        StringBuffer capabililty = new StringBuffer();
        capabililty.append("foo; version=\"1.3.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("bar:bartype; version=\"1.4.1\"; attr1=\"value1\"; attr2=\"value2\",");
        capabililty.append("test.types:testtype;");
        capabililty.append(" aVersion:version=\"2.0.0\";");
        capabililty.append(" aLong:long=\"10000000000\";");
        capabililty.append(" aDouble:double=\"1.000109\";");
        capabililty.append(" aUri:uri=\"file:/test\";");
        capabililty.append(" aSet:set=\"a,b,c,d\";");
        capabililty.append(" aString:string=\"someString\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        StringBuffer required = new StringBuffer();
        required.append("foo:cycle; selection-filter=\"(version>=1.3.0)\"");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genCap = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericCapability.frag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "genericCapablity;bundle-version=\"[1.0.0,2.0.0)\"");
        capabililty = new StringBuffer();
        capabililty.append("fragmentStuff");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        BundleDescription genCapFrag = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "genericRequire");
        manifest.put("Bundle-Version", "1.0.0");
        capabililty = new StringBuffer();
        capabililty.append("foo:cycle; version:version=\"2.0\"");
        manifest.put(GENERIC_CAPABILITY, capabililty.toString());
        required = new StringBuffer();
        required.append("foo; selection-filter=\"(version>=1.3.0)\",");
        required.append("bar:bartype; selection-filter=\"(attr1=value1)\",");
        required.append("test.types:testtype; selection-filter=\"(&(aVersion>=2.0.0)(aLong>=5555)(aDouble>=1.00)(aUri=file:/test)(aSet=c)(aString=someString))\",");
        required.append("fragmentStuff");
        manifest.put(GENERIC_REQUIRE, required.toString());
        BundleDescription genReq = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(genCap);
        state.addBundle(genCapFrag);
        state.addBundle(genReq);
        state.resolve();
        GenericCapabilityTest.assertTrue((String)"1.0", (boolean)genCap.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.1", (boolean)genReq.isResolved());
        GenericCapabilityTest.assertTrue((String)"1.2", (boolean)genCapFrag.isResolved());
        GenericSpecification[] genSpecs = genReq.getGenericRequires();
        GenericDescription[] selected = genCap.getSelectedGenericCapabilities();
        GenericCapabilityTest.assertTrue((String)"2.0", (genSpecs.length == 4 ? 1 : 0) != 0);
        GenericCapabilityTest.assertEquals((String)"Wrong number of selected", (int)5, (int)selected.length);
        GenericCapabilityTest.assertTrue((String)"2.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.1.1", (Object)genSpecs[0].getSupplier(), (Object)selected[1]);
        GenericCapabilityTest.assertTrue((String)"2.2", (boolean)genSpecs[1].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.2.1", (Object)genSpecs[1].getSupplier(), (Object)selected[2]);
        GenericCapabilityTest.assertTrue((String)"2.3", (boolean)genSpecs[2].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.3.1", (Object)genSpecs[2].getSupplier(), (Object)selected[3]);
        GenericCapabilityTest.assertTrue((String)"2.4", (boolean)genSpecs[3].isResolved());
        GenericCapabilityTest.assertEquals((String)"2.4.1", (Object)genSpecs[3].getSupplier(), (Object)selected[4]);
        genSpecs = genCap.getGenericRequires();
        GenericCapabilityTest.assertTrue((String)"3.0", (genSpecs.length == 1 ? 1 : 0) != 0);
        GenericCapabilityTest.assertTrue((String)"3.1", (boolean)genSpecs[0].isResolved());
        GenericCapabilityTest.assertEquals((String)"3.1.1", (Object)genSpecs[0].getSupplier(), (Object)genReq.getGenericCapabilities()[1]);
    }
}

