/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class NewResolverTest
extends AbstractStateTest {
    public NewResolverTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(NewResolverTest.class);
    }

    public void testSkeleton() {
        State state = this.buildEmptyState();
        state.resolve();
    }

    public void testBasicScenario1() throws BundleException {
        State state = this.buildEmptyState();
        BundleDescription bA = state.getFactory().createBundleDescription(NewResolverTest.parseManifest("Bundle-SymbolicName: A\nExport-Package: servlet; specification-version=2.1"), "org.eclipse.basic1A", 0L);
        state.addBundle(bA);
        BundleDescription bB = state.getFactory().createBundleDescription(NewResolverTest.parseManifest("Bundle-SymbolicName: B\nImport-Package: servlet; specification-version=2.1"), "org.eclipse.basic1B", 1L);
        state.addBundle(bB);
        state.resolve();
        BundleDescription b0 = state.getBundle(0L);
        NewResolverTest.assertNotNull((String)"0.1", (Object)b0);
        this.assertFullyResolved("0.2", b0);
        BundleDescription b1 = state.getBundle(1L);
        NewResolverTest.assertNotNull((String)"0.3", (Object)b1);
        this.assertFullyResolved("0.4", b1);
    }
}

