/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class SubstitutableExportsTest
extends AbstractStateTest {
    public static Test suite() {
        return new TestSuite(SubstitutableExportsTest.class);
    }

    public SubstitutableExportsTest(String name) {
        super(name);
    }

    private State getSubstituteBasicState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteUsesState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z, z; uses:=x; version=1.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        return state;
    }

    private State getSubstituteUsesCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=0.5");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        manifest.put("Import-Package", "z");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        manifest.put("Import-Package", "z");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "z");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=x");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=x");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        return state;
    }

    private State getSubstituteBasicFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteUsesFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        return state;
    }

    private State getSubstituteUsesFragCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=2.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=\"[1.0,2.0)\", q");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "q; version=1.0; uses:=x");
        manifest.put("Import-Package", "q; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "q; version=1.0; uses:=x");
        manifest.put("Import-Package", "q; version=1.0");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Import-Package", "q; x; version=1.0");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        return state;
    }

    private State getSubstituteBasicReexportState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        return state;
    }

    private State getSubstituteUsesReexportState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; version=0.5; bundle=Z");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y\"");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        manifest.put("Import-Package", "x;  bundle=Z");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteUsesReexportCycleState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; z; version=2.0");
        BundleDescription z = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,z\"");
        manifest.put("Import-Package", "x; y; z; version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B; visibility:=reexport");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C; visibility:=reexport");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        manifest.put("Export-Package", "z; version=1.0; uses=\"x,y\"");
        manifest.put("Import-Package", "z; version=\"[1.0,2.0)\"");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(z);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteUnresolvedFragState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; q; version=1.0");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "BFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "B");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z; q; version=1.0");
        BundleDescription bFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "CFrag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "C");
        manifest.put("Export-Package", "z; version=1.0");
        manifest.put("Import-Package", "z, q; version=1.0");
        BundleDescription cFrag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(bFrag);
        state.addBundle(c);
        state.addBundle(cFrag);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    private State getSubstituteSplitState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split");
        manifest.put("Import-Package", "x; y; version=1.0; split=split");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        return state;
    }

    private State getSubstituteSplitUsesState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; split=split; mandatory:=split; uses:=\"x,y,q\"");
        manifest.put("Import-Package", "x; y; version=1.0; split=split, q; version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0; uses:=\"x,y,r\"");
        manifest.put("Import-Package", "x; y; version=1.0, r; version=\"[1.0,2.0)\"");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "D");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "I");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "E");
        BundleDescription i = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "J");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "F");
        BundleDescription j = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "K");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; r; version=2.0");
        BundleDescription k = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "L");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; r; version=1.0");
        BundleDescription l = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "M");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "x, y, q, r");
        BundleDescription m = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "N");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "q, r");
        manifest.put("Require-Bundle", "F");
        BundleDescription n = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.addBundle(i);
        state.addBundle(j);
        state.addBundle(k);
        state.addBundle(l);
        state.addBundle(m);
        state.addBundle(n);
        return state;
    }

    private State getNonOverlapingSubstituteBasicState() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0; nomatch=nomatch");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x; y; version=1.0");
        manifest.put("Import-Package", "x; y; version=1.0");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "A");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "B");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        return state;
    }

    public void testSubstitutableExports001() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        Object[] aExports = a.getSelectedExports();
        Object[] aSubtitutes = new ExportPackageDescription[]{aExports[0], aExports[1]};
        this.assertEquals("aVisible not correct", aExports, a.getExportPackages());
        this.assertEquals("bVisible not correct", aSubtitutes, bVisible);
        this.assertEquals("cVisible not correct", aSubtitutes, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aSubtitutes, eVisible);
        this.assertEquals("fVisible not correct", aSubtitutes, fVisible);
    }

    public void testSubstitutableExports002() throws BundleException {
        State state = this.getSubstituteUsesState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.6", (boolean)g.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)0, (int)gVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("aVisible not correct", aExports, a.getExportPackages());
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
    }

    public void testSubstitutableExports003() throws BundleException {
        State state = this.getSubstituteUsesCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)1, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)3, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)3, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)3, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)3, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)2, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)3, (int)hVisible.length);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] gExported = g.getSelectedExports();
        ExportPackageDescription[] expected = new ExportPackageDescription[aExported.length + gExported.length];
        System.arraycopy(aExported, 0, expected, 0, aExported.length);
        System.arraycopy(gExported, 0, expected, aExported.length, gExported.length);
        int i = 0;
        while (i < expected.length) {
            if (i == 2) {
                this.assertContains("aVisible not correct", aVisible, expected[i]);
            }
            this.assertContains("bVisible not correct", bVisible, expected[i]);
            this.assertContains("cVisible not correct", cVisible, expected[i]);
            this.assertContains("dVisible not correct", dVisible, expected[i]);
            this.assertContains("eVisible not correct", eVisible, expected[i]);
            this.assertContains("fVisible not correct", fVisible, expected[i]);
            if (i == 0 || i == 1) {
                this.assertContains("gVisible not correct", gVisible, expected[i]);
            }
            this.assertContains("hVisible not correct", hVisible, expected[i]);
            ++i;
        }
    }

    public void testSubstitutableExports004() throws BundleException {
        State state = this.getSubstituteBasicFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"aFragVisible wrong number", (int)0, (int)aFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bFragVisible wrong number", (int)1, (int)bFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cFragVisible wrong number", (int)1, (int)cFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)3, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)3, (int)fVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"a has wrong number of exports", (int)3, (int)aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        this.assertEquals("bVisible not correct", aDeclaredExports, bVisible);
        this.assertEquals("bFragVisible not correct", aFragExports, bFragVisible);
        this.assertEquals("cVisible not correct", aDeclaredExports, cVisible);
        this.assertEquals("cFragVisible not correct", aFragExports, cFragVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
    }

    public void testSubstitutableExports005() throws BundleException {
        State state = this.getSubstituteUsesFragState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.6", (boolean)g.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"aFragVisible wrong number", (int)0, (int)aFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bFragVisible wrong number", (int)1, (int)bFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cFragVisible wrong number", (int)1, (int)cFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)3, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)3, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)0, (int)gVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"a has wrong number of exports", (int)3, (int)aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        this.assertEquals("bVisible not correct", aDeclaredExports, bVisible);
        this.assertEquals("bFragVisible not correct", aFragExports, bFragVisible);
        this.assertEquals("cVisible not correct", aDeclaredExports, cVisible);
        this.assertEquals("cFragVisible not correct", aFragExports, cFragVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
    }

    public void testSubstitutableExports006() throws BundleException {
        State state = this.getSubstituteUsesFragCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        BundleDescription h = state.getBundle(11L);
        BundleDescription i = state.getBundle(12L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)i.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)1, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"aFragVisible wrong number", (int)0, (int)aFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)3, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bFragVisible wrong number", (int)1, (int)bFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)3, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cFragVisible wrong number", (int)1, (int)cFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)3, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)3, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)3, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)4, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)4, (int)iVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"a has wrong number of exports", (int)3, (int)aExports.length);
        ExportPackageDescription[] aDeclaredExports = a.getExportPackages();
        Object[] bcExpectedVisible = new ExportPackageDescription[aDeclaredExports.length + 1];
        System.arraycopy(aDeclaredExports, 0, bcExpectedVisible, 0, aDeclaredExports.length);
        bcExpectedVisible[2] = g.getSelectedExports()[0];
        Object[] aFragExports = new ExportPackageDescription[]{aExports[2]};
        this.assertEquals("aVisible not correct", g.getSelectedExports(), aVisible);
        this.assertEquals("bVisible not correct", bcExpectedVisible, bVisible);
        this.assertEquals("bFragVisible not correct", aFragExports, bFragVisible);
        this.assertEquals("cVisible not correct", bcExpectedVisible, cVisible);
        this.assertEquals("cFragVisible not correct", aFragExports, cFragVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        ExportPackageDescription[] gExports = g.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"g has wrong number of exports", (int)1, (int)gExports.length);
        Object[] expectedHIVisible = new ExportPackageDescription[]{gExports[0], aExports[0], aExports[1], aExports[2]};
        this.assertEquals("gVisible not correct", aExports, gVisible);
        this.assertEquals("hVisible not correct", expectedHIVisible, hVisible);
        this.assertEquals("iVisible not correct", expectedHIVisible, iVisible);
    }

    public void testSubstitutableExports007() throws BundleException {
        State state = this.getSubstituteBasicReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(5L);
        BundleDescription h = state.getBundle(5L);
        BundleDescription i = state.getBundle(5L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)i.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)2, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)2, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)2, (int)iVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        this.assertEquals("gVisible not correct", aExports, gVisible);
        this.assertEquals("hVisible not correct", aExports, hVisible);
        this.assertEquals("iVisible not correct", aExports, iVisible);
    }

    public void testSubstitutableExports008() throws BundleException {
        State state = this.getSubstituteUsesReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.8", (boolean)i.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.9", (boolean)j.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        ExportPackageDescription[] jVisible = state.getStateHelper().getVisiblePackages(j);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertNotNull((String)"jVisible is null", (Object)jVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)2, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)2, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)2, (int)iVisible.length);
        SubstitutableExportsTest.assertEquals((String)"jVisible wrong number", (int)0, (int)jVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        this.assertEquals("gVisible not correct", aExports, gVisible);
        this.assertEquals("hVisible not correct", aExports, hVisible);
        this.assertEquals("iVisible not correct", aExports, iVisible);
    }

    public void testSubstitutableExports009() throws BundleException {
        State state = this.getSubstituteUsesReexportCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.8", (boolean)i.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)j.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertNotNull((String)"jVisible is null", (Object)jVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)1, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)3, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)3, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)2, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)2, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)2, (int)iVisible.length);
        SubstitutableExportsTest.assertEquals((String)"jVisible wrong number", (int)2, (int)jVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"aExports count wrong", (int)2, (int)aExports.length);
        Object[] jExports = j.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"aExports count wrong", (int)1, (int)jExports.length);
        Object[] bcExpected = new ExportPackageDescription[]{aExports[0], aExports[1], jExports[0]};
        this.assertEquals("aVisible not correct", jExports, aVisible);
        this.assertEquals("bVisible not correct", bcExpected, bVisible);
        this.assertEquals("cVisible not correct", bcExpected, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        this.assertEquals("gVisible not correct", aExports, gVisible);
        this.assertEquals("hVisible not correct", aExports, hVisible);
        this.assertEquals("iVisible not correct", aExports, iVisible);
        this.assertEquals("jVisible not correct", aExports, jVisible);
    }

    public void testSubstitutableExports010() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription[] allBundles = new BundleDescription[]{a, b, c, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)6, (int)bundleDeltas.length);
        int i = 0;
        while (i < allBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allBundles[i]));
            }
            ++i;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
    }

    public void testSubstitutableExports011() throws BundleException {
        State state = this.getSubstituteUsesState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)6, (int)bundleDeltas.length);
        int i = 0;
        while (i < allRefreshBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allRefreshBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[i]));
            }
            ++i;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
    }

    public void testSubstitutableExports012() throws BundleException {
        int j;
        boolean found;
        State state = this.getSubstituteUsesCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)8, (int)bundleDeltas.length);
        int i = 0;
        while (i < allRefreshBundles.length) {
            found = false;
            j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allRefreshBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[i]));
            }
            ++i;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)8, (int)bundleDeltas.length);
        i = 0;
        while (i < allRefreshBundles.length) {
            found = false;
            j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allRefreshBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[i]));
            }
            ++i;
        }
    }

    public void testSubstitutableExports013() throws BundleException {
        State state = this.getSubstituteBasicFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        BundleDescription[] allBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)9, (int)bundleDeltas.length);
        int i = 0;
        while (i < allBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allBundles[i]));
            }
            ++i;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{c, cFrag, f};
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)3, (int)bundleDeltas.length);
        int i2 = 0;
        while (i2 < expectedRefresh.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == expectedRefresh[i2];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + expectedRefresh[i2]));
            }
            ++i2;
        }
    }

    public void testSubstitutableExports014() throws BundleException {
        State state = this.getSubstituteUsesFragState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        int i = 0;
        while (i < allRefreshBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == allRefreshBundles[i];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[i]));
            }
            ++i;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{c, cFrag, f};
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)3, (int)bundleDeltas.length);
        int i2 = 0;
        while (i2 < expectedRefresh.length) {
            boolean found = false;
            int j = 0;
            while (j < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[j]), (int)8, (int)bundleDeltas[j].getType());
                found = bundleDeltas[j].getBundle() == expectedRefresh[i2];
                ++j;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + expectedRefresh[i2]));
            }
            ++i2;
        }
    }

    public void testSubstitutableExports015() throws BundleException {
        int k;
        boolean found;
        State state = this.getSubstituteUsesFragCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription aFrag = state.getBundle(2L);
        BundleDescription b = state.getBundle(3L);
        BundleDescription bFrag = state.getBundle(4L);
        BundleDescription c = state.getBundle(5L);
        BundleDescription cFrag = state.getBundle(6L);
        BundleDescription d = state.getBundle(7L);
        BundleDescription e = state.getBundle(8L);
        BundleDescription f = state.getBundle(9L);
        BundleDescription g = state.getBundle(10L);
        BundleDescription h = state.getBundle(11L);
        BundleDescription i = state.getBundle(12L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, aFrag, b, bFrag, c, cFrag, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        int j = 0;
        while (j < allRefreshBundles.length) {
            found = false;
            k = 0;
            while (k < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[k]), (int)8, (int)bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == allRefreshBundles[j];
                ++k;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[j]));
            }
            ++j;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        j = 0;
        while (j < allRefreshBundles.length) {
            found = false;
            k = 0;
            while (k < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[k]), (int)8, (int)bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == allRefreshBundles[j];
                ++k;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[j]));
            }
            ++j;
        }
    }

    public void testSubstitutableExports016() throws BundleException {
        State state = this.getSubstituteBasicReexportState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription[] allBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allBundles.length, (int)bundleDeltas.length);
        int j = 0;
        while (j < allBundles.length) {
            boolean found = false;
            int k = 0;
            while (k < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[k]), (int)8, (int)bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == allBundles[j];
                ++k;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allBundles[j]));
            }
            ++j;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{f, i};
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)expectedRefresh.length, (int)bundleDeltas.length);
        int j2 = 0;
        while (j2 < expectedRefresh.length) {
            boolean found = false;
            int k = 0;
            while (k < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[k]), (int)8, (int)bundleDeltas[k].getType());
                found = bundleDeltas[k].getBundle() == expectedRefresh[j2];
                ++k;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + expectedRefresh[j2]));
            }
            ++j2;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
    }

    public void testSubstitutableExports017() throws BundleException {
        State state = this.getSubstituteUsesReexportState();
        state.resolve();
        BundleDescription z = state.getBundle(0L);
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        int l = 0;
        while (l < allRefreshBundles.length) {
            boolean found = false;
            int m = 0;
            while (m < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[m]), (int)8, (int)bundleDeltas[m].getType());
                found = bundleDeltas[m].getBundle() == allRefreshBundles[l];
                ++m;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[l]));
            }
            ++l;
        }
        stateDelta = state.resolve(new BundleDescription[]{f});
        bundleDeltas = stateDelta.getChanges();
        BundleDescription[] expectedRefresh = new BundleDescription[]{f, i};
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)expectedRefresh.length, (int)bundleDeltas.length);
        int l2 = 0;
        while (l2 < expectedRefresh.length) {
            boolean found = false;
            int m = 0;
            while (m < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[m]), (int)8, (int)bundleDeltas[m].getType());
                found = bundleDeltas[m].getBundle() == expectedRefresh[l2];
                ++m;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + expectedRefresh[l2]));
            }
            ++l2;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{z});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
    }

    public void testSubstitutableExports018() throws BundleException {
        int l;
        boolean found;
        State state = this.getSubstituteUsesReexportCycleState();
        state.resolve();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        BundleDescription h = state.getBundle(8L);
        BundleDescription i = state.getBundle(9L);
        BundleDescription j = state.getBundle(10L);
        BundleDescription[] allRefreshBundles = new BundleDescription[]{a, b, c, d, e, f, g, h, i, j};
        StateDelta stateDelta = state.resolve(new BundleDescription[]{a});
        BundleDelta[] bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        int k = 0;
        while (k < allRefreshBundles.length) {
            found = false;
            l = 0;
            while (l < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[l]), (int)8, (int)bundleDeltas[l].getType());
                found = bundleDeltas[l].getBundle() == allRefreshBundles[k];
                ++l;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[k]));
            }
            ++k;
        }
        stateDelta = state.resolve(new BundleDescription[]{i});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)1, (int)bundleDeltas.length);
        stateDelta = state.resolve(new BundleDescription[]{c});
        bundleDeltas = stateDelta.getChanges();
        SubstitutableExportsTest.assertNotNull((String)"bundleDeltas is null", (Object)bundleDeltas);
        SubstitutableExportsTest.assertEquals((String)"bunldeDeltas wrong number", (int)allRefreshBundles.length, (int)bundleDeltas.length);
        k = 0;
        while (k < allRefreshBundles.length) {
            found = false;
            l = 0;
            while (l < bundleDeltas.length && !found) {
                SubstitutableExportsTest.assertEquals((String)("unexpected delta type " + bundleDeltas[l]), (int)8, (int)bundleDeltas[l].getType());
                found = bundleDeltas[l].getBundle() == allRefreshBundles[k];
                ++l;
            }
            if (!found) {
                SubstitutableExportsTest.fail((String)("Did not find RESOLVED BundleDelta for " + allRefreshBundles[k]));
            }
            ++k;
        }
    }

    public void testSubstitutableExports019() throws BundleException {
        State state = this.getSubstituteUnresolvedFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.0.1", (boolean)aFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.1.1", (boolean)bFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.2.1", (boolean)cFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        ExportPackageDescription[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        ExportPackageDescription[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        ExportPackageDescription[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"aFragVisible wrong number", (int)0, (int)aFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bFragVisible wrong number", (int)0, (int)bFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cFragVisible wrong number", (int)0, (int)cFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"a has wrong number of exports", (int)2, (int)aExports.length);
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
    }

    public void testSubstitutableExports020() throws BundleException {
        State state = this.getSubstituteUnresolvedFragState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription aFrag = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription bFrag = state.getBundle(3L);
        BundleDescription c = state.getBundle(4L);
        BundleDescription cFrag = state.getBundle(5L);
        BundleDescription d = state.getBundle(6L);
        BundleDescription e = state.getBundle(7L);
        BundleDescription f = state.getBundle(8L);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Q");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "q; version=1.0");
        BundleDescription q = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), f.getBundleId() + 1L);
        state.addBundle(q);
        state.resolve(new BundleDescription[]{a});
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.0.1", (boolean)aFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1.1", (boolean)bFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2.1", (boolean)cFrag.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] aFragVisible = state.getStateHelper().getVisiblePackages(aFrag);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] bFragVisible = state.getStateHelper().getVisiblePackages(bFrag);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] cFragVisible = state.getStateHelper().getVisiblePackages(cFrag);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"aFragVisible is null", (Object)aFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"bFragVisible is null", (Object)bFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"cFragVisible is null", (Object)cFragVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"aFragVisible wrong number", (int)1, (int)aFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bFragVisible wrong number", (int)2, (int)bFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cFragVisible wrong number", (int)2, (int)cFragVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)3, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)3, (int)fVisible.length);
        Object[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"a has wrong number of exports", (int)3, (int)aExports.length);
        Object[] aDeclaredExports = a.getExportPackages();
        Object[] aFragExpected = new ExportPackageDescription[]{aExports[2], q.getExportPackages()[0]};
        this.assertEquals("aFragVisible not correct", q.getSelectedExports(), aFragVisible);
        this.assertEquals("bVisible not correct", aDeclaredExports, bVisible);
        this.assertEquals("bFragVisible not correct", aFragExpected, bFragVisible);
        this.assertEquals("cVisible not correct", aDeclaredExports, cVisible);
        this.assertEquals("cFragVisible not correct", aFragExpected, cFragVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
    }

    public void testSubstitutableExports021() throws BundleException {
        State state = this.getSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        state.removeBundle(a);
        state.resolve(new BundleDescription[]{a});
        SubstitutableExportsTest.assertFalse((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        ExportPackageDescription[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)0, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)0, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        Object[] bExports = b.getSelectedExports();
        this.assertEquals("cVisible not correct", bExports, cVisible);
        this.assertEquals("eVisible not correct", bExports, eVisible);
        this.assertEquals("fVisible not correct", bExports, fVisible);
    }

    public void testSubstitutableExports022() throws BundleException {
        State state = this.getSubstituteSplitState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription j = state.getBundle(9L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.8", (boolean)i.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)j.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertNotNull((String)"jVisible is null", (Object)jVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)4, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)4, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)4, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)4, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)4, (int)iVisible.length);
        SubstitutableExportsTest.assertEquals((String)"jVisible wrong number", (int)4, (int)jVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("aVisible not correct", aExports, a.getExportPackages());
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] dExported = d.getSelectedExports();
        ExportPackageDescription[] expected = new ExportPackageDescription[aExported.length + dExported.length];
        System.arraycopy(aExported, 0, expected, 0, aExported.length);
        System.arraycopy(dExported, 0, expected, aExported.length, dExported.length);
        int index = 0;
        while (index < expected.length) {
            this.assertContains("eVisible not correct", eVisible, expected[index]);
            this.assertContains("fVisible not correct", fVisible, expected[index]);
            this.assertContains("gVisible not correct", gVisible, expected[index]);
            this.assertContains("hVisible not correct", hVisible, expected[index]);
            this.assertContains("iVisible not correct", iVisible, expected[index]);
            this.assertContains("jVisible not correct", jVisible, expected[index]);
            ++index;
        }
    }

    public void testSubstitutableExports023() throws BundleException {
        State state = this.getSubstituteSplitUsesState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        BundleDescription g = state.getBundle(6L);
        BundleDescription h = state.getBundle(7L);
        BundleDescription i = state.getBundle(8L);
        BundleDescription j = state.getBundle(9L);
        BundleDescription k = state.getBundle(10L);
        BundleDescription l = state.getBundle(11L);
        BundleDescription m = state.getBundle(12L);
        BundleDescription n = state.getBundle(13L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.8", (boolean)i.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)j.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)k.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)l.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)j.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.9", (boolean)n.isResolved());
        Object[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        Object[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        Object[] iVisible = state.getStateHelper().getVisiblePackages(i);
        Object[] jVisible = state.getStateHelper().getVisiblePackages(j);
        ExportPackageDescription[] kVisible = state.getStateHelper().getVisiblePackages(k);
        ExportPackageDescription[] lVisible = state.getStateHelper().getVisiblePackages(l);
        Object[] mVisible = state.getStateHelper().getVisiblePackages(m);
        Object[] nVisible = state.getStateHelper().getVisiblePackages(n);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertNotNull((String)"iVisible is null", (Object)iVisible);
        SubstitutableExportsTest.assertNotNull((String)"jVisible is null", (Object)jVisible);
        SubstitutableExportsTest.assertNotNull((String)"kVisible is null", (Object)kVisible);
        SubstitutableExportsTest.assertNotNull((String)"lVisible is null", (Object)lVisible);
        SubstitutableExportsTest.assertNotNull((String)"mVisible is null", (Object)mVisible);
        SubstitutableExportsTest.assertNotNull((String)"nVisible is null", (Object)nVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)1, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)3, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)3, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)3, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)5, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)5, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)4, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)4, (int)hVisible.length);
        SubstitutableExportsTest.assertEquals((String)"iVisible wrong number", (int)4, (int)iVisible.length);
        SubstitutableExportsTest.assertEquals((String)"jVisible wrong number", (int)4, (int)jVisible.length);
        SubstitutableExportsTest.assertEquals((String)"kVisible wrong number", (int)0, (int)kVisible.length);
        SubstitutableExportsTest.assertEquals((String)"lVisible wrong number", (int)0, (int)lVisible.length);
        SubstitutableExportsTest.assertEquals((String)"mVisible wrong number", (int)6, (int)mVisible.length);
        SubstitutableExportsTest.assertEquals((String)"nVisible wrong number", (int)6, (int)nVisible.length);
        ExportPackageDescription[] aExports = a.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"aExports wrong number", (int)2, (int)aExports.length);
        Object[] bcExpected = new ExportPackageDescription[]{aExports[0], aExports[1], l.getSelectedExports()[0]};
        Object[] aExpected = new ExportPackageDescription[]{l.getSelectedExports()[0]};
        this.assertEquals("aVisible not correct", aExpected, aVisible);
        this.assertEquals("bVisible not correct", bcExpected, bVisible);
        this.assertEquals("cVisible not correct", bcExpected, cVisible);
        Object[] dExpected = new ExportPackageDescription[]{l.getSelectedExports()[1], aExports[0], aExports[1]};
        this.assertEquals("dVisible not correct", dExpected, dVisible);
        ExportPackageDescription[] aExported = a.getSelectedExports();
        ExportPackageDescription[] dExported = d.getSelectedExports();
        ExportPackageDescription[] efExpected = new ExportPackageDescription[aExported.length + dExported.length + 1];
        System.arraycopy(aExported, 0, efExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, efExpected, aExported.length, dExported.length);
        efExpected[aExported.length + dExported.length] = l.getSelectedExports()[1];
        int index = 0;
        while (index < efExpected.length) {
            this.assertContains("eVisible not correct", eVisible, efExpected[index]);
            this.assertContains("fVisible not correct", fVisible, efExpected[index]);
            ++index;
        }
        ExportPackageDescription[] ghijExpected = new ExportPackageDescription[aExported.length + dExported.length];
        System.arraycopy(aExported, 0, ghijExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, ghijExpected, aExported.length, dExported.length);
        int index2 = 0;
        while (index2 < ghijExpected.length) {
            this.assertContains("gVisible not correct", gVisible, ghijExpected[index2]);
            this.assertContains("hVisible not correct", hVisible, ghijExpected[index2]);
            this.assertContains("iVisible not correct", iVisible, ghijExpected[index2]);
            this.assertContains("jVisible not correct", jVisible, ghijExpected[index2]);
            ++index2;
        }
        ExportPackageDescription[] lExported = l.getSelectedExports();
        ExportPackageDescription[] mnExpected = new ExportPackageDescription[aExported.length + dExported.length + lExported.length];
        System.arraycopy(aExported, 0, mnExpected, 0, aExported.length);
        System.arraycopy(dExported, 0, mnExpected, aExported.length, dExported.length);
        System.arraycopy(lExported, 0, mnExpected, aExported.length + dExported.length, lExported.length);
        int index3 = 0;
        while (index3 < mnExpected.length) {
            this.assertContains("mVisible not correct", mVisible, mnExpected[index3]);
            this.assertContains("nVisible not correct", nVisible, mnExpected[index3]);
            ++index3;
        }
    }

    public void testSubstitutableExports024() throws BundleException {
        State state = this.getNonOverlapingSubstituteBasicState();
        state.resolve();
        BundleDescription a = state.getBundle(0L);
        BundleDescription b = state.getBundle(1L);
        BundleDescription c = state.getBundle(2L);
        BundleDescription d = state.getBundle(3L);
        BundleDescription e = state.getBundle(4L);
        BundleDescription f = state.getBundle(5L);
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("aVisible not correct", aExports, a.getExportPackages());
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        VersionConstraint[] unsatisfied = state.getStateHelper().getUnsatisfiedConstraints(a);
        SubstitutableExportsTest.assertEquals((String)"Should not have any unresolvable constraints", (int)0, (int)unsatisfied.length);
    }

    public void testSubstitutableExports025() throws BundleException {
        State state = this.getSubstituteUsesState();
        BundleDescription a = state.getBundle(1L);
        BundleDescription b = state.getBundle(2L);
        BundleDescription c = state.getBundle(3L);
        BundleDescription d = state.getBundle(4L);
        BundleDescription e = state.getBundle(5L);
        BundleDescription f = state.getBundle(6L);
        BundleDescription g = state.getBundle(7L);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "C");
        manifest.put("Export-Package", "z; version=0.5");
        manifest.put("Import-Package", "z");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), g.getBundleId() + 1L);
        state.addBundle(h);
        state.resolve();
        SubstitutableExportsTest.assertTrue((String)"1.0", (boolean)a.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.1", (boolean)b.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.2", (boolean)c.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.3", (boolean)d.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.4", (boolean)e.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.5", (boolean)f.isResolved());
        SubstitutableExportsTest.assertFalse((String)"1.6", (boolean)g.isResolved());
        SubstitutableExportsTest.assertTrue((String)"1.7", (boolean)h.isResolved());
        ExportPackageDescription[] aVisible = state.getStateHelper().getVisiblePackages(a);
        Object[] bVisible = state.getStateHelper().getVisiblePackages(b);
        Object[] cVisible = state.getStateHelper().getVisiblePackages(c);
        Object[] dVisible = state.getStateHelper().getVisiblePackages(d);
        Object[] eVisible = state.getStateHelper().getVisiblePackages(e);
        Object[] fVisible = state.getStateHelper().getVisiblePackages(f);
        ExportPackageDescription[] gVisible = state.getStateHelper().getVisiblePackages(g);
        Object[] hVisible = state.getStateHelper().getVisiblePackages(h);
        SubstitutableExportsTest.assertNotNull((String)"aVisible is null", (Object)aVisible);
        SubstitutableExportsTest.assertNotNull((String)"bVisible is null", (Object)bVisible);
        SubstitutableExportsTest.assertNotNull((String)"cVisible is null", (Object)cVisible);
        SubstitutableExportsTest.assertNotNull((String)"dVisible is null", (Object)dVisible);
        SubstitutableExportsTest.assertNotNull((String)"eVisible is null", (Object)eVisible);
        SubstitutableExportsTest.assertNotNull((String)"fVisible is null", (Object)fVisible);
        SubstitutableExportsTest.assertNotNull((String)"gVisible is null", (Object)gVisible);
        SubstitutableExportsTest.assertNotNull((String)"hVisible is null", (Object)hVisible);
        SubstitutableExportsTest.assertEquals((String)"aVisible wrong number", (int)0, (int)aVisible.length);
        SubstitutableExportsTest.assertEquals((String)"bVisible wrong number", (int)2, (int)bVisible.length);
        SubstitutableExportsTest.assertEquals((String)"cVisible wrong number", (int)2, (int)cVisible.length);
        SubstitutableExportsTest.assertEquals((String)"dVisible wrong number", (int)2, (int)dVisible.length);
        SubstitutableExportsTest.assertEquals((String)"eVisible wrong number", (int)2, (int)eVisible.length);
        SubstitutableExportsTest.assertEquals((String)"fVisible wrong number", (int)2, (int)fVisible.length);
        SubstitutableExportsTest.assertEquals((String)"gVisible wrong number", (int)0, (int)gVisible.length);
        SubstitutableExportsTest.assertEquals((String)"hVisible wrong number", (int)2, (int)hVisible.length);
        Object[] aExports = a.getSelectedExports();
        this.assertEquals("aVisible not correct", aExports, a.getExportPackages());
        this.assertEquals("bVisible not correct", aExports, bVisible);
        this.assertEquals("cVisible not correct", aExports, cVisible);
        this.assertEquals("dVisible not correct", aExports, dVisible);
        this.assertEquals("eVisible not correct", aExports, eVisible);
        this.assertEquals("fVisible not correct", aExports, fVisible);
        this.assertEquals("hVisible not correct", aExports, hVisible);
        ExportPackageDescription[] hExported = h.getSelectedExports();
        SubstitutableExportsTest.assertEquals((String)"Expected one export", (int)1, (int)hExported.length);
        ExportPackageDescription[] hSubstituted = h.getSubstitutedExports();
        SubstitutableExportsTest.assertEquals((String)"Expected no substitutions", (int)0, (int)hSubstituted.length);
        ImportPackageSpecification[] hImports = h.getImportPackages();
        SubstitutableExportsTest.assertEquals((String)"Expected one import", (int)1, (int)hImports.length);
        SubstitutableExportsTest.assertEquals((String)"Wrong supplier", (Object)hExported[0], (Object)hImports[0].getSupplier());
    }
}

