/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.osgi.framework.BundleException;

public class ManifestElementTestCase
extends TestCase {
    private static final List<String> TEST_MANIFEST = Arrays.asList("Bundle-ManifestVersion: 2", "Bundle-SymbolicName: test.", " bsn", "Import-Package: test1,", " test2,", " test3", "");

    public void testSpacesInValues() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"test-spaces", (String)"\"comp 1\";\"comp 2\";\"comp 3\";attr=\"val 1\";dir:=\"val 2\"");
        ManifestElementTestCase.assertNotNull((String)"1.0", (Object)elements);
        ManifestElementTestCase.assertEquals((String)"1.1", (int)elements.length, (int)1);
        String[] components = elements[0].getValueComponents();
        ManifestElementTestCase.assertEquals((String)"1.2", (int)components.length, (int)3);
        ManifestElementTestCase.assertEquals((String)"2.0", (String)components[0], (String)"comp 1");
        ManifestElementTestCase.assertEquals((String)"2.1", (String)components[1], (String)"comp 2");
        ManifestElementTestCase.assertEquals((String)"2.2", (String)components[2], (String)"comp 3");
        ManifestElementTestCase.assertEquals((String)"3.0", (String)elements[0].getAttribute("attr"), (String)"val 1");
        ManifestElementTestCase.assertEquals((String)"3.1", (String)elements[0].getDirective("dir"), (String)"val 2");
    }

    public void testBug238675_01() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-NativeCode", (String)"\"external:C:/tmp/x.dll\";\"external:C:/tmp/y.dll\"; osname =WindowsXP; osverison = 2.0; processor = x86");
        ManifestElementTestCase.assertNotNull((String)"1.0", (Object)elements);
        ManifestElementTestCase.assertEquals((String)"1.1", (int)1, (int)elements.length);
        String[] components = elements[0].getValueComponents();
        ManifestElementTestCase.assertEquals((String)"1.2", (int)2, (int)components.length);
        ManifestElementTestCase.assertEquals((String)"2.0", (String)"external:C:/tmp/x.dll", (String)components[0]);
        ManifestElementTestCase.assertEquals((String)"2.1", (String)"external:C:/tmp/y.dll", (String)components[1]);
    }

    public void testBug238675_02() throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-NativeCode", (String)"\"external:test1:test2\";\"test3:test4:\"; osname =WindowsXP; osverison = 2.0; processor = x86");
        ManifestElementTestCase.assertNotNull((String)"1.0", (Object)elements);
        ManifestElementTestCase.assertEquals((String)"1.1", (int)1, (int)elements.length);
        String[] components = elements[0].getValueComponents();
        ManifestElementTestCase.assertEquals((String)"1.2", (int)2, (int)components.length);
        ManifestElementTestCase.assertEquals((String)"2.0", (String)components[0], (String)"external:test1:test2");
        ManifestElementTestCase.assertEquals((String)"2.1", (String)components[1], (String)"test3:test4:");
    }

    public void testManifestWithCR() throws IOException, BundleException {
        this.doManifestTest("\r");
    }

    public void testManifestWithLF() throws IOException, BundleException {
        this.doManifestTest("\n");
    }

    public void testManifestWithCRLF() throws IOException, BundleException {
        this.doManifestTest("\r\n");
    }

    private void doManifestTest(String newLine) throws IOException, BundleException {
        Map<String, String> manifest = this.getManifest(TEST_MANIFEST, newLine);
        Assert.assertEquals((String)"Wrong Bundle-SymbolicName.", (Object)"test.bsn", (Object)manifest.get("Bundle-SymbolicName"));
        Assert.assertEquals((String)"Wrong Import-Package.", (Object)"test1,test2,test3", (Object)manifest.get("Import-Package"));
    }

    private Map<String, String> getManifest(List<String> manifestLines, String newLine) throws IOException, BundleException {
        StringBuilder manifestText = new StringBuilder();
        for (String line : manifestLines) {
            manifestText.append(line).append(newLine);
        }
        return ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(manifestText.toString().getBytes(StandardCharsets.UTF_8)), null);
    }
}

