/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSProvideTestCase
extends AbstractDSModelTestCase {
    public void testAddCompleteProvidedService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service servicefactory=\"true\" >");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable\">");
        buffer.append("</provide>");
        buffer.append("\n");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSProvideTestCase.assertNotNull((Object)component);
        IDSService service = this.fModel.getDSComponent().getService();
        DSProvideTestCase.assertNotNull((Object)service);
        IDSProvide[] providedServices = service.getProvidedServices();
        DSProvideTestCase.assertTrue((providedServices.length == 1 ? 1 : 0) != 0);
        IDSProvide provide = providedServices[0];
        DSProvideTestCase.assertTrue((boolean)provide.getInterface().equals("java.lang.Runnable"));
        String interfaceName = "java.lang.String";
        provide.setInterface(interfaceName);
        String content = this.fModel.getDSComponent().toString();
        DSProvideTestCase.assertTrue((content.indexOf(interfaceName) != -1 ? 1 : 0) != 0);
        DSProvideTestCase.assertEquals((String)provide.getName(), (String)interfaceName);
    }

    public void testAddProvidedServicebyFactory() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        IDSComponent component = this.fModel.getDSComponent();
        component.setService(service);
        IDSProvide provide = factory.createProvide();
        provide.setInterface("java.lang.Runnable");
        service.addProvidedService(provide);
        String content = component.toString();
        DSProvideTestCase.assertTrue((content.indexOf("interface=\"java.lang.Runnable\"") != -1 ? 1 : 0) != 0);
        IDSService service0 = component.getService();
        DSProvideTestCase.assertNotNull((Object)service0);
        DSProvideTestCase.assertTrue((boolean)service0.getServiceFactory());
        IDSProvide[] providedServices = service.getProvidedServices();
        IDSProvide provide0 = providedServices[0];
        DSProvideTestCase.assertNotNull((Object)provide0);
        DSProvideTestCase.assertTrue((boolean)provide0.getInterface().equals("java.lang.Runnable"));
    }
}

