/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.FrameworkUtil;

public class AbstractTargetEditorTest {
    static TargetDefinitionContentAssist contentAssist = new TargetDefinitionContentAssist();
    private IProject project;
    protected File tempFile;

    protected void checkProposals(String[] expectedProposals, ICompletionProposal[] actualProposals, int offset) {
        Assert.assertEquals((String)("Proposal lengths are not equal at offset " + offset + ". Actual: " + this.proposalListToString(actualProposals)), (long)expectedProposals.length, (long)actualProposals.length);
        int i = 0;
        while (i < actualProposals.length) {
            Assert.assertEquals((String)("Proposal at index " + i + " did not match expected at offset " + offset), (Object)actualProposals[i].getDisplayString(), (Object)expectedProposals[i]);
            ++i;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + "_" + System.currentTimeMillis());
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected ITextViewer getTextViewerForTarget(String name) throws Exception {
        IFile targetFile = this.project.getFile(String.valueOf(name) + ".target");
        InputStream testStream = FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/target-files/" + name + ".txt").openStream();
        String normalizedLineFeeds = new BufferedReader(new InputStreamReader(testStream)).lines().collect(Collectors.joining("\n"));
        ByteArrayInputStream normalizedStream = new ByteArrayInputStream(normalizedLineFeeds.getBytes(StandardCharsets.UTF_8));
        targetFile.create((InputStream)normalizedStream, true, (IProgressMonitor)new NullProgressMonitor());
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)targetFile, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        return (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
    }

    protected String getLocationForSite(String name) {
        return FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/testing-sites/" + name + "/").toString();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.project != null) {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected String proposalListToString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return "null";
        }
        if (proposals.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            builder.append(proposal.getDisplayString());
            builder.append(", ");
            ++n2;
        }
        builder.setLength(builder.length() - 2);
        builder.append(']');
        return builder.toString();
    }

    public static ITextFileBuffer getTextFileBufferFromFile(File file) {
        try {
            IPath path = Path.fromOSString((String)file.getAbsolutePath());
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            manager.connect(path, LocationKind.LOCATION, null);
            return manager.getTextFileBuffer(path, LocationKind.LOCATION);
        }
        catch (CoreException coreException) {
            Assert.fail((String)"Unable to retrive target definition file");
            return null;
        }
    }
}

