/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.util.HashMap;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.junit.Assert;
import org.junit.Test;

public class AttributeNameCompletionTests
extends AbstractTargetEditorTest {
    @Test
    public void testAttributeNameSuggestions() throws Exception {
        HashMap<Integer, String[]> expectedProposalsByOffset = new HashMap<Integer, String[]>();
        expectedProposalsByOffset.put(8, new String[]{"name", "sequenceNumber"});
        expectedProposalsByOffset.put(33, new String[]{"includeAllPlatforms", "includeConfigurePhase", "includeMode", "includeSource", "type"});
        expectedProposalsByOffset.put(41, new String[]{"id", "version"});
        expectedProposalsByOffset.put(56, new String[]{"location"});
        expectedProposalsByOffset.put(95, new String[]{"path"});
        ITextViewer textViewer = this.getTextViewerForTarget("AttributeNamesTestCaseTarget");
        String text = textViewer.getDocument().get();
        int offset = 0;
        while (offset < text.length()) {
            int nextSpace = text.indexOf(32, offset) + 1;
            int nextOpen = text.indexOf(60, offset);
            if (nextSpace == 0 && nextOpen == -1) break;
            offset = nextSpace == 0 ? nextOpen : (nextOpen == -1 ? nextSpace : Math.min(nextSpace, nextOpen));
            ICompletionProposal[] completionProposals = contentAssist.computeCompletionProposals(textViewer, offset);
            if (expectedProposalsByOffset.containsKey(offset)) {
                this.checkProposals((String[])expectedProposalsByOffset.get(offset), completionProposals, offset);
            } else {
                Assert.assertTrue((String)("There should not be any proposals at index " + offset + ". Following proposals found: " + this.proposalListToString(completionProposals)), (completionProposals.length == 0 ? 1 : 0) != 0);
            }
            ++offset;
        }
    }

    @Test
    public void testNoAttributeNameRepeatSuggestions() throws Exception {
        ITextViewer textViewer = this.getTextViewerForTarget("AttributeNamesFullTestCaseTarget");
        String text = textViewer.getDocument().get();
        int offset = 0;
        while (offset < text.length()) {
            int nextSpace = text.indexOf("  ", offset) + 1;
            int nextOpen = text.indexOf(60, offset);
            if (nextSpace == 0 && nextOpen == -1) break;
            offset = nextSpace == 0 ? nextOpen : (nextOpen == -1 ? nextSpace : Math.min(nextSpace, nextOpen));
            ICompletionProposal[] completionProposals = contentAssist.computeCompletionProposals(textViewer, offset);
            if (completionProposals.length != 0) {
                Assert.fail((String)("There should not be any proposals at index " + offset + ". Following proposals found: " + this.proposalListToString(completionProposals)));
            }
            ++offset;
        }
    }
}

