/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.junit.Before;
import org.junit.Test;

public class Bug528706CompletionWithMultilineTagsTest
extends AbstractTargetEditorTest {
    private ITextViewer textViewer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.textViewer = this.getTextViewerForTarget("MultilineTagTestCaseTarget");
    }

    @Test
    public void testTagNameCompletionBeforeAMultiline() {
        this.confirmCompletionAtOffset(24, "location (Profile)");
    }

    @Test
    public void testTagNameCompletionAfterAMultiline() {
        this.confirmCompletionAtOffset(115, "location (Profile)");
    }

    @Test
    public void testTagValueCompletionBeforeAMultiline() {
        this.confirmCompletionAtOffset(151, "carbon");
    }

    @Test
    public void testTagValueCompletionAsAMultiline() {
        this.confirmCompletionAtOffset(167, "linux");
    }

    @Test
    public void testTagValueCompletionAfterAMultiline() {
        this.confirmCompletionAtOffset(187, "PA_RISC");
    }

    @Test
    public void testAttributeNameCompletionBeforeAMultiline() {
        this.confirmCompletionAtOffset(42, "id");
    }

    @Test
    public void testAttributeNameCompletionAsAMultiline() {
        this.confirmCompletionAtOffset(63, "id");
    }

    @Test
    public void testAttributeNameCompletionAfterAMultiline() {
        this.confirmCompletionAtOffset(85, "id");
    }

    @Test
    public void testAttributeValueCompletionBeforeAMultiline() {
        this.confirmCompletionAtOffset(52, "Add repository URL first.");
    }

    @Test
    public void testAttributeValueCompletionAsAMultiline() {
        this.confirmCompletionAtOffset(74, "Add repository URL first.");
    }

    @Test
    public void testAttributeValueCompletionAfterAMultiline() {
        this.confirmCompletionAtOffset(95, "Add repository URL first.");
    }

    private void confirmCompletionAtOffset(int offset, String expectedCompletion) {
        this.checkProposals(new String[]{expectedCompletion}, contentAssist.computeCompletionProposals(this.textViewer, offset + 1), offset);
    }
}

