/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Scanner;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.eclipse.pde.genericeditor.extension.tests.StringAsserts;
import org.eclipse.pde.genericeditor.extension.tests.resources.TestTargetLocation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.FrameworkUtil;

public class Bug531602FormattingTests
extends AbstractTargetEditorTest {
    private static final String TEST_FILE_LINE_SEPERATOR = "\n";

    @Test
    public void testSettingNullPersists() throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setName("test");
        this.tempFile = File.createTempFile("targetDefinition", null);
        ITextFileBuffer buffer = Bug531602FormattingTests.getTextFileBufferFromFile(this.tempFile);
        TargetDefinitionPersistenceHelper.persistXML((ITargetDefinition)targetDefinition, (ITextFileBuffer)buffer);
        String expectedOutput = Bug531602FormattingTests.readFile(this.tempFile.toPath(), StandardCharsets.UTF_8);
        targetDefinition.setProgramArguments(null);
        TargetDefinitionPersistenceHelper.persistXML((ITargetDefinition)targetDefinition, (ITextFileBuffer)buffer);
        String actualOutput = Bug531602FormattingTests.readFile(this.tempFile.toPath(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expectedOutput, (Object)actualOutput);
    }

    @Test
    public void testIndenting() throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setOS("test_os");
        this.confirmMatch(targetDefinition, "IndentingTestCaseTarget.txt");
    }

    @Test
    public void testCommentsAndWhitespacePersists() throws Exception {
        URL url = FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/target-files/PersistTestCaseTarget.txt");
        File inputFile = new File(FileLocator.toFileURL((URL)url).getFile());
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        ITextFileBuffer buffer = Bug531602FormattingTests.getTextFileBufferFromFile(inputFile);
        TargetDefinitionPersistenceHelper.initFromXML((ITargetDefinition)targetDefinition, (ITextFileBuffer)buffer);
        this.confirmMatch(targetDefinition, "PersistTestCaseTarget.txt");
    }

    @Test
    public void testContainerContentsAreSet() throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        this.addLocationsToDefinition(targetDefinition);
        this.confirmMatch(targetDefinition, "ContainerContentsTestCaseTarget.txt");
    }

    @Test
    public void testMultipleContainersWithSameRepoPersist() throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        IUBundleContainer siteContainer1 = (IUBundleContainer)service.newIULocation(new String[]{"unit1", "unit2"}, new String[]{"1.0", "2.0"}, new URI[]{new URI("TESTURI")}, 1);
        IUBundleContainer siteContainer2 = (IUBundleContainer)service.newIULocation(new IInstallableUnit[0], new URI[]{new URI("TESTURI")}, 2);
        targetDefinition.setTargetLocations(new ITargetLocation[]{siteContainer1, siteContainer2});
        this.confirmMatch(targetDefinition, "MultipleContainersSameRepoTestCaseTarget.txt");
    }

    @Test
    public void testITargetLocationExtensionSerialization() throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setTargetLocations(new ITargetLocation[]{new TestTargetLocation()});
        this.confirmMatch(targetDefinition, "ITargetLocationExtensionTestCaseTarget.txt");
    }

    public static void assertEqualStringIgnoreDelim(String actual, String expected) throws IOException {
        StringAsserts.assertEqualStringIgnoreDelim(actual, expected);
    }

    private void confirmMatch(ITargetDefinition targetDefinition, String expectedDefinitionPath) throws Exception {
        String lineSeparator = System.getProperty("line.separator");
        boolean requireReplaceLineSeparator = !lineSeparator.equals(TEST_FILE_LINE_SEPERATOR);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Scanner s = new Scanner(FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/target-files/" + expectedDefinitionPath).openStream()).useDelimiter("\\A");){
                String result = s.hasNext() ? s.next() : "";
                IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
                boolean spacesForTabs = preferences.getBoolean("spacesForTabs", false);
                if (spacesForTabs) {
                    char[] chars = new char[preferences.getInt("tabWidth", 4)];
                    Arrays.fill(chars, ' ');
                    result.replace("\t", new String(chars));
                }
                this.tempFile = File.createTempFile("targetDefinition", null);
                ITextFileBuffer buffer = Bug531602FormattingTests.getTextFileBufferFromFile(this.tempFile);
                TargetDefinitionPersistenceHelper.persistXML((ITargetDefinition)targetDefinition, (ITextFileBuffer)buffer);
                String fileContent = Bug531602FormattingTests.readFile(this.tempFile.toPath(), StandardCharsets.UTF_8);
                if (requireReplaceLineSeparator) {
                    fileContent = fileContent.replace(lineSeparator, TEST_FILE_LINE_SEPERATOR);
                }
                Assert.assertEquals((Object)result, (Object)fileContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void addLocationsToDefinition(ITargetDefinition targetDefinition) throws Exception {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        ITargetLocation dirContainer = service.newDirectoryLocation("/test/path/to/eclipse/plugins");
        ITargetLocation profileContainer = service.newProfileLocation("/test/path/to/eclipse/", "/test/path/to/configuration/location/");
        ITargetLocation featureContainer = service.newFeatureLocation("${eclipse_home}", "org.eclipse.test", "1.2.3");
        ITargetLocation restrictedProfileContainer = service.newProfileLocation("/test/path/to/eclipse/", null);
        IUBundleContainer siteContainer = (IUBundleContainer)service.newIULocation(new String[]{"unit1", "unit2"}, new String[]{"1.0", "2.0"}, new URI[]{new URI("TESTURI"), new URI("TESTURI2")}, 1);
        NameVersionDescriptor[] restrictions = new NameVersionDescriptor[]{new NameVersionDescriptor("org.eclipse.test1", null), new NameVersionDescriptor("org.eclipse.test2", null)};
        targetDefinition.setIncluded(restrictions);
        targetDefinition.setTargetLocations(new ITargetLocation[]{dirContainer, profileContainer, featureContainer, restrictedProfileContainer, siteContainer});
    }

    static String readFile(Path path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(path);
        return new String(encoded, encoding);
    }
}

