/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.junit.Assert;
import org.junit.Test;

public class TagNameCompletionTests
extends AbstractTargetEditorTest {
    @Test
    public void testTagNameSuggestions() throws Exception {
        HashMap<Integer, String[]> expectedProposalsByOffset = new HashMap<Integer, String[]>();
        expectedProposalsByOffset.put(1, new String[0]);
        expectedProposalsByOffset.put(12, new String[]{"targetJRE"});
        expectedProposalsByOffset.put(26, new String[]{"location (Directory)", "location (Feature)", "location (Installable Unit)", "location (Profile)"});
        expectedProposalsByOffset.put(39, new String[]{"unit"});
        expectedProposalsByOffset.put(63, new String[]{"unit"});
        expectedProposalsByOffset.put(88, new String[]{"repository", "unit"});
        expectedProposalsByOffset.put(129, new String[]{"arch", "nl", "os", "ws"});
        expectedProposalsByOffset.put(161, new String[]{"programArgs", "vmArgs"});
        expectedProposalsByOffset.put(179, new String[]{"targetJRE"});
        ITextViewer textViewer = this.getTextViewerForTarget("TagNamesTestCaseTarget");
        Iterator iterator = expectedProposalsByOffset.keySet().iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            ICompletionProposal[] completionProposals = contentAssist.computeCompletionProposals(textViewer, offset);
            if (expectedProposalsByOffset.containsKey(offset)) {
                this.checkProposals((String[])expectedProposalsByOffset.get(offset), completionProposals, offset);
                continue;
            }
            if (completionProposals.length == 0) continue;
            Assert.fail((String)("There should not be any proposals at index " + offset + ". Following proposals found: " + this.proposalListToString(completionProposals)));
        }
    }

    @Test
    public void testNoTagNameRepeatSuggestions() throws Exception {
        ITextViewer textViewer = this.getTextViewerForTarget("TagNamesFullTestCaseTarget");
        IDocument document = textViewer.getDocument();
        String text = document.get();
        int offset = 0;
        while (offset < text.length()) {
            if ((offset = text.indexOf("\n<\n", offset)) == -1) break;
            ICompletionProposal[] completionProposals = contentAssist.computeCompletionProposals(textViewer, offset);
            if (completionProposals.length != 0) {
                Assert.fail((String)("There should not be any proposals at index " + offset + ". Following proposals found: " + this.proposalListToString(completionProposals)));
            }
            ++offset;
        }
    }
}

