/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagValueCompletionTests
extends AbstractTargetEditorTest {
    private List<Integer> expectedCompletionOffsets;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.expectedCompletionOffsets = new ArrayList<Integer>();
        this.expectedCompletionOffsets.add(27);
        this.expectedCompletionOffsets.add(37);
        this.expectedCompletionOffsets.add(49);
        this.expectedCompletionOffsets.add(61);
    }

    @Test
    public void testAttributeNameSuggestions() throws Exception {
        ITextViewer textViewer = this.getTextViewerForTarget("TagValuesTestCaseTarget");
        String text = textViewer.getDocument().get();
        int offset = 0;
        while (offset < text.length()) {
            int nextClose = text.indexOf(62, offset);
            int nextNewLine = text.indexOf(10, offset);
            if (nextClose == 0 && nextNewLine == -1) break;
            offset = nextClose == 0 ? nextNewLine : (nextNewLine == -1 ? nextClose : Math.min(nextClose, nextNewLine));
            ICompletionProposal[] completionProposals = contentAssist.computeCompletionProposals(textViewer, offset);
            if (completionProposals.length > 0 && !this.expectedCompletionOffsets.contains(offset)) {
                Assert.fail((String)("There should not be any proposals at index " + offset + ". Following proposals found: " + this.proposalListToString(completionProposals)));
            }
            ++offset;
        }
    }
}

