/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.pde.genericeditor.extension.tests.AbstractTargetEditorTest;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.junit.Assert;
import org.junit.Test;

public class UpdateUnitVersionsCommandTests
extends AbstractTargetEditorTest {
    private ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);

    @Test
    public void testUpdateRequired() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("org.eclipse.fake", "1.0.1");
        ITextViewer textViewer = this.getTextViewerForTarget("RequiresUnitVersionUpdateTarget");
        this.insertFirstUninsertedLocation(textViewer.getDocument(), this.getLocationForSite("SingleUnitSingleVersion"));
        this.confirmVersionUpdates(expected);
    }

    @Test
    public void testVersionSort() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("org.eclipse.fake.1", "2.0.0");
        expected.put("org.eclipse.fake.2", "1.2.0");
        expected.put("org.eclipse.fake.3", "1.1.2");
        expected.put("org.eclipse.fake.4", "1.1.1.v2018-01-02");
        expected.put("org.eclipse.fake.5", "1.1.1.banana");
        expected.put("org.eclipse.fake.6", "1.10.0");
        expected.put("org.eclipse.fake.7", "1.0.0.v2");
        ITextViewer textViewer = this.getTextViewerForTarget("TestReplaceWithNewestVersionTarget");
        this.insertFirstUninsertedLocation(textViewer.getDocument(), this.getLocationForSite("MultipleUnitsConfirmSorting"));
        this.confirmVersionUpdates(expected);
    }

    private Map<String, String> getVersionsForIdsFromTargetFile(String targetFile) {
        HashMap<String, String> units = new HashMap<String, String>();
        String[] splitUnits = targetFile.split("<unit");
        int i = 1;
        while (i < splitUnits.length) {
            int idIndex = splitUnits[i].indexOf("id=\"");
            int versionIndex = splitUnits[i].indexOf("version=\"");
            if (idIndex != -1 && versionIndex != -1) {
                String id = splitUnits[i].substring(idIndex += 4, splitUnits[i].indexOf("\"", idIndex));
                String version = splitUnits[i].substring(versionIndex += 9, splitUnits[i].indexOf("\"", versionIndex));
                units.put(id, version);
            }
            ++i;
        }
        return units;
    }

    private void confirmVersionUpdates(Map<String, String> expected) throws Exception {
        Command command = this.service.getCommand("org.eclipse.pde.updateUnitVersions");
        Object response = command.executeWithChecks(new ExecutionEvent());
        String updatedText = (String)((CompletableFuture)response).get();
        Assert.assertNotNull((Object)updatedText);
        Map<String, String> actual = this.getVersionsForIdsFromTargetFile(updatedText);
        for (Map.Entry<String, String> unit : expected.entrySet()) {
            String expectedID = unit.getKey();
            String expectedVersion = unit.getValue();
            Assert.assertTrue((String)("ID: " + expectedID + " not found in actual"), (boolean)actual.containsKey(expectedID));
            Assert.assertEquals((String)("ID: " + expectedID + " has the incorrect version."), (Object)expectedVersion, (Object)actual.get(expectedID));
        }
    }

    private void insertFirstUninsertedLocation(IDocument document, String Location2) {
        String documentText = document.get();
        document.set(documentText.replaceFirst("REPO_LOCATION", Location2));
    }
}

