/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import org.eclipse.releng.tools.AdvancedCopyrightComment;
import org.eclipse.releng.tools.BlockComment;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AdvancedCopyrightCommentTestsJunit4 {
    @Rule
    public TestName name = new TestName();

    @Test
    public void singleYearComment() {
        String original = "<!--\n    Copyright (c) 2000 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "<!--\n    Copyright (c) 2000, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void twoYearCommentCommaSeperated() {
        String original = "<!--\n    Copyright (c) 2000, 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "<!--\n    Copyright (c) 2000, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void twoYearCommentDashSeperated() {
        String original = "<!--\n    Copyright (c) 2000 - 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "<!--\n    Copyright (c) 2000 - 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void multiYearComment() {
        String original = "<!--\n    Copyright (c) 2000, 2011-2012, 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "<!--\n    Copyright (c) 2000, 2011-2012, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void multiYearCommentNewlinePost() {
        String original = "<!--\n    Copyright (c) 2000, 2011-2012, 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->\n";
        String expectedOut = "<!--\n    Copyright (c) 2000, 2011-2012, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->\n";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void multiYearCommentNewlinePre() {
        String original = "\n<!--\n    Copyright (c) 2000, 2011-2012, 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "\n<!--\n    Copyright (c) 2000, 2011-2012, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void unixDelimiters() {
        String original = "<!--\n    Copyright (c) 2000, 2014 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        String expectedOut = "<!--\n    Copyright (c) 2000, 2015 IBM Corporation and others.  \n    All rights reserved. This program and the accompanying materials\n    are made available under the terms of the Eclipse Public License v1.0\n    which accompanies this distribution, and is available at\n    http://www.eclipse.org/legal/epl-v10.html\n   \n    Contributors:\n        IBM Corporation - initial API and implementation\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void windowsDelimiters() {
        String original = "<!--\r\n    Copyright (c) 2000, 2014 IBM Corporation and others.  \r\n    All rights reserved. This program and the accompanying materials \r\n    are made available under the terms of the Eclipse Public License v1.0\r\n    which accompanies this distribution, and is available at\r\n    http://www.eclipse.org/legal/epl-v10.html\r\n   \r\n    Contributors:\r\n        IBM Corporation - initial API and implementation\r\n -->";
        String expectedOut = "<!--\r\n    Copyright (c) 2000, 2015 IBM Corporation and others.  \r\n    All rights reserved. This program and the accompanying materials \r\n    are made available under the terms of the Eclipse Public License v1.0\r\n    which accompanies this distribution, and is available at\r\n    http://www.eclipse.org/legal/epl-v10.html\r\n   \r\n    Contributors:\r\n        IBM Corporation - initial API and implementation\r\n -->";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void eclipseCopyrightComment() {
        String original = "    /*******************************************************************************\n     * Copyright (c) 2000 {INITIAL COPYRIGHT OWNER} {OTHER COPYRIGHT OWNERS}.\n     * All rights reserved. This program and the accompanying materials\n     * are made available under the terms of the Eclipse Public License v1.0\n     * which accompanies this distribution, and is available at\n     * http://www.eclipse.org/legal/epl-v10.html\n     *\n     * Contributors:\n     *    {INITIAL AUTHOR} - initial API and implementation and/or initial documentation\n     *******************************************************************************/";
        String expectedOut = "    /*******************************************************************************\n     * Copyright (c) 2000, 2015 {INITIAL COPYRIGHT OWNER} {OTHER COPYRIGHT OWNERS}.\n     * All rights reserved. This program and the accompanying materials\n     * are made available under the terms of the Eclipse Public License v1.0\n     * which accompanies this distribution, and is available at\n     * http://www.eclipse.org/legal/epl-v10.html\n     *\n     * Contributors:\n     *    {INITIAL AUTHOR} - initial API and implementation and/or initial documentation\n     *******************************************************************************/";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void ibmCopyrightComment() {
        String original = "Copyright (c) 2000, 2010 IBM Corporation. \nAll rights reserved. This program and the accompanying materials \nare made available under the terms of the Eclipse Public License v1.0 \nwhich accompanies this distribution, and is available at \nhttp://www.eclipse.org/legal/epl-v10.html  \n\nContributors: \n   IBM Corporation - initial API and implementation";
        String expectedOut = "Copyright (c) 2000, 2015 IBM Corporation. \nAll rights reserved. This program and the accompanying materials \nare made available under the terms of the Eclipse Public License v1.0 \nwhich accompanies this distribution, and is available at \nhttp://www.eclipse.org/legal/epl-v10.html  \n\nContributors: \n   IBM Corporation - initial API and implementation";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    @Test
    public void redHatCopyrightComment() {
        String original = "    /*******************************************************************************\n     * Copyright (c) 2004, 2008, 2009, 2012 Red Hat, Inc. and others\n     * All rights reserved. This program and the accompanying materials\n     * are made available under the terms of the Eclipse Public License v1.0\n     * which accompanies this distribution, and is available at\n     * http://www.eclipse.org/legal/epl-v10.html\n     *\n     * Contributors:\n     *    Kent Sebastian <ksebasti@redhat.com> - initial API and implementation\n     *    Keith Seitz <keiths@redhat.com> - setup code in launch the method, initially\n     *        written in the now-defunct OprofileSession class\n     *    QNX Software Systems and others - the section of code marked in the launch\n     *        method, and the exec method\n     *    Lev Ufimtsev <lufimtse@redhat.com> --Added automatical enablement of options\n     *                                         if thery are not set.\n     *    Red Hat Inc. - modification of OProfileLaunchConfigurationDelegate to here\n     *******************************************************************************/";
        String expectedOut = "    /*******************************************************************************\n     * Copyright (c) 2004, 2008, 2009, 2015 Red Hat, Inc. and others\n     * All rights reserved. This program and the accompanying materials\n     * are made available under the terms of the Eclipse Public License v1.0\n     * which accompanies this distribution, and is available at\n     * http://www.eclipse.org/legal/epl-v10.html\n     *\n     * Contributors:\n     *    Kent Sebastian <ksebasti@redhat.com> - initial API and implementation\n     *    Keith Seitz <keiths@redhat.com> - setup code in launch the method, initially\n     *        written in the now-defunct OprofileSession class\n     *    QNX Software Systems and others - the section of code marked in the launch\n     *        method, and the exec method\n     *    Lev Ufimtsev <lufimtse@redhat.com> --Added automatical enablement of options\n     *                                         if thery are not set.\n     *    Red Hat Inc. - modification of OProfileLaunchConfigurationDelegate to here\n     *******************************************************************************/";
        Assert.assertTrue((boolean)this.proccessAndCompare(original, 2015, expectedOut));
    }

    private boolean proccessAndCompare(String original, int reviseTo, String expected) {
        BlockComment commentBlock = new BlockComment(0, 0, original, null, null);
        AdvancedCopyrightComment advComment = AdvancedCopyrightComment.parse((BlockComment)commentBlock, (int)7);
        advComment.setRevisionYear(reviseTo);
        String actual = advComment.getCopyrightComment();
        boolean areSame = expected.equals(actual);
        if (!areSame) {
            this.printBadTest(original, expected, actual);
        }
        return areSame;
    }

    private void printBadTest(String original, String expected, String actual) {
        System.out.println("");
        System.out.println("----------------------------------------------");
        System.out.println("-------ERROR in test: " + this.name.getMethodName());
        System.out.println("----------------------------------------------");
        System.out.println("----- Original:");
        System.out.println(original);
        System.out.println("----- Expected:");
        System.out.println(expected);
        System.out.println("----- Actual: ");
        System.out.println(actual);
        System.out.println("##############################################");
    }
}

