/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.releng.tests.FileTool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BuildTests {
    private String logFileName;
    private static final int HTML = 0;
    private static final int PROPERTIES = 1;
    private static final int XML = 2;
    public static final List<String> REQUIRED_FEATURE_FILES_EPL2 = Arrays.asList("epl-2.0.html", "feature.properties", "feature.xml", "license.html");
    public static final List<String> REQUIRED_FEATURE_FILES_EPL1 = Arrays.asList("epl-v10.html", "feature.properties", "feature.xml", "license.html");
    public static final String REQUIRED_FEATURE_SUFFIX = "";
    public static final List<String> REQUIRED_PLUGIN_FILES = Arrays.asList("about.html", "plugin.properties", "plugin.xml");
    public static final String REQUIRED_PLUGIN_SUFFIX = ".jar";
    public static final List<String> REQUIRED_FEATURE_PLUGIN_FILES = Arrays.asList("about.html", "about.ini", "about.mappings", "about.properties", "plugin.properties", "plugin.xml");
    public static final String REQUIRED_FEATURE_PLUGIN_SUFFIX = ".gif";
    public static final List<String> REQUIRED_FRAGMENT_FILES = Arrays.asList("fragment.xml");
    public static final String REQUIRED_FRAGMENT_SUFFIX = "";
    public static final List<String> REQUIRED_SWT_FRAGMENT_FILES = Arrays.asList("fragment.properties");
    public static final String REQUIRED_SWT_FRAGMENT_SUFFIX = "";
    public static final List<String> REQUIRED_SOURCE_FILES = Arrays.asList("about.html");
    public static final String REQUIRED_SOURCE_SUFFIX = ".zip";
    public static final List<String> REQUIRED_BUNDLE_FILES = Arrays.asList("about.html");
    public static final String REQUIRED_BUNDLE_MANIFEST = "MANIFEST.MF";
    public static final String REQUIRED_BUNDLE_SUFFIX = ".jar";
    public static final List<String> SUFFIX_EXEMPT_LIST = Arrays.asList("org.eclipse.swt", "org.apache.ant");
    public static final int PLUGIN_COUNT = 84;
    public static final int FEATURE_COUNT = 9;

    private static FileTool.IZipFilter getTrueFilter() {
        return new FileTool.IZipFilter(){

            @Override
            public boolean shouldExtract(String fullEntryName, String entryName, int depth) {
                return true;
            }

            @Override
            public boolean shouldUnzip(String fullEntryName, String entryName, int depth) {
                return true;
            }
        };
    }

    private boolean hasErrors(String string) {
        boolean result = false;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader aReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));){
                String aLine = aReader.readLine();
                while (aLine != null) {
                    int aNumber = this.parseLine(aLine);
                    if (aNumber > 0) {
                        result = true;
                    }
                    aLine = aReader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not open log file: " + string);
            result = true;
        }
        catch (IOException iOException) {
            System.out.println("Error reading log file: " + string);
            result = true;
        }
        return result;
    }

    @Test
    public void testChkpii() {
        try {
            Runtime aRuntime = Runtime.getRuntime();
            Process aProcess = aRuntime.exec(String.valueOf(this.getExec()) + " /?");
            BufferedReader aBufferedReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
            while (aBufferedReader.readLine() != null) {
            }
            aProcess.waitFor();
        }
        catch (IOException e) {
            System.out.println("testChkpii-NotInstalled");
            System.out.println(e.getMessage());
            System.out.println("Skipping chkpii test.");
            Assert.assertTrue((boolean)true);
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String zipFile = this.locateEclipseZip();
        String sniffFolder = Platform.getLocation().toOSString();
        try {
            if (zipFile.isEmpty()) {
                FileTool.unzip(BuildTests.getTrueFilter(), new File(sniffFolder));
            } else {
                FileTool.unzip(BuildTests.getTrueFilter(), new ZipFile(zipFile), new File(sniffFolder));
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)(String.valueOf(zipFile) + ": " + sniffFolder + ": " + "IOException unzipping Eclipse for chkpii"));
        }
        boolean result1 = this.testChkpii(0);
        boolean result2 = this.testChkpii(2);
        boolean result3 = this.testChkpii(1);
        Assert.assertTrue((String)"Translation errors in files.  See the chkpii logs linked from the test results page for details.", (result1 && result2 && result3 ? 1 : 0) != 0);
    }

    private boolean testChkpii(int type) {
        Runtime aRuntime = Runtime.getRuntime();
        String chkpiiString = this.getChkpiiString(type);
        try {
            Process aProcess = aRuntime.exec(chkpiiString);
            BufferedReader aBufferedReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));
            while (aBufferedReader.readLine() != null) {
            }
            aProcess.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return !this.hasErrors(this.getOutputFile(type));
    }

    private String getChkpiiString(int type) {
        return String.valueOf(this.getExec()) + " " + this.getFilesToTest(type) + " -E -O " + this.getOutputFile(type) + " -XM @" + this.getExcludeErrors() + " -X " + this.getExcludeFile() + " -S /jsq /tex";
    }

    private String locateEclipseZip() {
        String installDir = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + ".." + File.separator + "..";
        File aFile = new File(installDir);
        File[] fileArray = aFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.startsWith("eclipse-SDK-") && fileName.endsWith(REQUIRED_SOURCE_SUFFIX)) {
                return file.getPath();
            }
            ++n2;
        }
        return "";
    }

    private String getExcludeFile() {
        String aString = System.getProperty("PLUGIN_PATH");
        return String.valueOf(aString) + File.separator + "ignoreFiles.txt";
    }

    private String getOutputFile(int type) {
        new File(this.logFileName).mkdirs();
        String aString = String.valueOf(this.logFileName) + File.separator + "org.eclipse.nls.";
        aString = new File(aString).getPath();
        switch (type) {
            case 0: {
                return String.valueOf(aString) + "html.txt";
            }
            case 1: {
                return String.valueOf(aString) + "properties.txt";
            }
            case 2: {
                return String.valueOf(aString) + "xml.txt";
            }
        }
        return String.valueOf(aString) + "other.txt";
    }

    private String getFilesToTest(int type) {
        String sniffFolder = Platform.getLocation().toOSString();
        String aString = String.valueOf(new File(sniffFolder).getPath()) + File.separator;
        switch (type) {
            case 0: {
                return String.valueOf(aString) + "*.htm*";
            }
            case 1: {
                return String.valueOf(aString) + "*.properties";
            }
            case 2: {
                return String.valueOf(aString) + "*.xml";
            }
        }
        return String.valueOf(aString) + "*.*";
    }

    private String getExec() {
        return new File("chkpw1402.exe").getPath();
    }

    private String getExcludeErrors() {
        String os = Platform.getOS();
        String fileName = os.equals("win32") ? "ignoreErrorsWindows.txt" : "ignoreErrorsUnix.txt";
        String aString = System.getProperty("PLUGIN_PATH");
        return String.valueOf(aString) + File.separator + fileName;
    }

    private int parseLine(String aLine) {
        int index = aLine.indexOf("Files Could Not Be Processed: ");
        if (index == -1) {
            index = aLine.indexOf("Files Contain Error");
        }
        if (index == -1) {
            return -1;
        }
        String aString = aLine.substring(0, index).trim();
        return Integer.parseInt(aString);
    }

    @Before
    public void setUp() {
        this.logFileName = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + ".." + File.separator + ".." + File.separator + "results" + File.separator + "chkpii";
    }

    @Test
    public void testFeatureFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] fileArray = featureDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File aFeature = fileArray[n2];
            List<String> testFiles = REQUIRED_FEATURE_FILES_EPL2;
            if (aFeature.getName().startsWith("org.eclipse.ecf")) {
                testFiles = REQUIRED_FEATURE_FILES_EPL1;
            }
            if (!this.testDirectory(aFeature, testFiles, "")) {
                result.add(aFeature.getPath());
            }
            ++n2;
        }
        String aString = "";
        if (!result.isEmpty()) {
            for (String element : result) {
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        Assert.assertTrue((String)("Feature directory missing required files: " + aString), (boolean)result.isEmpty());
    }

    @Test
    public void testPluginFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] fileArray = pluginDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File aPlugin = fileArray[n2];
            if (aPlugin.getName().indexOf("test") == -1 && !this.testPluginFile(aPlugin)) {
                result.add(aPlugin.getPath());
            }
            ++n2;
        }
        String aString = "";
        if (!result.isEmpty()) {
            for (String element : result) {
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        Assert.assertTrue((String)("Plugin directory missing required files: " + aString), (boolean)result.isEmpty());
    }

    private boolean testPluginFile(File aPlugin) {
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, REQUIRED_SOURCE_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FEATURE_PLUGIN_FILES, REQUIRED_FEATURE_PLUGIN_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, ".jar")) {
            return true;
        }
        if (this.testSourcePlugin(aPlugin)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FRAGMENT_FILES, "") || this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, "")) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_SWT_FRAGMENT_FILES, "")) {
            return true;
        }
        return this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, ".jar");
    }

    private boolean testPluginJar(File aDirectory, List<String> requiredFiles) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile jarredPlugin = new ZipFile(aDirectory);){
                Enumeration<? extends ZipEntry> _enum = jarredPlugin.entries();
                while (_enum.hasMoreElements()) {
                    list.add(_enum.nextElement().toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list.containsAll(requiredFiles);
    }

    private boolean testDirectory(File aDirectory, List<String> requiredFiles, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(requiredFiles)) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        if (requiredSuffix.isEmpty() || SUFFIX_EXEMPT_LIST.contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testBundleDirectory(File aDirectory, List<String> requiredFiles, String manifestFile, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(requiredFiles)) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        File metaDir = new File(aDirectory, "META-INF");
        String[] metaFiles = metaDir.list();
        if (metaFiles == null) {
            return false;
        }
        String[] stringArray = metaFiles;
        int n = metaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename == manifestFile) {
                return true;
            }
            ++n2;
        }
        if (!metaDir.exists()) {
            return false;
        }
        if (requiredSuffix.isEmpty() || SUFFIX_EXEMPT_LIST.contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testSourcePlugin(File aPlugin) {
        if (!this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, "")) {
            return false;
        }
        File sourceDir = new File(aPlugin, "src");
        File[] sourceDirs = sourceDir.listFiles();
        if (sourceDirs == null) {
            return false;
        }
        File[] fileArray = sourceDirs;
        int n = sourceDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File aSourceDir = fileArray[n2];
            if (!this.testDirectory(aSourceDir, REQUIRED_SOURCE_FILES, REQUIRED_SOURCE_SUFFIX)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Test
    public void testJavadocLogs() throws Exception {
        boolean problemLogsExist;
        String javadocUrls = System.getProperty("RELENGTEST.JAVADOC.URLS");
        if (javadocUrls == null) {
            System.err.println("WARNING: no javadoc logs to test, since RELENGTEST.JAVADOC.URLS property was not set");
            return;
        }
        System.err.println("RELENGTEST.JAVADOC.URLS: " + javadocUrls);
        String[] urls = javadocUrls.split(",");
        URL[] javadocLogs = new URL[urls.length];
        int i = 0;
        while (i < urls.length) {
            javadocLogs[i] = new URL(urls[i]);
            System.err.println("javadocLogs[" + i + "]: " + javadocLogs[i]);
            ++i;
        }
        JavadocLog javadocLog = new JavadocLog(javadocLogs);
        String message = "javadoc errors and/or warnings in: \n";
        boolean bl = problemLogsExist = javadocLog.logs.size() > 0;
        if (problemLogsExist) {
            int i2 = 0;
            while (i2 < javadocLog.logs.size()) {
                message = message.concat(String.valueOf(((String)javadocLog.logs.get(i2)).toString()) + "\n");
                ++i2;
            }
        }
        message = message.concat("See the javadoc logs linked from the test results page for details");
        Assert.assertTrue((String)message, (!problemLogsExist ? 1 : 0) != 0);
    }

    @Test
    public void testDirtyLogSize() throws Exception {
        URL standardReportURL = this.getClass().getResource("standardDirtReport.txt");
        URLConnection standardReportURLConnection = standardReportURL.openConnection();
        long MAX_ALLOWED_BYTES = standardReportURLConnection.getContentLength();
        System.out.println("DEBUG: MAX_ALLOWED_BYTES: " + MAX_ALLOWED_BYTES);
        String buildId = System.getProperty("buildId");
        Assert.assertNotNull((String)"buildId property must be specified for testDirtyLogSize test", (Object)buildId);
        String downloadHost = "build.eclipse.org/eclipse/builds/4" + buildId.charAt(0) + "/siteDir";
        String urlOfFile = "http://" + downloadHost + "/eclipse/downloads/drops4/" + buildId + "/buildlogs/dirtReport.txt";
        URL logURL = new URL(urlOfFile);
        URLConnection urlConnection = logURL.openConnection();
        long nBytes = urlConnection.getContentLength();
        System.out.println("Debug info for testDirtyLogSize");
        System.out.println("Debug: nBytes: " + nBytes);
        this.printHeaders(urlConnection);
        Assert.assertTrue((String)("Either file (url) does not exist (build may have been removed?), or HTTP response does not contain content length. urlOfFile: " + urlOfFile), (-1L != nBytes ? 1 : 0) != 0);
        Assert.assertFalse((String)("dirtReport file has increased in size, indicating a regression. See " + urlOfFile), (nBytes > MAX_ALLOWED_BYTES ? 1 : 0) != 0);
        Assert.assertFalse((String)("Good news! dirtReport file has decreased in size, compared to standard, so the standardDirtReport.txt file should be replaced with the one at " + urlOfFile + ". But NOTE: results may not be accurate, if there are other errors in build, so diff is recommended."), (nBytes < MAX_ALLOWED_BYTES ? 1 : 0) != 0);
    }

    @Test
    public void testJarSign() throws Exception {
        String buildId = System.getProperty("buildId");
        Assert.assertNotNull((String)"buildId property must be specified for testJarSign test", (Object)buildId);
        String downloadHost = "build.eclipse.org/eclipse/builds/4" + buildId.charAt(0) + "/siteDir";
        String urlOfFile = "http://" + downloadHost + "/eclipse/downloads/drops4/" + buildId + "/buildlogs/reporeports/reports/unsigned8.txt";
        URL logURL = new URL(urlOfFile);
        URLConnection urlConnection = logURL.openConnection();
        long nBytes = urlConnection.getContentLength();
        Assert.assertTrue((String)("Some bundles are unsigned please refer  " + urlOfFile), (2L > nBytes ? 1 : 0) != 0);
    }

    private String getDownloadHost() {
        String downloadHost = System.getProperty("downloadHost");
        if (downloadHost == null) {
            downloadHost = "download.eclipse.org";
        }
        return downloadHost;
    }

    private void printHeaders(URLConnection urlConnection) {
        System.out.println("Debug: Headers for urlConnection to " + urlConnection.getURL());
        Map<String, List<String>> allFields = urlConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : allFields.entrySet()) {
            for (String value : entry.getValue()) {
                System.out.printf("Debug: %-20s %-30s %n", "key: " + entry.getKey(), "value: " + value);
            }
        }
    }

    @Test
    public void testComparatorLogSize() throws Exception {
        long MAX_ALLOWED_BYTES = 210L;
        String buildId = System.getProperty("buildId");
        Assert.assertNotNull((String)"buildId property must be specified for testComparatorLogSize test", (Object)buildId);
        String buildType = buildId.substring(0, 1);
        if (!buildType.equals("N")) {
            String downloadHost = this.getDownloadHost();
            String urlOfFile = "http://" + downloadHost + "/eclipse/downloads/drops4/" + buildId + "/buildlogs/comparatorlogs/buildtimeComparatorUnanticipated.log.txt";
            URL logURL = new URL(urlOfFile);
            URLConnection urlConnection = logURL.openConnection();
            long nBytes = urlConnection.getContentLength();
            System.out.println("Debug info for testComparatorLogSize");
            System.out.println("Debug: nBytes: " + nBytes);
            this.printHeaders(urlConnection);
            Assert.assertTrue((String)("Either file (url) does not exist, or HTTP response does not contain content length. urlOfFile: " + urlOfFile), (-1L != nBytes ? 1 : 0) != 0);
            Assert.assertTrue((String)("Unanticipated comparator log file has increased in size, indicating a regression. See " + urlOfFile), (nBytes <= MAX_ALLOWED_BYTES ? 1 : 0) != 0);
            if (MAX_ALLOWED_BYTES > nBytes + 20L) {
                System.out.println("WARNING: MAX_ALLOWED_BYTES was larger than bytes found, by " + (MAX_ALLOWED_BYTES - nBytes) + ", which may indicate MAX_ALLOWED_BYTES needs to be lowered, to catch regressions.");
            }
        } else {
            System.out.println("noComparatorTestsForNBuilds");
        }
    }

    public class FileSuffixFilter
    implements FilenameFilter {
        private String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                return false;
            }
            return name.substring(lastDot).equals(this.suffix);
        }
    }

    private class JavadocLog {
        private ArrayList<String> logs = new ArrayList();

        private JavadocLog(URL[] logs) {
            this.findProblems(logs);
        }

        private void findProblems(URL[] javadocLogs) {
            String JAVADOC_WARNING = ": warning";
            String JAVADOC_ERROR = ": error";
            String JAVADOC_JAVA = ".java:";
            URL[] uRLArray = javadocLogs;
            int n = javadocLogs.length;
            int n2 = 0;
            while (n2 < n) {
                URL javadocLog = uRLArray[n2];
                try {
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(javadocLog.openStream()));){
                        String tmp;
                        while ((tmp = in.readLine()) != null) {
                            String fileName;
                            if ((tmp = tmp.toLowerCase()).indexOf(JAVADOC_ERROR) == -1 && tmp.indexOf(JAVADOC_WARNING) == -1 && tmp.indexOf(JAVADOC_JAVA) == -1 || this.logs.contains(fileName = new File(javadocLog.getFile()).getName())) continue;
                            this.logs.add(fileName);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    this.logs.add("Unable to find " + new File(javadocLog.getFile()).getName() + " to read.");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    this.logs.add("Unable to read " + new File(javadocLog.getFile()).getName());
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

