/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileTool {
    private static byte[] buffer = new byte[8192];

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    /*
     * Loose catch block
     */
    public static boolean compare(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            boolean bl;
            BufferedInputStream is2;
            BufferedInputStream is1;
            block18: {
                block17: {
                    is1 = new BufferedInputStream(new FileInputStream(file1));
                    is2 = new BufferedInputStream(new FileInputStream(file2));
                    int a = 0;
                    int b = 0;
                    boolean same = true;
                    while (same && a != -1 && b != -1) {
                        a = ((InputStream)is1).read();
                        boolean bl2 = same = a == (b = ((InputStream)is2).read());
                    }
                    bl = same;
                    if (is2 == null) break block17;
                    ((InputStream)is2).close();
                }
                if (is1 == null) break block18;
                ((InputStream)is1).close();
            }
            return bl;
            {
                catch (Throwable throwable2) {
                    try {
                        if (is2 != null) {
                            ((InputStream)is2).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (is1 != null) {
                            ((InputStream)is1).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void copy(File src, File dst) throws IOException {
        FileTool.copy(src.getParentFile(), src, dst);
    }

    public static void copy(File root, File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] children = src.list();
            if (children == null) {
                throw new IOException("Content from directory '" + src.getAbsolutePath() + "' can not be listed.");
            }
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                File child = new File(src, element);
                FileTool.copy(root, child, dst);
                ++n2;
            }
        } else {
            String rootString = root.toString();
            String srcString = src.toString();
            File dstFile = new File(dst, srcString.substring(rootString.length() + 1));
            FileTool.transferData(src, dstFile);
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] children = file.list();
                if (children == null) {
                    children = new String[]{};
                }
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    File child = new File(file, element);
                    FileTool.delete(child);
                    ++n2;
                }
            }
            if (!file.delete()) {
                System.out.println("WARNING: could not delete " + file);
            }
        }
    }

    public static File getFile(String[] segments) {
        File result = new File(segments[0]);
        int i = 1;
        while (i < segments.length) {
            result = new File(result, segments[i]);
            ++i;
        }
        return result;
    }

    public static File[] getFiles(File dir, String[] include, String[] exclude) {
        ArrayList<Object> list = new ArrayList<Object>();
        String[] children = dir.list();
        if (children == null) {
            return new File[0];
        }
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2;
            int n3;
            Object[] objectArray;
            String element = stringArray[n2];
            File child = new File(dir, element);
            String name = child.getName();
            if (child.isDirectory()) {
                File[] result = FileTool.getFiles(child, include, exclude);
                objectArray = result;
                n3 = result.length;
                int n4 = 0;
                while (n4 < n3) {
                    element2 = objectArray[n4];
                    list.add(element2);
                    ++n4;
                }
            } else {
                boolean excludeFile;
                boolean includeFile;
                boolean bl = includeFile = include == null;
                if (include != null) {
                    objectArray = include;
                    n3 = include.length;
                    int n5 = 0;
                    while (n5 < n3) {
                        element2 = objectArray[n5];
                        if (name.endsWith((String)element2)) {
                            includeFile = true;
                            break;
                        }
                        ++n5;
                    }
                }
                boolean bl2 = excludeFile = exclude != null;
                if (exclude != null) {
                    String[] stringArray2 = exclude;
                    int n6 = exclude.length;
                    n3 = 0;
                    while (n3 < n6) {
                        String element22 = stringArray2[n3];
                        if (name.endsWith(element22)) {
                            excludeFile = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (includeFile && !excludeFile) {
                    list.add(child);
                }
            }
            ++n2;
        }
        return list.toArray(new File[0]);
    }

    public static String[] getSegments(File file) {
        return FileTool.getSegments(file.toString(), File.separatorChar);
    }

    public static String[] getSegments(String s, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, "" + separator);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result.toArray(new String[0]);
    }

    public static File[] parsePaths(String paths) {
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(paths, ";");
        while (tokenizer.hasMoreTokens()) {
            result.add(new File(tokenizer.nextToken()));
        }
        return result.toArray(new File[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transferData(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destination));){
                    FileTool.transferData(is, os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void transferData(InputStream source, OutputStream destination) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = source.read(buffer, 0, buffer.length);
            if (bytesRead == -1) continue;
            destination.write(buffer, 0, bytesRead);
        }
    }

    public static void unzip(IZipFilter filter, ZipFile zipFile, File dstDir) throws IOException {
        FileTool.unzip(filter, zipFile, dstDir, dstDir, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(IZipFilter filter, ZipFile zipFile, File rootDstDir, File dstDir, int depth) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                String fullEntryName;
                File file;
                String entryName;
                block27: {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    entryName = entry.getName();
                    file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
                    String destCanPath = dstDir.getCanonicalPath();
                    String fileCanPath = file.getCanonicalPath();
                    if (!fileCanPath.startsWith(String.valueOf(destCanPath) + File.separatorChar)) {
                        throw new IOException("Entry is out side of target dir: " + entryName);
                    }
                    fullEntryName = FileTool.changeSeparator(file.toString().substring(rootDstDir.toString().length() + 1), File.separatorChar, '/');
                    if (filter != null && !filter.shouldExtract(fullEntryName, entryName, depth)) continue;
                    file.getParentFile().mkdirs();
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try {
                        InputStream src = zipFile.getInputStream(entry);
                        try {
                            try (FileOutputStream dst = new FileOutputStream(file);){
                                FileTool.transferData(src, dst);
                            }
                            if (src == null) break block27;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (src == null) throw throwable;
                            src.close();
                            throw throwable;
                        }
                        src.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                if (!entryName.endsWith(".zip") && !entryName.endsWith(".jar") || filter != null && !filter.shouldUnzip(fullEntryName, entryName, depth)) continue;
                String fileName = file.getName();
                String dirName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_" + fileName.substring(fileName.length() - 3);
                ZipFile innerZipFile = null;
                try {
                    innerZipFile = new ZipFile(file);
                    File innerDstDir = new File(file.getParentFile(), dirName);
                    FileTool.unzip(filter, innerZipFile, rootDstDir, innerDstDir, depth + 1);
                    file.delete();
                }
                catch (IOException e) {
                    if (innerZipFile != null) {
                        try {
                            innerZipFile.close();
                            System.out.println("Could not unzip: " + fileName + ". InnerZip = " + innerZipFile.getName() + ". Lenght: " + innerZipFile.getName().length());
                        }
                        catch (IOException iOException) {}
                    } else {
                        System.out.println("Could not unzip: " + fileName + ". InnerZip = <null>");
                    }
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static void unzip(IZipFilter filter, File dstDir) {
        FileTool.unzip(filter, dstDir, dstDir, 0);
    }

    private static void unzip(IZipFilter filter, File rootDstDir, File dstDir, int depth) {
        File[] entries = rootDstDir.listFiles();
        if (entries == null) {
            entries = new File[]{};
        }
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (entry.isDirectory()) {
                FileTool.unzip(filter, entry, dstDir, depth);
            }
            String entryName = entry.getName();
            File file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
            if (entryName.endsWith(".zip") || entryName.endsWith(".jar")) {
                String fileName = file.getName();
                String dirName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_" + fileName.substring(fileName.length() - 3);
                ZipFile innerZipFile = null;
                try {
                    innerZipFile = new ZipFile(entry);
                    File innerDstDir = new File(entry.getParentFile(), dirName);
                    FileTool.unzip(filter, innerZipFile, rootDstDir, innerDstDir, depth + 1);
                }
                catch (IOException e) {
                    if (innerZipFile != null) {
                        try {
                            innerZipFile.close();
                            System.out.println("Could not unzip: " + fileName + ". InnerZip = " + innerZipFile.getName() + ". Lenght: " + innerZipFile.getName().length());
                        }
                        catch (IOException iOException) {}
                    } else {
                        System.out.println("Could not unzip: " + fileName + ". InnerZip = <null>");
                    }
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File dir, File zipFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(zipFile));
            try {
                try (ZipOutputStream zos = new ZipOutputStream(bos);){
                    FileTool.zip(dir, dir, zos);
                }
                if (bos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bos == null) throw throwable;
                bos.close();
                throw throwable;
            }
            bos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void zip(File root, File file, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            String name = file.getName();
            String[] list = file.list();
            if (list == null) {
                throw new IOException("Content from directory '" + file.getAbsolutePath() + "' can not be listed.");
            }
            if (name.endsWith("_zip") || name.endsWith("_jar")) {
                String rootString = root.toString();
                String fileString = file.toString();
                String zipEntryName = fileString.substring(rootString.length() + 1);
                int underscoreIndex = zipEntryName.lastIndexOf("_");
                zipEntryName = String.valueOf(zipEntryName.substring(0, underscoreIndex)) + "." + zipEntryName.substring(underscoreIndex + 1);
                ZipEntry zipEntry = new ZipEntry(FileTool.changeSeparator(zipEntryName, File.separatorChar, '/'));
                zos.putNextEntry(zipEntry);
                ZipOutputStream zos2 = new ZipOutputStream(zos);
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    File item = new File(file, element);
                    FileTool.zip(file, item, zos2);
                    ++n2;
                }
                zos2.finish();
                zos.closeEntry();
            } else {
                String[] stringArray = list;
                int n = list.length;
                int fileString = 0;
                while (fileString < n) {
                    String element = stringArray[fileString];
                    File item = new File(file, element);
                    FileTool.zip(root, item, zos);
                    ++fileString;
                }
            }
        } else {
            String rootString = root.toString();
            String fileString = file.toString();
            String zipEntryName = fileString.substring(rootString.length() + 1);
            ZipEntry zipEntry = new ZipEntry(FileTool.changeSeparator(zipEntryName, File.separatorChar, '/'));
            zos.putNextEntry(zipEntry);
            Throwable throwable = null;
            Object var8_19 = null;
            try (FileInputStream fos = new FileInputStream(file);){
                FileTool.transferData(fos, zos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            zos.closeEntry();
        }
    }

    public static interface IZipFilter {
        public boolean shouldExtract(String var1, String var2, int var3);

        public boolean shouldUnzip(String var1, String var2, int var3);
    }
}

