/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.releng.tests.LocalDiskRepositoryTest;
import org.eclipse.releng.tools.git.GitCopyrightAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitCopyrightAdapterTest
extends LocalDiskRepositoryTest {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final String PROJECT_NAME = "Project";
    private static final String FILE1_NAME = "Foo.java";
    private static final String FILE2_NAME = "Bar.java";
    private Repository db;
    private File trash;
    private File gitDir;
    private IProject project;
    private IFile file1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.db = this.createWorkRepository();
        this.trash = this.db.getWorkTree();
        this.gitDir = new File(this.trash, ".git");
        this.project = this.createProject(PROJECT_NAME);
        this.file1 = this.project.getFile(FILE1_NAME);
        this.connect();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.project.exists()) {
            this.project.delete(true, true, NULL_MONITOR);
        }
        if (this.gitDir.exists()) {
            FileUtils.delete((File)this.gitDir, (int)3);
        }
        super.tearDown();
    }

    @Test
    public void testLastModifiedYear() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.db);){
            git.add().addFilepattern("Project/Foo.java").call();
            PersonIdent committer2011 = new PersonIdent(this.committer, this.getDateForYear(2011));
            git.commit().setMessage("old commit").setCommitter(committer2011).call();
            git.add().addFilepattern("Project/Bar.java").call();
            git.commit().setMessage("new commit").call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        GitCopyrightAdapter adapter = new GitCopyrightAdapter(new IResource[]{this.project});
        adapter.initialize(NULL_MONITOR);
        int lastModifiedYear = adapter.getLastModifiedYear(this.file1, NULL_MONITOR);
        Assert.assertEquals((long)2011L, (long)lastModifiedYear);
    }

    @Test
    public void testCopyrightUpdateComment() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.db);){
            git.add().addFilepattern("Project/Foo.java").call();
            git.commit().setMessage("copyright update").call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        GitCopyrightAdapter adapter = new GitCopyrightAdapter(new IResource[]{this.project});
        adapter.initialize(NULL_MONITOR);
        int lastModifiedYear = adapter.getLastModifiedYear(this.file1, NULL_MONITOR);
        Assert.assertEquals((long)0L, (long)lastModifiedYear);
    }

    private IProject createProject(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            project.delete(true, null);
        }
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        desc.setLocation((IPath)new Path(new File(this.db.getWorkTree(), name).getPath()));
        project.create(desc, null);
        project.open(null);
        IFile file1 = project.getFile(FILE1_NAME);
        file1.create((InputStream)new ByteArrayInputStream("Hello, world".getBytes(project.getDefaultCharset())), false, null);
        IFile file2 = project.getFile(FILE2_NAME);
        file2.create((InputStream)new ByteArrayInputStream("Hi there".getBytes(project.getDefaultCharset())), false, null);
        return project;
    }

    private void connect() throws CoreException {
        new ConnectProviderOperation(this.project, this.gitDir).execute(null);
    }

    private Date getDateForYear(int year) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        return formatter.parse(String.valueOf(Integer.toString(year)) + "/6/30");
    }
}

