/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.internal.tools.pomversion;

import java.util.HashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.internal.tools.pomversion.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class PomVersionMarkerResolution
extends WorkbenchMarkerResolution {
    private IMarker marker;
    private String correctedVersion;

    @Deprecated
    public PomVersionMarkerResolution(String correctedVersion) {
        this.correctedVersion = correctedVersion;
    }

    public PomVersionMarkerResolution(IMarker marker, String correctedVersion) {
        this.marker = marker;
        this.correctedVersion = correctedVersion;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.PomVersionMarkerResolution_label, (Object)this.correctedVersion);
    }

    public void run(IMarker marker) {
        block21: {
            IFile file;
            try {
                this.correctedVersion = (String)marker.getAttribute("pom.CorrectVersion");
            }
            catch (CoreException e1) {
                RelEngPlugin.log(e1);
            }
            if (this.correctedVersion == null || this.correctedVersion.trim().length() == 0) {
                return;
            }
            int charstart = marker.getAttribute("charStart", -1);
            int charend = marker.getAttribute("charEnd", -1);
            if (charstart < 0 || charend < 0) {
                return;
            }
            IResource resource = marker.getResource();
            if (resource.exists() && resource.getType() == 1 && !(file = (IFile)resource).isReadOnly()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                ITextFileBufferManager fbm = FileBuffers.getTextFileBufferManager();
                IPath location = file.getFullPath();
                ITextFileBuffer buff = null;
                try {
                    try {
                        fbm.connect(location, LocationKind.IFILE, (IProgressMonitor)monitor);
                        buff = fbm.getTextFileBuffer(location, LocationKind.IFILE);
                        if (buff == null) break block21;
                        IDocument doc = buff.getDocument();
                        try {
                            if (charstart > -1 && charend > -1) {
                                doc.replace(charstart, charend - charstart, this.correctedVersion);
                                buff.commit((IProgressMonitor)monitor, true);
                            }
                        }
                        catch (BadLocationException ble) {
                            RelEngPlugin.log(ble);
                        }
                    }
                    catch (CoreException e) {
                        RelEngPlugin.log(e);
                        try {
                            if (buff != null) {
                                fbm.disconnect(location, LocationKind.IFILE, (IProgressMonitor)monitor);
                            }
                        }
                        catch (CoreException e2) {
                            RelEngPlugin.log(e2);
                        }
                    }
                }
                finally {
                    try {
                        if (buff != null) {
                            fbm.disconnect(location, LocationKind.IFILE, (IProgressMonitor)monitor);
                        }
                    }
                    catch (CoreException e) {
                        RelEngPlugin.log(e);
                    }
                }
            }
        }
    }

    public String getDescription() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            if (!iMarker.equals((Object)this.marker)) {
                try {
                    if (iMarker.getType().equals("org.eclipse.releng.tools.pomVersionProblem")) {
                        mset.add(iMarker);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }
}

