/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.CopyrightComment;
import org.eclipse.releng.tools.RelEngPlugin;

public class AdvancedCopyrightComment
extends CopyrightComment {
    private static final String YEAR_REGEX = "(19|20|21|22|23)\\d{2}";
    private static final String DATE_VAR = "${date}";
    private static final String NEW_LINE = "\n";
    private String preYearLinesString = null;
    private String yearLineString = null;
    private String postYearLineString = null;
    private int yearsCount;

    @Override
    public String getCopyrightComment() {
        if (this.preYearLinesString != null || this.postYearLineString != null) {
            StringBuilder copyrightComment = new StringBuilder();
            if (this.preYearLinesString != null) {
                copyrightComment.append(this.preYearLinesString);
            }
            if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
                String fixedYearLine;
                if (this.yearsCount == 1) {
                    fixedYearLine = AdvancedCopyrightComment.insertRevisedYear(this.yearLineString, this.getRevisionYear());
                } else {
                    fixedYearLine = AdvancedCopyrightComment.updateLastYear(this.yearLineString, this.getRevisionYear());
                    if (fixedYearLine == null) {
                        return null;
                    }
                }
                copyrightComment.append(fixedYearLine);
            } else {
                copyrightComment.append(this.yearLineString);
            }
            copyrightComment.append(this.postYearLineString);
            return copyrightComment.toString();
        }
        String linePrefix = this.getCommentPrefix();
        if (linePrefix == null) {
            return null;
        }
        StringWriter out = new StringWriter();
        Throwable throwable = null;
        Object var4_7 = null;
        try (PrintWriter writer = new PrintWriter(out);){
            this.writeCommentStart(writer);
            this.writeLegal(writer, linePrefix);
            this.writeCommentEnd(writer);
            return out.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static AdvancedCopyrightComment parse(BlockComment commentBock, int commentStyle) {
        if (commentBock == null) {
            return AdvancedCopyrightComment.defaultComment(commentStyle);
        }
        String comment = commentBock.getContents();
        String fileLineDelimiter = TextUtilities.determineLineDelimiter((String)comment, (String)NEW_LINE);
        String[] commentLines = comment.split("\\r?\\n");
        StringBuilder preYearLines = new StringBuilder();
        String yearLine = null;
        StringBuilder postYearLines = new StringBuilder();
        boolean yearFound = false;
        int i = 0;
        while (i < commentLines.length) {
            String line = commentLines[i];
            if (yearFound) {
                if (i != commentLines.length - 1) {
                    postYearLines.append(String.valueOf(line) + fileLineDelimiter);
                } else {
                    Character lastchar = Character.valueOf(comment.charAt(comment.length() - 1));
                    if (Character.isWhitespace(lastchar.charValue())) {
                        postYearLines.append(String.valueOf(line) + lastchar);
                    } else {
                        postYearLines.append(line);
                    }
                }
            } else if (line.matches(".*(19|20|21|22|23)\\d{2}.*")) {
                yearFound = true;
                yearLine = String.valueOf(line) + fileLineDelimiter;
            } else {
                preYearLines.append(String.valueOf(line) + fileLineDelimiter);
            }
            ++i;
        }
        if (!yearFound) {
            return null;
        }
        int createdYear = AdvancedCopyrightComment.getFirstYear(yearLine);
        if (createdYear == 0) {
            return null;
        }
        int yearsOnLine = AdvancedCopyrightComment.countYearsOnLine(yearLine);
        int revisedYear = yearsOnLine == 1 ? -1 : AdvancedCopyrightComment.getLastYear(yearLine);
        return new AdvancedCopyrightComment(commentStyle, createdYear, revisedYear, yearsOnLine, preYearLines.toString(), yearLine, postYearLines.toString());
    }

    public static AdvancedCopyrightComment defaultComment(int commentStyle) {
        return new AdvancedCopyrightComment(commentStyle, -1, -1, 1, null, null, null);
    }

    private AdvancedCopyrightComment(int commentStyle, int creationYear, int revisionYear, int yearsCount, String preYearComment, String middleYearsComment, String postYearComment) {
        super(commentStyle, creationYear == -1 ? AdvancedCopyrightComment.getPreferenceStore().getInt("org.eclipse.releng.tools.creationYear") : creationYear, revisionYear);
        this.preYearLinesString = preYearComment;
        this.yearLineString = middleYearsComment;
        this.postYearLineString = postYearComment;
        this.yearsCount = yearsCount;
    }

    private static IPreferenceStore getPreferenceStore() {
        return RelEngPlugin.getDefault().getPreferenceStore();
    }

    private static String[] getLegalLines() {
        StringTokenizer st = new StringTokenizer(AdvancedCopyrightComment.getPreferenceStore().getString("org.eclipse.releng.tools.copyrightTemplate"), NEW_LINE, true);
        ArrayList<String> lines = new ArrayList<String>();
        String previous = NEW_LINE;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if (NEW_LINE.equals(previous)) {
                lines.add(current);
            }
            previous = current;
        }
        String[] stringLines = new String[lines.size()];
        stringLines = lines.toArray(stringLines);
        return stringLines;
    }

    private void writeLegal(PrintWriter writer, String linePrefix) {
        String[] legalLines = AdvancedCopyrightComment.getLegalLines();
        int i = 0;
        while (i < legalLines.length) {
            String currentLine = legalLines[i];
            int offset = currentLine.indexOf(DATE_VAR);
            if (offset > -1) {
                writer.print(String.valueOf(linePrefix) + ' ' + currentLine.substring(0, offset) + this.getCreationYear());
                if (this.hasRevisionYear() && this.getRevisionYear() != this.getCreationYear()) {
                    writer.print(", " + this.getRevisionYear());
                }
                this.println(writer, currentLine.substring(offset + DATE_VAR.length(), currentLine.length()));
            } else if (NEW_LINE.equals(currentLine)) {
                this.println(writer, linePrefix);
            } else {
                this.println(writer, String.valueOf(linePrefix) + ' ' + currentLine);
            }
            ++i;
        }
    }

    private static String updateLastYear(String line, int newYear) {
        Matcher matcher = Pattern.compile(YEAR_REGEX).matcher(line);
        int lastStart = -1;
        while (matcher.find()) {
            lastStart = matcher.start();
        }
        if (lastStart == -1) {
            return null;
        }
        String before = line.substring(0, lastStart);
        String after = line.substring(lastStart + 4);
        String updatedLine = String.valueOf(before) + Integer.toString(newYear) + after;
        return updatedLine;
    }

    private static String insertRevisedYear(String line, int year) {
        Matcher matcher = Pattern.compile(YEAR_REGEX).matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String before = line.substring(0, matcher.end());
        String after = line.substring(matcher.end());
        String updatedLine = String.valueOf(before) + ", " + Integer.toString(year) + after;
        return updatedLine;
    }

    private static int countYearsOnLine(String line) {
        Matcher yearMatcher = Pattern.compile(YEAR_REGEX).matcher(line);
        int count = 0;
        while (yearMatcher.find()) {
            ++count;
        }
        return count;
    }

    private static int getFirstYear(String line) {
        Matcher yearMatcher = Pattern.compile(YEAR_REGEX).matcher(line);
        if (yearMatcher.find()) {
            return Integer.parseInt(yearMatcher.group());
        }
        return 0;
    }

    private static int getLastYear(String line) {
        Matcher yearMatcher = Pattern.compile(YEAR_REGEX).matcher(line);
        int lastYear = -1;
        while (yearMatcher.find()) {
            lastYear = Integer.parseInt(yearMatcher.group());
        }
        return lastYear;
    }
}

