/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.tools.AdvancedCopyrightComment;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.CopyrightComment;
import org.eclipse.releng.tools.IBMCopyrightComment;
import org.eclipse.releng.tools.IRepositoryProviderCopyrightAdapterFactory;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.RepositoryProviderCopyrightAdapter;
import org.eclipse.releng.tools.SourceFile;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class AdvancedFixCopyrightAction
implements IObjectActionDelegate {
    private static final int UNIT_OF_WORK = 1;
    private String newLine = System.getProperty("line.separator");
    private Map<String, List<String>> log = new HashMap<String, List<String>>();
    private MessageConsole console;
    protected IStructuredSelection selection;
    private static final int currentYear = new GregorianCalendar().get(1);

    protected IResource[] getSelectedResources() {
        ArrayList<IResource> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<IResource>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                this.addResource(elements.next(), resources);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IResource[] result = new IResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IResource[0];
    }

    private void addResource(Object element, ArrayList<IResource> resources) {
        if (element instanceof IResource) {
            resources.add((IResource)element);
        } else if (element instanceof IWorkingSet) {
            IWorkingSet ws = (IWorkingSet)element;
            IAdaptable[] elements = ws.getElements();
            int i = 0;
            while (i < elements.length) {
                this.addResource(elements[i], resources);
                ++i;
            }
        } else if (element instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)element;
            this.addResource(a.getAdapter(IResource.class), resources);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.log = new HashMap<String, List<String>>();
        this.console = new FixConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
        }
        catch (PartInitException e) {
            RelEngPlugin.log((CoreException)((Object)e));
        }
        final MessageConsoleStream stream = this.console.newMessageStream();
        WorkspaceJob wJob = new WorkspaceJob(Messages.getString("AdvancedFixCopyrightAction.1")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    long start = System.currentTimeMillis();
                    stream.println(Messages.getString("AdvancedFixCopyrightAction.2"));
                    IResource[] results = AdvancedFixCopyrightAction.this.getSelectedResources();
                    stream.println(NLS.bind((String)Messages.getString("AdvancedFixCopyrightAction.3"), (Object)Integer.toString(results.length)));
                    monitor.subTask(Messages.getString("AdvancedFixCopyrightAction.22"));
                    int totalFileCount = this.countFiles(results);
                    monitor.beginTask(Messages.getString("AdvancedFixCopyrightAction.4"), totalFileCount);
                    RepositoryProviderCopyrightAdapter adapter = AdvancedFixCopyrightAction.this.createCopyrightAdapter(results);
                    if (adapter == null) {
                        if (!RelEngPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.releng.tools.useDefaultRevisionYear")) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, Messages.getString("AdvancedFixCopyrightAction.5"), null));
                        }
                    } else {
                        adapter.initialize((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                    }
                    ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
                    int i = 0;
                    while (i < results.length) {
                        IResource resource = results[i];
                        stream.println(NLS.bind((String)Messages.getString("AdvancedFixCopyrightAction.6"), (Object)resource.getName()));
                        try {
                            resource.accept((IResourceVisitor)new FixCopyrightVisitor(adapter, monitor));
                        }
                        catch (CoreException e1) {
                            exceptions.add(e1);
                        }
                        ++i;
                    }
                    AdvancedFixCopyrightAction.this.writeLogs();
                    AdvancedFixCopyrightAction.this.displayLogs(stream);
                    stream.println(Messages.getString("AdvancedFixCopyrightAction.7"));
                    long end = System.currentTimeMillis();
                    stream.println(NLS.bind((String)Messages.getString("AdvancedFixCopyrightAction.8"), (Object)Long.toString(end - start)));
                    if (!exceptions.isEmpty()) {
                        stream.println(Messages.getString("AdvancedFixCopyrightAction.9"));
                        if (exceptions.size() == 1) {
                            throw (CoreException)((Object)exceptions.get(0));
                        }
                        ArrayList<Status> status = new ArrayList<Status>();
                        for (CoreException ce : exceptions) {
                            status.add(new Status(ce.getStatus().getSeverity(), ce.getStatus().getPlugin(), ce.getStatus().getCode(), ce.getStatus().getMessage(), (Throwable)ce));
                        }
                        throw new CoreException((IStatus)new MultiStatus("org.eclipse.releng.tools", 0, status.toArray(new IStatus[status.size()]), Messages.getString("AdvancedFixCopyrightAction.10"), null));
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            private int countFiles(IResource[] results) {
                int sum = 0;
                IResource[] iResourceArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource file = iResourceArray[n2];
                    FileCountVisitor fileCountVisitor = new FileCountVisitor();
                    try {
                        file.accept((IResourceVisitor)fileCountVisitor);
                    }
                    catch (CoreException coreException) {}
                    sum += fileCountVisitor.getfileCount();
                    ++n2;
                }
                return sum;
            }
        };
        wJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        wJob.setUser(true);
        wJob.schedule();
    }

    protected RepositoryProviderCopyrightAdapter createCopyrightAdapter(IResource[] results) throws CoreException {
        RepositoryProviderType providerType = null;
        int i = 0;
        while (i < results.length) {
            IResource resource = results[i];
            RepositoryProvider p = RepositoryProvider.getProvider((IProject)resource.getProject());
            if (p != null) {
                if (providerType == null) {
                    providerType = RepositoryProviderType.getProviderType((String)p.getID());
                } else if (!providerType.getID().equals(p.getID())) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, Messages.getString("AdvancedFixCopyrightAction.11"), null));
                }
            }
            ++i;
        }
        if (providerType == null) {
            return null;
        }
        IRepositoryProviderCopyrightAdapterFactory factory = (IRepositoryProviderCopyrightAdapterFactory)providerType.getAdapter(IRepositoryProviderCopyrightAdapterFactory.class);
        if (factory == null && (factory = (IRepositoryProviderCopyrightAdapterFactory)Platform.getAdapterManager().loadAdapter(providerType, IRepositoryProviderCopyrightAdapterFactory.class.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, NLS.bind((String)Messages.getString("AdvancedFixCopyrightAction.12"), (Object)providerType.getID()), null));
        }
        return factory.createAdapater(results);
    }

    private void writeLogs() {
        try {
            File aFile = new File(Platform.getLocation().toFile(), "copyrightLog.txt");
            FileOutputStream aStream = new FileOutputStream(aFile);
            Set<Map.Entry<String, List<String>>> aSet = this.log.entrySet();
            for (Map.Entry<String, List<String>> anEntry : aSet) {
                String errorDescription = anEntry.getKey();
                aStream.write(errorDescription.getBytes());
                aStream.write(this.newLine.getBytes());
                List<String> fileList = anEntry.getValue();
                for (String fileName : fileList) {
                    aStream.write("     ".getBytes());
                    aStream.write(fileName.getBytes());
                    aStream.write(this.newLine.getBytes());
                }
            }
            aStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayLogs(MessageConsoleStream stream) {
        Set<Map.Entry<String, List<String>>> aSet = this.log.entrySet();
        for (Map.Entry<String, List<String>> anEntry : aSet) {
            String errorDescription = anEntry.getKey();
            stream.println(errorDescription);
            List<String> fileList = anEntry.getValue();
            for (String fileName : fileList) {
                stream.println("     " + fileName);
            }
        }
    }

    private void processFile(IFile file, RepositoryProviderCopyrightAdapter adapter, IProgressMonitor monitor) {
        int revised;
        if (!this.checkFileExtension(file)) {
            return;
        }
        SourceFile aSourceFile = SourceFile.createFor(file);
        if (!this.checkSourceCreatedOk(aSourceFile, file)) {
            return;
        }
        IPreferenceStore prefStore = RelEngPlugin.getDefault().getPreferenceStore();
        if (!this.checkUserFileIgnoreSettings(prefStore, aSourceFile)) {
            return;
        }
        if (!this.checkMultipleCopyright(file, aSourceFile)) {
            return;
        }
        BlockComment copyrightComment = aSourceFile.getFirstCopyrightComment();
        CopyrightComment ibmCopyright = null;
        if (prefStore.getBoolean("org.eclipse.releng.tools.replaceAllExisting")) {
            ibmCopyright = AdvancedCopyrightComment.defaultComment(aSourceFile.getFileType());
        } else {
            ibmCopyright = AdvancedCopyrightComment.parse(copyrightComment, aSourceFile.getFileType());
            if (ibmCopyright == null && (ibmCopyright = IBMCopyrightComment.parse(copyrightComment, aSourceFile.getFileType())) != null) {
                this.warn(file, copyrightComment, Messages.getString("AdvancedFixCopyrightAction.15"));
            }
        }
        if (ibmCopyright == null) {
            this.warn(file, copyrightComment, Messages.getString("AdvancedFixCopyrightAction.16"));
            return;
        }
        ibmCopyright.setLineDelimiter(aSourceFile.getLineDelimiter());
        int lastMod = revised = ibmCopyright.getRevisionYear();
        if (prefStore.getBoolean("org.eclipse.releng.tools.useDefaultRevisionYear") || adapter == null) {
            lastMod = prefStore.getInt("org.eclipse.releng.tools.revisionYear");
        } else if (lastMod < currentYear) {
            try {
                lastMod = adapter.getLastModifiedYear(file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
            catch (CoreException e) {
                RelEngPlugin.log(4, NLS.bind((String)Messages.getString("AdvancedFixCopyrightAction.17"), (Object)file.getFullPath()), e);
            }
            if (lastMod > currentYear) {
                lastMod = currentYear;
            }
            if (lastMod == 0) {
                this.warn(file, copyrightComment, Messages.getString("AdvancedFixCopyrightAction.18"));
                return;
            }
            if (lastMod == -1) {
                lastMod = prefStore.getInt("org.eclipse.releng.tools.revisionYear");
            }
            if (lastMod < revised) {
                lastMod = revised;
            }
        }
        if (lastMod <= revised && copyrightComment != null && !prefStore.getBoolean("org.eclipse.releng.tools.replaceAllExisting")) {
            return;
        }
        ibmCopyright.setRevisionYear(lastMod);
        if (copyrightComment == null) {
            aSourceFile.insert(ibmCopyright.getCopyrightComment());
        } else {
            if (!copyrightComment.atTop() && aSourceFile.getFileType() != 7) {
                this.warn(file, copyrightComment, Messages.getString("AdvancedFixCopyrightAction.19"));
            }
            aSourceFile.replace(copyrightComment, ibmCopyright.getCopyrightComment());
        }
    }

    private boolean checkFileExtension(IFile file) {
        if (file.getFileExtension() == null) {
            this.warn(file, null, Messages.getString("AdvancedFixCopyrightAction.13"));
            return false;
        }
        return true;
    }

    private boolean checkSourceCreatedOk(SourceFile sourceFile, IFile file) {
        if (sourceFile == null) {
            this.warn(file, null, Messages.getString("AdvancedFixCopyrightAction.20"));
            return false;
        }
        return true;
    }

    private boolean checkUserFileIgnoreSettings(IPreferenceStore prefStore, SourceFile aSourceFile) {
        if (aSourceFile.getFileType() == 2 && prefStore.getBoolean("org.eclipse.releng.tools.ignoreProperties")) {
            return false;
        }
        return aSourceFile.getFileType() != 7 || !prefStore.getBoolean("org.eclipse.releng.tools.ignoreXml");
    }

    private boolean checkMultipleCopyright(IFile file, SourceFile aSourceFile) {
        if (aSourceFile.hasMultipleCopyrights()) {
            this.warn(file, null, Messages.getString("AdvancedFixCopyrightAction.14"));
            return false;
        }
        return true;
    }

    private void warn(IFile file, BlockComment firstBlockComment, String errorDescription) {
        List<String> aList = this.log.get(errorDescription);
        if (aList == null) {
            aList = new ArrayList<String>();
            this.log.put(errorDescription, aList);
        }
        aList.add(file.getFullPath().toString());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    private class FileCountVisitor
    implements IResourceVisitor {
        private int fileCount = 0;

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                ++this.fileCount;
            }
            return true;
        }

        public int getfileCount() {
            return this.fileCount;
        }
    }

    final class FixConsole
    extends MessageConsole {
        private FixConsole() {
            super(Messages.getString("AdvancedFixCopyrightAction.0"), null);
        }
    }

    public class FixCopyrightVisitor
    implements IResourceVisitor {
        private final IProgressMonitor monitor;
        private final RepositoryProviderCopyrightAdapter adapter;

        public FixCopyrightVisitor(RepositoryProviderCopyrightAdapter adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (!this.monitor.isCanceled() && resource.getType() == 1) {
                this.monitor.subTask(((IFile)resource).getFullPath().toOSString());
                AdvancedFixCopyrightAction.this.processFile((IFile)resource, this.adapter, this.monitor);
                this.monitor.worked(1);
            }
            return true;
        }
    }
}

