/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.releng.internal.tools.pomversion.PomVersionErrorReporter;
import org.eclipse.releng.tools.Messages;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RelEngPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.releng.tools";
    public static final String MAP_PROJECT_NAME = Messages.getString("RelEngPlugin.1");
    public static final String MAP_FOLDER = Messages.getString("RelEngPlugin.2");
    private static final String BINARY_REPOSITORY_PROVIDER_CLASS_NAME = "org.eclipse.pde.internal.core.BinaryRepositoryProvider";
    private PomVersionErrorReporter fPomReporter = new PomVersionErrorReporter();
    private static RelEngPlugin plugin;
    private ResourceBundle resourceBundle;

    public RelEngPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(ID + Messages.getString("RelEngPlugin.3"));
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(ID);
        if (node != null) {
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fPomReporter);
            String severity = this.getPreferenceStore().getString("org.eclipse.releng.tools.invalidPomVersionErrorLevel");
            if (!"Ignore".equals(severity)) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fPomReporter, 16);
                int workspaceValidated = node.getInt("org.eclipse.releng.tools.workspaceValidated", 0);
                if (workspaceValidated < 1) {
                    new WorkspaceJob(Messages.getString("RelEngPlugin.0")){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            RelEngPlugin.this.fPomReporter.validateWorkspace();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(ID);
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fPomReporter);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fPomReporter);
        }
        super.stop(context);
    }

    public static RelEngPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = RelEngPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(CoreException e) {
        RelEngPlugin.log(e.getStatus().getSeverity(), e.getMessage(), (Throwable)e);
    }

    public static void log(int severity, String message, Throwable e) {
        RelEngPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(Throwable e) {
        RelEngPlugin.log((IStatus)new Status(4, ID, 0, e.getMessage(), e));
    }

    public static void log(IStatus status) {
        RelEngPlugin.getPlugin().getLog().log(status);
    }

    public static RelEngPlugin getPlugin() {
        while (plugin == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return plugin;
    }

    static boolean isShared(IProject project) {
        Assert.isLegal((project != null ? 1 : 0) != 0);
        if (!RepositoryProvider.isShared((IProject)project)) {
            return false;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        return provider != null && !BINARY_REPOSITORY_PROVIDER_CLASS_NAME.equals(provider.getClass().getName());
    }
}

