/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.releng.tools.SourceFile;

public class ShellMakeFile
extends SourceFile {
    private static Pattern p = Pattern.compile("\\s*#\\s*\\W{2,}\\s*");

    public ShellMakeFile(IFile file) {
        super(file);
    }

    @Override
    public boolean isCommentStart(String aLine) {
        return p.matcher(aLine).matches();
    }

    @Override
    public boolean isCommentEnd(String aLine, String commentStartString) {
        String s = commentStartString.trim();
        s = s.substring(s.length() - 2);
        return aLine.trim().endsWith(s);
    }

    @Override
    public String getCommentStart() {
        return "#*";
    }

    @Override
    public String getCommentEnd() {
        return "**";
    }

    @Override
    public int getFileType() {
        return 4;
    }

    @Override
    protected void doInsert(String comment, IDocument document) throws BadLocationException, IOException {
        int insertOffset = this.findInsertOffset(document);
        document.replace(insertOffset, 0, comment);
    }

    private int findInsertOffset(IDocument document) throws BadLocationException {
        boolean inInstruction = false;
        int insertOffset = 0;
        int offset = 0;
        while (offset < document.getLength()) {
            char c2;
            char c = document.getChar(offset);
            char c3 = c2 = offset + 1 < document.getLength() ? document.getChar(offset + 1) : (char)'\u0000';
            if (inInstruction) {
                if (c == '\n' && c2 == '\r' || c == '\r' && c2 == '\n') {
                    insertOffset = offset + 2;
                    break;
                }
                if (c == '\n') {
                    insertOffset = offset + 1;
                    break;
                }
            } else {
                if (c != '#' || c2 != '!') break;
                inInstruction = true;
                ++offset;
            }
            ++offset;
        }
        return insertOffset;
    }
}

