/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.tests.ResourceHelper;
import org.eclipse.search.tests.SearchTestPlugin;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.IWorkbenchPage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class FileSearchTests {
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();
    private IProject fProject;

    @Before
    public void setUp() throws Exception {
        this.fProject = ResourceHelper.createProject("my-project");
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject("my-project");
    }

    @Test
    public void testSimpleFilesSerial() throws Exception {
        this.testSimpleFiles(new SerialTestResultCollector());
    }

    @Test
    public void testSimpleFilesParallel() throws Exception {
        this.testSimpleFiles(new ParallelTestResultCollector());
    }

    private void testSimpleFiles(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("File1\n");
        buf.append("hello\n");
        buf.append("more hello\n");
        buf.append("world\n");
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        IFile file1 = ResourceHelper.createFile(folder, "file1", buf.toString());
        IFile file2 = ResourceHelper.createFile(folder, "file2", buf.toString());
        Pattern searchPattern = PatternConstructor.createPattern((String)"hello", (boolean)false, (boolean)true);
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, null, (boolean)false);
        TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        TestResult[] results = collector.getResults();
        Assert.assertEquals((String)"Number of total results", (long)4L, (long)results.length);
        this.assertMatches(results, 2, file1, buf.toString(), "hello");
        this.assertMatches(results, 2, file2, buf.toString(), "hello");
    }

    @Test
    public void testWildCards1Serial() throws Exception {
        this.testWildCards1(new SerialTestResultCollector());
    }

    @Test
    public void testWildCards1Parallel() throws Exception {
        this.testWildCards1(new ParallelTestResultCollector());
    }

    private void testWildCards1(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("File1\n");
        buf.append("no more\n");
        buf.append("mornings\n");
        buf.append("more hello\n");
        buf.append("world\n");
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        ResourceHelper.createFile(folder, "file1", buf.toString());
        ResourceHelper.createFile(folder, "file2", buf.toString());
        Pattern searchPattern = PatternConstructor.createPattern((String)"mor*", (boolean)false, (boolean)false);
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, null, (boolean)false);
        TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        TestResult[] results = collector.getResults();
        Assert.assertEquals((String)"Number of total results", (long)6L, (long)results.length);
    }

    @Test
    public void testWildCards2Serial() throws Exception {
        this.testWildCards2(new SerialTestResultCollector());
    }

    @Test
    public void testWildCards2Parallel() throws Exception {
        this.testWildCards2(new ParallelTestResultCollector());
    }

    private void testWildCards2(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("File1\n");
        buf.append("no more\n");
        buf.append("mornings\n");
        buf.append("more hello\n");
        buf.append("world\n");
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        ResourceHelper.createFile(folder, "file1", buf.toString());
        ResourceHelper.createFile(folder, "file2", buf.toString());
        Pattern searchPattern = PatternConstructor.createPattern((String)"mo?e", (boolean)false, (boolean)false);
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, null, (boolean)false);
        TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        TestResult[] results = collector.getResults();
        Assert.assertEquals((String)"Number of total results", (long)4L, (long)results.length);
    }

    @Test
    public void testWildCards3Serial() throws Exception {
        this.testWildCards3(new SerialTestResultCollector());
    }

    @Test
    public void testWildCards3Parallel() throws Exception {
        this.testWildCards3(new ParallelTestResultCollector());
    }

    private void testWildCards3(TestResultCollector collector) throws Exception {
        IProject project = fgJUnitSource.getStandardProject();
        IFile openFile1 = (IFile)project.findMember("junit/framework/TestCase.java");
        IFile openFile2 = (IFile)project.findMember("junit/extensions/ExceptionTestCase.java");
        IFile openFile3 = (IFile)project.findMember("junit/framework/Assert.java");
        IFile openFile4 = (IFile)project.findMember("junit/samples/money/MoneyTest.java");
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        try {
            SearchTestPlugin.openTextEditor(activePage, openFile1);
            SearchTestPlugin.openTextEditor(activePage, openFile2);
            SearchTestPlugin.openTextEditor(activePage, openFile3);
            SearchTestPlugin.openTextEditor(activePage, openFile4);
            long start = System.currentTimeMillis();
            Pattern searchPattern = PatternConstructor.createPattern((String)"\\w*\\(\\)", (boolean)false, (boolean)true);
            FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, null, (boolean)false);
            TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
            TestResult[] results = collector.getResults();
            Assert.assertEquals((String)"Number of total results", (long)748L, (long)results.length);
            long end = System.currentTimeMillis();
            System.out.println("time= " + (end - start));
        }
        finally {
            activePage.closeAllEditors(false);
        }
    }

    @Test
    public void testWholeWordSerial() throws Exception {
        this.testWholeWord(new SerialTestResultCollector());
    }

    @Test
    public void testWholeWordParallel() throws Exception {
        this.testWholeWord(new ParallelTestResultCollector());
    }

    private void testWholeWord(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("hell\n");
        buf.append("hill\n");
        buf.append("$hell\n");
        buf.append("shell\n");
        buf.append("hell.freeze()\n");
        buf.append("freeze(hell)\n");
        buf.append("shell-script\n");
        buf.append("hello\n");
        buf.append("world.hello()\n");
        buf.append("shilling\n");
        buf.append("holler\n");
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        ResourceHelper.createFile(folder, "file1", buf.toString());
        ResourceHelper.createFile(folder, "file2", buf.toString());
        TextSearchEngine engine = TextSearchEngine.create();
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, null, (boolean)false);
        Pattern searchPattern = PatternConstructor.createPattern((String)"h?ll", (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        collector.reset();
        engine.search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((String)"Number of partial-word results", (long)22L, (long)collector.getNumberOfResults());
        searchPattern = PatternConstructor.createPattern((String)"h?ll", (boolean)false, (boolean)true, (boolean)false, (boolean)true);
        collector.reset();
        engine.search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((String)"Number of whole-word results", (long)10L, (long)collector.getNumberOfResults());
        searchPattern = PatternConstructor.createPattern((String)"h[eio]ll", (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        collector.reset();
        engine.search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((String)"Number of partial-word results", (long)22L, (long)collector.getNumberOfResults());
    }

    @Test
    public void testFileOpenInEditorSerial() throws Exception {
        this.testFileOpenInEditor(new SerialTestResultCollector());
    }

    @Test
    public void testFileOpenInEditorParallel() throws Exception {
        this.testFileOpenInEditor(new ParallelTestResultCollector());
    }

    private void testFileOpenInEditor(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("File1\n");
        buf.append("hello\n");
        buf.append("more hello\n");
        buf.append("world\n");
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        IFile file1 = ResourceHelper.createFile(folder, "file1", buf.toString());
        IFile file2 = ResourceHelper.createFile(folder, "file2", buf.toString());
        try {
            SearchTestPlugin.openTextEditor(SearchPlugin.getActivePage(), file2);
            Pattern searchPattern = PatternConstructor.createPattern((String)"hello", (boolean)false, (boolean)true);
            FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, null, (boolean)false);
            TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
            TestResult[] results = collector.getResults();
            Assert.assertEquals((String)"Number of total results", (long)4L, (long)results.length);
            this.assertMatches(results, 2, file1, buf.toString(), "hello");
            this.assertMatches(results, 2, file2, buf.toString(), "hello");
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    @Test
    public void testDerivedFilesSerial() throws Exception {
        this.testDerivedFiles(new SerialTestResultCollector());
    }

    @Test
    public void testDerivedFilesParallel() throws Exception {
        this.testDerivedFiles(new ParallelTestResultCollector());
    }

    private void testDerivedFiles(TestResultCollector collector) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("hello\n");
        IFolder folder1 = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        ResourceHelper.createFile(folder1, "file1", buf.toString());
        IFile file2 = ResourceHelper.createFile(folder1, "file2", buf.toString());
        file2.setDerived(true, null);
        IFolder folder2 = ResourceHelper.createFolder(folder1.getFolder("folder2"));
        folder2.setDerived(true, null);
        ResourceHelper.createFile(folder2, "file3", buf.toString());
        IFolder folder3 = ResourceHelper.createFolder(folder2.getFolder("folder3"));
        ResourceHelper.createFile(folder3, "file4", buf.toString());
        IFolder folder4 = ResourceHelper.createFolder(folder1.getFolder("folder4"));
        ResourceHelper.createFile(folder4, "file5", buf.toString());
        Pattern searchPattern = PatternConstructor.createPattern((String)"hello", (boolean)false, (boolean)true);
        Pattern fileNamePattern = PatternConstructor.createPattern((String)"*", (boolean)false, (boolean)false);
        TextSearchEngine engine = TextSearchEngine.create();
        TextSearchScope scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, (Pattern)fileNamePattern, (boolean)true);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)5L, (long)collector.getNumberOfResults());
        scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, (Pattern)fileNamePattern, (boolean)false);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)2L, (long)collector.getNumberOfResults());
        scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{folder2}, (Pattern)fileNamePattern, (boolean)true);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)2L, (long)collector.getNumberOfResults());
        scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{folder2}, (Pattern)fileNamePattern, (boolean)false);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)0L, (long)collector.getNumberOfResults());
        scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{folder3}, (Pattern)fileNamePattern, (boolean)true);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)1L, (long)collector.getNumberOfResults());
        scope = TextSearchScope.newSearchScope((IResource[])new IResource[]{folder3}, (Pattern)fileNamePattern, (boolean)false);
        collector.reset();
        engine.search(scope, (TextSearchRequestor)collector, searchPattern, null);
        Assert.assertEquals((long)0L, (long)collector.getNumberOfResults());
    }

    @Test
    public void testFileNamePatternsSerial() throws Exception {
        this.testFileNamePatterns(new SerialTestResultCollector());
    }

    @Test
    public void testFileNamePatternsParallel() throws Exception {
        this.testFileNamePatterns(new ParallelTestResultCollector());
    }

    private void testFileNamePatterns(TestResultCollector collector) throws Exception {
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        ResourceHelper.createFile(folder, "file1.x", "Test");
        ResourceHelper.createFile(folder, "file2.x", "Test");
        ResourceHelper.createFile(folder, "file2.y", "Test");
        ResourceHelper.createFile(folder, "file2.z", "Test");
        Pattern searchPattern = PatternConstructor.createPattern((String)"Test", (boolean)false, (boolean)false);
        String[] fileNamePatterns = new String[]{"*"};
        TestResult[] results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)4L, (long)results.length);
        fileNamePatterns = new String[]{"*.x"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)2L, (long)results.length);
        fileNamePatterns = new String[]{"*.x", "*.y*"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)3L, (long)results.length);
        fileNamePatterns = new String[]{"!*.x"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)2L, (long)results.length);
        fileNamePatterns = new String[]{"!*.x", "!*.y"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)1L, (long)results.length);
        fileNamePatterns = new String[]{"*", "!*.y"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)3L, (long)results.length);
        fileNamePatterns = new String[]{"*", "!*.*"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)0L, (long)results.length);
        fileNamePatterns = new String[]{"*.x", "*.y*", "!*.y"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)2L, (long)results.length);
        fileNamePatterns = new String[]{"file*", "!*.x*", "!*.y"};
        results = this.performSearch(collector, fileNamePatterns, searchPattern);
        Assert.assertEquals((String)"Number of total results", (long)1L, (long)results.length);
    }

    private TestResult[] performSearch(TestResultCollector collector, String[] fileNamePatterns, Pattern searchPattern) {
        collector.reset();
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, (String[])fileNamePatterns, (boolean)false);
        TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, null);
        return collector.getResults();
    }

    private void assertMatches(TestResult[] results, int expectedCount, IFile file, String fileContent, String string) {
        int k = 0;
        int i = 0;
        while (i < results.length) {
            TestResult curr = results[i];
            if (file.equals((Object)curr.resource)) {
                ++k;
                Assert.assertEquals((String)"Wrong positions", (Object)string, (Object)fileContent.substring(curr.offset, curr.offset + curr.length));
            }
            ++i;
        }
        Assert.assertEquals((String)"Number of results in file", (long)expectedCount, (long)k);
    }

    private static class ParallelTestResultCollector
    extends TestResultCollector {
        private ParallelTestResultCollector() {
        }

        public boolean canRunInParallel() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acceptPatternMatch(TextSearchMatchAccess match) throws CoreException {
            List list = this.fResult;
            synchronized (list) {
                this.fResult.add(new TestResult((IResource)match.getFile(), match.getMatchOffset(), match.getMatchLength()));
            }
            return true;
        }
    }

    private static class SerialTestResultCollector
    extends TestResultCollector {
        private SerialTestResultCollector() {
        }

        public boolean canRunInParallel() {
            return false;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess match) throws CoreException {
            this.fResult.add(new TestResult((IResource)match.getFile(), match.getMatchOffset(), match.getMatchLength()));
            return true;
        }
    }

    private static class TestResult {
        public IResource resource;
        public int offset;
        public int length;

        public TestResult(IResource resource, int offset, int length) {
            this.resource = resource;
            this.offset = offset;
            this.length = length;
        }
    }

    private static class TestResultCollector
    extends TextSearchRequestor {
        protected List<TestResult> fResult;

        public TestResultCollector() {
            this.reset();
        }

        public TestResult[] getResults() {
            return this.fResult.toArray(new TestResult[this.fResult.size()]);
        }

        public int getNumberOfResults() {
            return this.fResult.size();
        }

        public void reset() {
            this.fResult = new ArrayList<TestResult>();
        }
    }
}

