/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.tests.SearchTestPlugin;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.tests.filesearch.LineBasedFileSearch;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class LineAnnotationManagerTest {
    private LineBasedFileSearch fLineQuery;
    private AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        EditorAnnotationManager.debugSetHighlighterType((int)2);
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fLineQuery = new LineBasedFileSearch(scope, false, true, "Test");
    }

    @After
    public void tearDown() throws Exception {
        InternalSearchUI.getInstance().removeAllQueries();
        this.fLineQuery = null;
        EditorAnnotationManager.debugSetHighlighterType((int)0);
    }

    @Test
    public void testLineBasedQuery() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fLineQuery);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fLineQuery.getSearchResult();
        Object[] files = result.getElements();
        try {
            int i = 0;
            while (i < files.length) {
                IFile file = (IFile)files[0];
                ITextEditor editor = (ITextEditor)SearchTestPlugin.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                annotationModel.getAnnotationIterator();
                ArrayList<Position> positions = new ArrayList<Position>();
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    positions.add(annotationModel.getPosition(annotation));
                }
                Match[] matches = result.getMatches((Object)file);
                int j = 0;
                while (j < matches.length) {
                    Position position = this.computeDocumentPositionFromLineMatch(document, matches[j]);
                    Assert.assertTrue((String)("position not found at: " + j), (boolean)positions.remove(position));
                    ++j;
                }
                Assert.assertEquals((long)0L, (long)positions.size());
                ++i;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    private Position computeDocumentPositionFromLineMatch(IDocument document, Match match) throws BadLocationException {
        Position p = new Position(match.getOffset(), match.getLength());
        return PositionTracker.convertToCharacterPosition((Position)p, (IDocument)document);
    }
}

