/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.ArrayList;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class SortingTest {
    FileSearchQuery fQuery1;
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
    }

    @Test
    public void testSorted() throws Exception {
        int j;
        Match[] matches;
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        int originalMatchCount = result.getMatchCount();
        ArrayList<Match> allMatches = new ArrayList<Match>(originalMatchCount);
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            matches = result.getMatches(elements[i]);
            j = 0;
            while (j < matches.length) {
                allMatches.add(matches[j]);
                ++j;
            }
            ++i;
        }
        result.removeAll();
        Assert.assertTrue((String)"removed all matches", (result.getMatchCount() == 0 ? 1 : 0) != 0);
        i = allMatches.size() - 1;
        while (i >= 0) {
            result.addMatch((Match)allMatches.get(i));
            --i;
        }
        Assert.assertEquals((String)"Test that all matches have been added again", (long)result.getMatchCount(), (long)originalMatchCount);
        i = 0;
        while (i < elements.length) {
            matches = result.getMatches(elements[i]);
            Assert.assertTrue((String)"has matches", (matches.length > 0 ? 1 : 0) != 0);
            j = 1;
            while (j < matches.length) {
                Assert.assertTrue((String)"order problem", (boolean)this.isLessOrEqual(matches[j - 1], matches[j]));
                ++j;
            }
            ++i;
        }
    }

    private boolean isLessOrEqual(Match match, Match match2) {
        int diff = match2.getOffset() - match.getOffset();
        if (diff > 0) {
            return true;
        }
        if (diff < 0) {
            return false;
        }
        diff = match2.getLength() - match.getLength();
        return diff >= 0;
    }
}

