/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.ole.win32;

import java.io.File;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class OLEExample {
    OleClientSite clientSite;
    OleFrame oleFrame;
    Button closeButton;
    boolean createClientSite = true;

    public static void main(String[] args) {
        Display display = new Display();
        OLEExample example = new OLEExample();
        example.open(display);
        display.dispose();
    }

    void addFileMenu(OleFrame frame) {
        Shell shell = frame.getShell();
        Menu menuBar = shell.getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)shell, 2);
            shell.setMenuBar(menuBar);
        }
        MenuItem fileMenu = new MenuItem(menuBar, 64);
        fileMenu.setText("&File");
        Menu menuFile = new Menu(fileMenu);
        fileMenu.setMenu(menuFile);
        frame.setFileMenus(new MenuItem[]{fileMenu});
        MenuItem menuFileExit = new MenuItem(menuFile, 64);
        menuFileExit.setText("Exit");
        menuFileExit.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> shell.dispose()));
    }

    OleClientSite createSite(OleFrame frame, String progID) {
        if (this.createClientSite) {
            return new OleClientSite((Composite)frame, 0, progID);
        }
        return new OleControlSite((Composite)frame, 0, progID);
    }

    OleClientSite createSite(OleFrame frame, String progID, File file) {
        if (this.createClientSite) {
            return new OleClientSite((Composite)frame, 0, progID, file);
        }
        return new OleControlSite((Composite)frame, 0, progID, file);
    }

    void disposeClient() {
        if (this.clientSite != null) {
            this.clientSite.dispose();
        }
        this.clientSite = null;
    }

    void fileOpen() {
        String fileExtension;
        int index;
        Shell shell = this.oleFrame.getShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        this.disposeClient();
        if (this.clientSite == null && (index = fileName.lastIndexOf(46)) != -1 && ((fileExtension = fileName.substring(index + 1)).equalsIgnoreCase("doc") || fileExtension.equalsIgnoreCase("rtf") || fileExtension.equalsIgnoreCase("txt"))) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "Word.Document", new File(fileName));
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite == null && (index = fileName.lastIndexOf(46)) != -1 && (fileExtension = fileName.substring(index + 1)).equalsIgnoreCase("xls")) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "Excel.Sheet", new File(fileName));
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite == null && (index = fileName.lastIndexOf(46)) != -1 && (fileExtension = fileName.substring(index + 1)).equalsIgnoreCase("mpa")) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "MPlayer", new File(fileName));
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite == null && (index = fileName.lastIndexOf(46)) != -1 && ((fileExtension = fileName.substring(index + 1)).equalsIgnoreCase("wmv") || fileExtension.equalsIgnoreCase("mpg") || fileExtension.equalsIgnoreCase("mpeg") || fileExtension.equalsIgnoreCase("avi") || fileExtension.equalsIgnoreCase("asf") || fileExtension.equalsIgnoreCase("wav"))) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "WMPlayer.OCX");
                OleAutomation player = new OleAutomation(this.clientSite);
                int[] playURL = player.getIDsOfNames(new String[]{"URL"});
                if (playURL != null) {
                    boolean suceeded = player.setProperty(playURL[0], new Variant(fileName));
                    if (!suceeded) {
                        this.disposeClient();
                    }
                } else {
                    this.disposeClient();
                }
                player.dispose();
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite == null && (index = fileName.lastIndexOf(46)) != -1 && (fileExtension = fileName.substring(index + 1)).equalsIgnoreCase("pdf")) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "PDF.PdfCtrl.5");
                this.clientSite.doVerb(-5);
                OleAutomation pdf = new OleAutomation(this.clientSite);
                int[] loadFile = pdf.getIDsOfNames(new String[]{"LoadFile"});
                if (loadFile != null) {
                    Variant result = pdf.invoke(loadFile[0], new Variant[]{new Variant(fileName)});
                    if (result == null) {
                        this.disposeClient();
                    } else {
                        result.dispose();
                    }
                } else {
                    this.disposeClient();
                }
                pdf.dispose();
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite == null) {
            try {
                this.clientSite = this.createSite(this.oleFrame, "Shell.Explorer");
                OleAutomation explorer = new OleAutomation(this.clientSite);
                int[] navigate = explorer.getIDsOfNames(new String[]{"Navigate"});
                if (navigate != null) {
                    Variant result = explorer.invoke(navigate[0], new Variant[]{new Variant(fileName)});
                    if (result == null) {
                        this.disposeClient();
                    } else {
                        result.dispose();
                    }
                } else {
                    this.disposeClient();
                }
                explorer.dispose();
            }
            catch (SWTException sWTException) {
                this.disposeClient();
            }
        }
        if (this.clientSite != null) {
            this.clientSite.doVerb(-5);
        }
    }

    void newClientSite(String progID) {
        this.disposeClient();
        try {
            this.clientSite = this.createSite(this.oleFrame, progID);
        }
        catch (SWTException sWTException) {}
        if (this.clientSite != null) {
            this.clientSite.doVerb(-5);
        }
    }

    public void open(Display display) {
        Shell shell = new Shell(display);
        shell.setText("OLE Example");
        shell.setLayout((Layout)new FillLayout());
        Composite parent = new Composite((Composite)shell, 0);
        parent.setLayout((Layout)new GridLayout(4, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1, 4, false, false);
        buttons.setLayoutData((Object)gridData);
        Composite displayArea = new Composite(parent, 2048);
        displayArea.setLayout((Layout)new FillLayout());
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Button excelButton = new Button(buttons, 16);
        excelButton.setText("New Excel Sheet");
        excelButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.newClientSite("Excel.Sheet");
            }
        }));
        Button mediaPlayerButton = new Button(buttons, 16);
        mediaPlayerButton.setText("New MPlayer");
        mediaPlayerButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.newClientSite("MPlayer");
            }
        }));
        Button powerPointButton = new Button(buttons, 16);
        powerPointButton.setText("New PowerPoint Slide");
        powerPointButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.newClientSite("PowerPoint.Slide");
            }
        }));
        Button wordButton = new Button(buttons, 16);
        wordButton.setText("New Word Document");
        wordButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.newClientSite("Word.Document");
            }
        }));
        new Label(buttons, 0);
        Button openButton = new Button(buttons, 16);
        openButton.setText("Open file...");
        openButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.fileOpen();
            }
        }));
        new Label(buttons, 0);
        this.closeButton = new Button(buttons, 16);
        this.closeButton.setText("Close file");
        this.closeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (((Button)e.widget).getSelection()) {
                this.disposeClient();
            }
        }));
        this.closeButton.setSelection(true);
        this.oleFrame = new OleFrame(displayArea, 0);
        this.addFileMenu(this.oleFrame);
        shell.setSize(800, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

