/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.Tool;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class PaintView
extends ViewPart {
    PaintExample instance = null;

    public void createPartControl(Composite parent) {
        this.instance = new PaintExample(parent);
        this.instance.createGUI(parent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        Tool[] tools = PaintExample.tools;
        String group = tools[0].group;
        toolbarManager.add((IContributionItem)new GroupMarker(group));
        int i = 0;
        while (i < tools.length) {
            Tool tool = tools[i];
            if (!tool.group.equals(group)) {
                toolbarManager.add((IContributionItem)new Separator());
                toolbarManager.add((IContributionItem)new GroupMarker(tool.group));
            }
            group = tool.group;
            PaintAction action = new PaintAction(tool);
            toolbarManager.appendToGroup(group, (IAction)action);
            if (i == 0 || i == 8 || i == 11) {
                action.setChecked(true);
            }
            ++i;
        }
        actionBars.updateActionBars();
        this.instance.setDefaults();
    }

    public void dispose() {
        this.instance.dispose();
        this.instance = null;
        super.dispose();
    }

    public Display getDisplay() {
        return this.instance.getDisplay();
    }

    public void setFocus() {
        this.instance.setFocus();
    }

    class PaintAction
    extends Action {
        private int style;
        private Runnable action;

        public PaintAction(Tool tool) {
            String id = String.valueOf(tool.group) + '.' + tool.name;
            this.setId(id);
            this.style = tool.type == 16 ? 8 : 1;
            this.action = tool.action;
            this.setText(PaintExample.getResourceString((String)(String.valueOf(id) + ".label")));
            this.setToolTipText(PaintExample.getResourceString((String)(String.valueOf(id) + ".tooltip")));
            this.setDescription(PaintExample.getResourceString((String)(String.valueOf(id) + ".description")));
            this.setImageDescriptor(ImageDescriptor.createFromFile(PaintExample.class, (String)PaintExample.getResourceString((String)(String.valueOf(id) + ".image"))));
        }

        public int getStyle() {
            return this.style;
        }

        public void run() {
            this.action.run();
        }
    }
}

