/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.accessibility.CTable;
import org.eclipse.swt.examples.accessibility.CTableColumn;
import org.eclipse.swt.examples.accessibility.CTableItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AccessibleTableExample {
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_accessibility");
    static CTable table1;
    static final String[] itemText;

    static {
        itemText = new String[]{AccessibleTableExample.getResourceString("color1"), AccessibleTableExample.getResourceString("color2"), AccessibleTableExample.getResourceString("color3"), AccessibleTableExample.getResourceString("color4"), AccessibleTableExample.getResourceString("color5")};
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("Accessible Table Example");
        Group group = new Group((Composite)shell, 0);
        group.setText("Tables With Accessible Cell Children");
        group.setLayout((Layout)new GridLayout());
        new Label((Composite)group, 0).setText("CTable with column headers");
        table1 = new CTable((Composite)group, 67586);
        table1.setLayoutData(new GridData(4, 4, true, true));
        table1.setHeaderVisible(true);
        table1.setLinesVisible(true);
        int col = 0;
        while (col < 3) {
            CTableColumn column = new CTableColumn(table1, 0);
            column.setText("Col " + col);
            column.setWidth(50);
            ++col;
        }
        int row = 0;
        while (row < 4) {
            CTableItem item = new CTableItem(table1, 0);
            item.setText(new String[]{"C0R" + row, "C1R" + row, "C2R" + row});
            ++row;
        }
        Composite btnGroup = new Composite((Composite)group, 0);
        btnGroup.setLayout((Layout)new FillLayout(512));
        Button btn = new Button(btnGroup, 8);
        btn.setText("Add rows");
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int currSize = table1.getItemCount();
            int colCount = table1.getColumnCount();
            CTableItem item = new CTableItem(table1, 0);
            String[] cells = new String[colCount];
            int i = 0;
            while (i < colCount) {
                cells[i] = "C" + i + "R" + currSize;
                ++i;
            }
            item.setText(cells);
        }));
        btn = new Button(btnGroup, 8);
        btn.setText("Remove rows");
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int currSize = table1.getItemCount();
            if (currSize > 0) {
                table1.remove(currSize - 1);
            }
        }));
        btn = new Button(btnGroup, 8);
        btn.setText("Remove selected rows");
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            CTableItem[] selectedItems;
            CTableItem[] cTableItemArray = selectedItems = table1.getSelection();
            int n = selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTableItem selectedItem = cTableItemArray[n2];
                selectedItem.dispose();
                ++n2;
            }
        }));
        btn = new Button(btnGroup, 8);
        btn.setText("Add column");
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int currSize = table1.getColumnCount();
            CTableColumn item = new CTableColumn(table1, 0);
            item.setText("Col " + currSize);
            item.setWidth(50);
        }));
        btn = new Button(btnGroup, 8);
        btn.setText("Remove last column");
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int colCount = table1.getColumnCount();
            if (colCount > 0) {
                CTableColumn column = table1.getColumn(colCount - 1);
                column.dispose();
            }
        }));
        new Label((Composite)group, 0).setText("CTable used as a list");
        CTable table2 = new CTable((Composite)group, 67586);
        table2.setLayoutData(new GridData(4, 4, true, true));
        table2.setLinesVisible(true);
        String[] stringArray = itemText;
        int n = itemText.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            CTableItem item = new CTableItem(table2, 0);
            item.setText(element);
            ++n2;
        }
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

