/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.accessibility.CTable;
import org.eclipse.swt.examples.accessibility.CTableItem;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTableColumn
extends Item {
    CTable parent;
    int style;
    String displayText = "";
    int width;
    boolean moveable;
    boolean resizable = true;
    int sort = 0;
    String toolTipText;
    Accessible accessible;

    public CTableColumn(CTable parent, int style) {
        this(parent, style, CTableColumn.checkNull((CTable)parent).columns.length);
    }

    public CTableColumn(CTable parent, int style, int index) {
        super((Widget)parent, CTableColumn.checkStyle(style), index);
        if (index < 0 || index > parent.columns.length) {
            SWT.error((int)6);
        }
        this.parent = parent;
        this.style = super.getStyle();
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(11, (Listener)typedListener);
        this.addListener(10, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    static CTable checkNull(CTable table) {
        if (table == null) {
            SWT.error((int)4);
        }
        return table;
    }

    static int checkStyle(int style) {
        return CTable.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    /*
     * Unable to fully structure code
     */
    void computeDisplayText(GC gc) {
        availableWidth = this.width - 2 * this.parent.getHeaderPadding();
        if (super.getImage() != null) {
            availableWidth -= super.getImage().getBounds().width;
            availableWidth -= 3;
        }
        if (this.sort != 0) {
            availableWidth -= this.parent.arrowBounds.width;
            availableWidth -= 3;
        }
        text = super.getText();
        textWidth = gc.textExtent((String)text, (int)8).x;
        if (textWidth <= availableWidth) {
            this.displayText = text;
            return;
        }
        ellipsisWidth = gc.stringExtent((String)"...").x;
        if ((availableWidth -= ellipsisWidth) <= 0) {
            this.displayText = "...";
            return;
        }
        index = (int)Math.min((double)availableWidth / gc.getFontMetrics().getAverageCharacterWidth(), (double)text.length());
        textWidth = gc.textExtent((String)text.substring((int)0, (int)index), (int)8).x;
        if (availableWidth == textWidth) {
            this.displayText = String.valueOf(text.substring(0, index)) + "...";
            return;
        }
        if (availableWidth >= textWidth) ** GOTO lbl32
        do {
            if (--index < 0) {
                this.displayText = "...";
                return;
            }
            text = text.substring(0, index);
        } while (availableWidth < (textWidth = gc.textExtent((String)text, (int)8).x));
        this.displayText = String.valueOf(text) + "...";
        return;
lbl-1000:
        // 1 sources

        {
            textWidth = gc.textExtent((String)text.substring((int)0, (int)(++index)), (int)8).x;
lbl32:
            // 2 sources

            ** while (textWidth < availableWidth)
        }
lbl33:
        // 1 sources

        this.displayText = String.valueOf(text.substring(0, index - 1)) + "...";
    }

    public void dispose() {
        CTableColumn newColumn0;
        if (this.isDisposed()) {
            return;
        }
        Rectangle parentBounds = this.parent.clientArea;
        int x = this.getX();
        int index = this.getIndex();
        int orderIndex = this.getOrderIndex();
        int nextColumnAlignment = this.parent.columns.length > 1 ? this.parent.columns[1].getAlignment() : 16384;
        CTable parent = this.parent;
        this.dispose(true);
        int width = parentBounds.width - x;
        parent.redraw(x, 0, width, parentBounds.height, false);
        if (index == 0 && ((parent.getStyle() & 0x20) != 0 || nextColumnAlignment != 16384) && parent.columns.length > 0 && (newColumn0 = parent.columns[0]).getOrderIndex() < orderIndex) {
            int newColumn0x = newColumn0.getX();
            parent.redraw(newColumn0x, 0, newColumn0.width, parentBounds.height, false);
            if (nextColumnAlignment != 16384 && parent.getHeaderVisible() && parent.drawCount <= 0) {
                parent.header.redraw(newColumn0x, 0, newColumn0.width, parent.header.getClientArea().height, false);
            }
        }
        if (parent.drawCount <= 0 && parent.getHeaderVisible()) {
            parent.header.redraw(x, 0, width, parent.getHeaderHeight(), false);
        }
    }

    void dispose(boolean notifyParent) {
        super.dispose();
        if (notifyParent) {
            this.parent.destroyItem(this);
        }
        if (this.accessible != null) {
            this.accessible.dispose();
            this.accessible = null;
        }
        this.parent = null;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.getStyle() & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.getStyle() & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    int getContentWidth(GC gc, boolean useDisplayText) {
        String text;
        int contentWidth = 0;
        String string = text = useDisplayText ? this.displayText : super.getText();
        if (text.length() > 0) {
            contentWidth += gc.textExtent((String)text, (int)8).x;
        }
        if (super.getImage() != null) {
            contentWidth += super.getImage().getBounds().width;
            if (text.length() > 0) {
                contentWidth += 3;
            }
        }
        if (this.sort != 0) {
            contentWidth += this.parent.arrowBounds.width;
            if (text.length() > 0 || super.getImage() != null) {
                contentWidth += 3;
            }
        }
        return contentWidth;
    }

    int getIndex() {
        CTableColumn[] columns = this.parent.columns;
        int i = 0;
        while (i < columns.length) {
            if (columns[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    int getOrderIndex() {
        CTableColumn[] orderedColumns = this.parent.orderedColumns;
        if (orderedColumns == null) {
            return this.getIndex();
        }
        int i = 0;
        while (i < orderedColumns.length) {
            if (orderedColumns[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CTable getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        if (!this.parent.getHeaderVisible()) {
            return 0;
        }
        GC gc = new GC((Drawable)this.parent);
        int result = this.getContentWidth(gc, false);
        gc.dispose();
        return result + 2 * this.parent.getHeaderPadding();
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getX() {
        CTableColumn[] orderedColumns = this.parent.getOrderedColumns();
        int index = this.getOrderIndex();
        int result = -this.parent.horizontalOffset;
        int i = 0;
        while (i < index) {
            result += orderedColumns[i].width;
            ++i;
        }
        return result;
    }

    public void pack() {
        this.checkWidget();
        CTableItem[] items = this.parent.items;
        int index = this.getIndex();
        int newWidth = this.getPreferredWidth();
        int i = 0;
        while (i < this.parent.itemsCount) {
            int width = items[i].getPreferredWidth(index);
            if (this.parent.isDisposed() || this.isDisposed()) {
                return;
            }
            if (!items[i].isDisposed()) {
                newWidth = Math.max(newWidth, width);
            }
            ++i;
        }
        if (newWidth != this.width) {
            this.parent.updateColumnWidth(this, newWidth);
        }
    }

    void paint(GC gc) {
        int padding = this.parent.getHeaderPadding();
        int x = this.getX();
        int startX = x + padding;
        if ((this.getStyle() & 0x4000) == 0) {
            int contentWidth = this.getContentWidth(gc, true);
            startX = (this.getStyle() & 0x20000) != 0 ? Math.max(startX, x + this.width - padding - contentWidth) : Math.max(startX, x + (this.width - contentWidth) / 2);
        }
        int headerHeight = this.parent.getHeaderHeight();
        gc.setClipping(x + padding, padding, this.width - 2 * padding, headerHeight - 2 * padding);
        if (super.getImage() != null) {
            Rectangle imageBounds = super.getImage().getBounds();
            int drawHeight = Math.min(imageBounds.height, headerHeight - 2 * padding);
            gc.drawImage(super.getImage(), 0, 0, imageBounds.width, imageBounds.height, startX, (headerHeight - drawHeight) / 2, imageBounds.width, drawHeight);
            startX += imageBounds.width + 3;
        }
        if (this.displayText.length() > 0) {
            gc.setForeground(this.getParent().display.getSystemColor(2));
            int fontHeight = this.parent.fontHeight;
            gc.drawText(this.displayText, startX, (headerHeight - fontHeight) / 2, 8);
            startX += gc.textExtent((String)this.displayText, (int)8).x + 3;
        }
        if (this.sort != 0) {
            Image image = this.sort == 1024 ? this.parent.getArrowDownImage() : this.parent.getArrowUpImage();
            int y = (headerHeight - this.parent.arrowBounds.height) / 2;
            gc.drawImage(image, startX, y);
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(10, (SWTEventListener)listener);
        this.removeListener(11, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.getIndex();
        if (index == -1 || index == 0) {
            return;
        }
        alignment = CTable.checkBits(alignment, 16384, 0x1000000, 131072, 0, 0, 0);
        int style = this.getStyle();
        if ((style & alignment) != 0) {
            return;
        }
        style &= 0xFEFDBFFF;
        this.setStyle(style |= alignment);
        int x = this.getX();
        this.parent.redraw(x, 0, this.width, this.parent.clientArea.height, false);
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(x, 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public int getStyle() {
        int s = super.getStyle();
        return this.style | s;
    }

    void setStyle(int newStyle) {
        int s = super.getStyle();
        this.style |= s | newStyle;
    }

    public void setImage(Image value) {
        this.checkWidget();
        if (value == super.getImage()) {
            return;
        }
        if (value != null && value.equals((Object)super.getImage())) {
            return;
        }
        super.setImage(value);
        GC gc = new GC((Drawable)this.parent);
        this.computeDisplayText(gc);
        gc.dispose();
        if (this.parent.headerImageHeight == 0) {
            int oldHeaderHeight = this.parent.getHeaderHeight();
            this.parent.setHeaderImageHeight(value.getBounds().height);
            if (oldHeaderHeight != this.parent.getHeaderHeight()) {
                if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
                    this.parent.header.redraw();
                }
                this.parent.redraw();
                return;
            }
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public void setResizable(boolean value) {
        this.checkWidget();
        this.resizable = value;
    }

    void setSortDirection(int value) {
        if (value == this.sort) {
            return;
        }
        boolean widthChange = value == 0 || this.sort == 0;
        this.sort = value;
        if (widthChange) {
            GC gc = new GC((Drawable)this.parent);
            this.computeDisplayText(gc);
            gc.dispose();
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setText(String value) {
        this.checkWidget();
        if (value == null) {
            SWT.error((int)4);
        }
        if (value.equals(super.getText())) {
            return;
        }
        super.setText(value);
        GC gc = new GC((Drawable)this.parent);
        this.computeDisplayText(gc);
        gc.dispose();
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string) {
            return;
        }
        if (this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        this.toolTipText = string;
        if (this.parent.toolTipShell == null) {
            return;
        }
        if (((Integer)this.parent.toolTipShell.getData()).intValue() != this.getIndex()) {
            return;
        }
        this.parent.headerUpdateToolTip(this.getX() + this.width / 2);
    }

    public void setWidth(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (this.width == value) {
            return;
        }
        this.parent.updateColumnWidth(this, value);
    }

    void updateFont(GC gc) {
        this.computeDisplayText(gc);
    }

    void updateWidth(GC gc) {
        String oldDisplayText = this.displayText;
        this.computeDisplayText(gc);
        if (this.parent.getHeaderVisible() && ((this.getStyle() & 0x4000) == 0 || !oldDisplayText.equals(this.displayText))) {
            int padding = this.parent.getHeaderPadding();
            this.parent.header.redraw(this.getX() + padding, 0, this.width - padding, this.parent.getHeaderHeight(), false);
        }
    }

    Accessible getAccessible(final Accessible accessibleTable) {
        if (this.accessible == null) {
            this.accessible = new Accessible(accessibleTable);
            this.accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = CTableColumn.this.getText();
                    System.out.println("tableColumn getName = " + e.result);
                }
            });
            this.accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getChildAtPoint(AccessibleControlEvent e) {
                    Point point = CTableColumn.this.parent.toControl(e.x, e.y);
                    int x = CTableColumn.this.getX();
                    e.childID = x <= point.x && point.x <= x + CTableColumn.this.getWidth() ? -1 : -2;
                }

                public void getChildCount(AccessibleControlEvent e) {
                    e.detail = 0;
                }

                public void getLocation(AccessibleControlEvent e) {
                    Rectangle rect = CTableColumn.this.parent.header.getBounds();
                    rect.x = CTableColumn.this.getX();
                    Point pt = CTableColumn.this.parent.toDisplay(rect.x, rect.y);
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = CTableColumn.this.width;
                    e.height = rect.height;
                }

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 29;
                }
            });
            this.accessible.addAccessibleTableCellListener(new AccessibleTableCellListener(){

                public void getColumnHeaders(AccessibleTableCellEvent e) {
                }

                public void getColumnIndex(AccessibleTableCellEvent e) {
                    e.index = CTableColumn.this.getIndex();
                }

                public void getColumnSpan(AccessibleTableCellEvent e) {
                    e.count = 1;
                }

                public void getRowHeaders(AccessibleTableCellEvent e) {
                }

                public void getRowIndex(AccessibleTableCellEvent e) {
                    e.index = 0;
                }

                public void getRowSpan(AccessibleTableCellEvent e) {
                    e.count = 1;
                }

                public void getTable(AccessibleTableCellEvent e) {
                    e.accessible = accessibleTable;
                }

                public void isSelected(AccessibleTableCellEvent e) {
                    e.isSelected = false;
                }
            });
        }
        return this.accessible;
    }
}

