/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import java.io.File;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ClipboardExample {
    Clipboard clipboard;
    Shell shell;
    Text text;
    Combo combo;
    StyledText styledText;
    Label status;
    static final int HSIZE = 100;
    static final int VSIZE = 60;

    public static void main(String[] args) {
        Display display = new Display();
        new ClipboardExample().open(display);
        display.dispose();
    }

    public void open(Display display) {
        this.clipboard = new Clipboard(display);
        this.shell = new Shell(display);
        this.shell.setText("SWT Clipboard");
        this.shell.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
        Composite parent = new Composite((Composite)sc, 0);
        sc.setContent((Control)parent);
        parent.setLayout((Layout)new GridLayout(2, true));
        Group copyGroup = new Group(parent, 0);
        copyGroup.setText("Copy From:");
        GridData data = new GridData(1808);
        copyGroup.setLayoutData((Object)data);
        copyGroup.setLayout((Layout)new GridLayout(3, false));
        Group pasteGroup = new Group(parent, 0);
        pasteGroup.setText("Paste To:");
        data = new GridData(1808);
        pasteGroup.setLayoutData((Object)data);
        pasteGroup.setLayout((Layout)new GridLayout(3, false));
        Group controlGroup = new Group(parent, 0);
        controlGroup.setText("Control API:");
        data = new GridData(768);
        data.horizontalSpan = 2;
        controlGroup.setLayoutData((Object)data);
        controlGroup.setLayout((Layout)new GridLayout(5, false));
        Group typesGroup = new Group(parent, 0);
        typesGroup.setText("Available Types");
        data = new GridData(768);
        data.horizontalSpan = 2;
        typesGroup.setLayoutData((Object)data);
        typesGroup.setLayout((Layout)new GridLayout(2, false));
        this.status = new Label(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.status.setLayoutData((Object)data);
        this.createTextTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createRTFTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createHTMLTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createFileTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createImageTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createMyTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createControlTransfer((Composite)controlGroup);
        this.createAvailableTypes((Composite)typesGroup);
        sc.setMinSize(parent.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Point size = this.shell.computeSize(-1, -1);
        Rectangle monitorArea = this.shell.getMonitor().getClientArea();
        this.shell.setSize(Math.min(size.x, monitorArea.width - 20), Math.min(size.y, monitorArea.height - 20));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.clipboard.dispose();
    }

    void createTextTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("TextTransfer:");
        Text copyText = new Text(copyParent, 2818);
        copyText.setText("some\nplain\ntext");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = copyText.getText();
            if (textData.length() > 0) {
                this.status.setText("");
                this.clipboard.setContents(new Object[]{textData}, new Transfer[]{TextTransfer.getInstance()});
            } else {
                this.status.setText("No text to copy");
            }
        }));
        l = new Label(pasteParent, 0);
        l.setText("TextTransfer:");
        Text pasteText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (textData != null && textData.length() > 0) {
                this.status.setText("");
                pasteText.setText("begin paste>" + textData + "<end paste");
            } else {
                this.status.setText("No text to paste");
            }
        }));
    }

    void createRTFTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("RTFTransfer:");
        Text copyRtfText = new Text(copyParent, 2818);
        copyRtfText.setText("some\nrtf\ntext");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyRtfText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = copyRtfText.getText();
            if (textData.length() > 0) {
                this.status.setText("");
                StringBuilder buffer = new StringBuilder();
                buffer.append("{\\rtf1\\ansi\\uc1{\\colortbl;\\red255\\green0\\blue0;}\\uc1\\b\\i ");
                int i = 0;
                while (i < textData.length()) {
                    char ch = textData.charAt(i);
                    if (ch > '\u00ff') {
                        buffer.append("\\u");
                        buffer.append(Integer.toString((short)ch));
                        buffer.append('?');
                    } else {
                        if (ch == '}' || ch == '{' || ch == '\\') {
                            buffer.append('\\');
                        }
                        buffer.append(ch);
                        if (ch == '\n') {
                            buffer.append("\\par ");
                        }
                        if (ch == '\r' && (i - 1 == textData.length() || textData.charAt(i + 1) != '\n')) {
                            buffer.append("\\par ");
                        }
                    }
                    ++i;
                }
                buffer.append("}");
                this.clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{RTFTransfer.getInstance()});
            } else {
                this.status.setText("No RTF to copy");
            }
        }));
        l = new Label(pasteParent, 0);
        l.setText("RTFTransfer:");
        Text pasteRtfText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteRtfText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = (String)this.clipboard.getContents((Transfer)RTFTransfer.getInstance());
            if (textData != null && textData.length() > 0) {
                this.status.setText("");
                pasteRtfText.setText("start paste>" + textData + "<end paste");
            } else {
                this.status.setText("No RTF to paste");
            }
        }));
    }

    void createHTMLTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("HTMLTransfer:");
        Text copyHtmlText = new Text(copyParent, 2818);
        copyHtmlText.setText("<b>Hello World</b>");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyHtmlText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = copyHtmlText.getText();
            if (textData.length() > 0) {
                this.status.setText("");
                this.clipboard.setContents(new Object[]{textData}, new Transfer[]{HTMLTransfer.getInstance()});
            } else {
                this.status.setText("No HTML to copy");
            }
        }));
        l = new Label(pasteParent, 0);
        l.setText("HTMLTransfer:");
        Text pasteHtmlText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteHtmlText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String textData = (String)this.clipboard.getContents((Transfer)HTMLTransfer.getInstance());
            if (textData != null && textData.length() > 0) {
                this.status.setText("");
                pasteHtmlText.setText("start paste>" + textData + "<end paste");
            } else {
                this.status.setText("No HTML to paste");
            }
        }));
    }

    void createFileTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("FileTransfer:");
        GridData data = new GridData();
        data.verticalSpan = 3;
        l.setLayoutData((Object)data);
        Table copyFileTable = new Table(copyParent, 2818);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        data.verticalSpan = 3;
        copyFileTable.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Select file(s)");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.shell, 4098);
            String result = dialog.open();
            if (result != null && result.length() > 0) {
                String[] names;
                String path = dialog.getFilterPath();
                String[] stringArray = names = dialog.getFileNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    TableItem item = new TableItem(copyFileTable, 0);
                    item.setText(String.valueOf(path) + File.separator + name);
                    ++n2;
                }
            }
        }));
        b = new Button(copyParent, 8);
        b.setText("Select directory");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.shell, 4096);
            String result = dialog.open();
            if (result != null && result.length() > 0) {
                TableItem item = new TableItem(copyFileTable, 0);
                item.setText(result);
            }
        }));
        b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = copyFileTable.getItems();
            if (items.length > 0) {
                this.status.setText("");
                String[] itemsData = new String[items.length];
                int i = 0;
                while (i < itemsData.length) {
                    itemsData[i] = items[i].getText();
                    ++i;
                }
                this.clipboard.setContents(new Object[]{itemsData}, new Transfer[]{FileTransfer.getInstance()});
            } else {
                this.status.setText("No file to copy");
            }
        }));
        l = new Label(pasteParent, 0);
        l.setText("FileTransfer:");
        Table pasteFileTable = new Table(pasteParent, 2818);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteFileTable.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String[] textData = (String[])this.clipboard.getContents((Transfer)FileTransfer.getInstance());
            if (textData != null && textData.length > 0) {
                this.status.setText("");
                pasteFileTable.removeAll();
                String[] stringArray = textData;
                int n = textData.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    TableItem item = new TableItem(pasteFileTable, 0);
                    item.setText(element);
                    ++n2;
                }
            } else {
                this.status.setText("No file to paste");
            }
        }));
    }

    void createImageTransfer(Composite copyParent, Composite pasteParent) {
        Image[] copyImage = new Image[1];
        Label l = new Label(copyParent, 0);
        l.setText("ImageTransfer:");
        GridData data = new GridData();
        data.verticalSpan = 2;
        l.setLayoutData((Object)data);
        Canvas copyImageCanvas = new Canvas(copyParent, 2816);
        data = new GridData(1808);
        data.verticalSpan = 2;
        data.widthHint = 100;
        data.heightHint = 60;
        copyImageCanvas.setLayoutData((Object)data);
        Point copyOrigin = new Point(0, 0);
        ScrollBar copyHBar = copyImageCanvas.getHorizontalBar();
        copyHBar.setEnabled(false);
        copyHBar.addListener(13, e -> {
            if (copyImage[0] != null) {
                int hSelection = copyHBar.getSelection();
                int destX = -hSelection - point.x;
                Rectangle rect = copyImage[0].getBounds();
                copyImageCanvas.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                point.x = -hSelection;
            }
        });
        ScrollBar copyVBar = copyImageCanvas.getVerticalBar();
        copyVBar.setEnabled(false);
        copyVBar.addListener(13, e -> {
            if (copyImage[0] != null) {
                int vSelection = copyVBar.getSelection();
                int destY = -vSelection - point.y;
                Rectangle rect = copyImage[0].getBounds();
                copyImageCanvas.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                point.y = -vSelection;
            }
        });
        copyImageCanvas.addListener(9, e -> {
            if (copyImage[0] != null) {
                int marginHeight;
                GC gc = e.gc;
                gc.drawImage(copyImage[0], point.x, point.y);
                Rectangle rect = copyImage[0].getBounds();
                Rectangle client = copyImageCanvas.getClientArea();
                int marginWidth = client.width - rect.width;
                if (marginWidth > 0) {
                    gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                }
                if ((marginHeight = client.height - rect.height) > 0) {
                    gc.fillRectangle(0, rect.height, client.width, marginHeight);
                }
                gc.dispose();
            }
        });
        Button openButton = new Button(copyParent, 8);
        openButton.setText("Open Image");
        openButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.shell, 4096);
            dialog.setText("Open an image file or cancel");
            String string = dialog.open();
            if (string != null) {
                if (copyImage[0] != null) {
                    System.out.println("CopyImage");
                    copyImage[0].dispose();
                }
                imageArray[0] = new Image((Device)e.display, string);
                copyVBar.setEnabled(true);
                copyHBar.setEnabled(true);
                point.x = 0;
                point.y = 0;
                Rectangle rect = copyImage[0].getBounds();
                Rectangle client = copyImageCanvas.getClientArea();
                copyHBar.setMaximum(rect.width);
                copyVBar.setMaximum(rect.height);
                copyHBar.setThumb(Math.min(rect.width, client.width));
                copyVBar.setThumb(Math.min(rect.height, client.height));
                copyImageCanvas.scroll(0, 0, 0, 0, rect.width, rect.height, true);
                copyVBar.setSelection(0);
                copyHBar.setSelection(0);
                copyImageCanvas.redraw();
            }
        }));
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (copyImage[0] != null) {
                this.status.setText("");
                this.clipboard.setContents(new Object[]{copyImage[0].getImageDataAtCurrentZoom()}, new Transfer[]{ImageTransfer.getInstance()});
            } else {
                this.status.setText("No image to copy");
            }
        }));
        Image[] pasteImage = new Image[1];
        l = new Label(pasteParent, 0);
        l.setText("ImageTransfer:");
        Canvas pasteImageCanvas = new Canvas(pasteParent, 2816);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteImageCanvas.setLayoutData((Object)data);
        Point pasteOrigin = new Point(0, 0);
        ScrollBar pasteHBar = pasteImageCanvas.getHorizontalBar();
        pasteHBar.setEnabled(false);
        pasteHBar.addListener(13, e -> {
            if (pasteImage[0] != null) {
                int hSelection = pasteHBar.getSelection();
                int destX = -hSelection - point.x;
                Rectangle rect = pasteImage[0].getBounds();
                pasteImageCanvas.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                point.x = -hSelection;
            }
        });
        ScrollBar pasteVBar = pasteImageCanvas.getVerticalBar();
        pasteVBar.setEnabled(false);
        pasteVBar.addListener(13, e -> {
            if (pasteImage[0] != null) {
                int vSelection = pasteVBar.getSelection();
                int destY = -vSelection - point.y;
                Rectangle rect = pasteImage[0].getBounds();
                pasteImageCanvas.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                point.y = -vSelection;
            }
        });
        pasteImageCanvas.addListener(9, e -> {
            if (pasteImage[0] != null) {
                int marginHeight;
                GC gc = e.gc;
                gc.drawImage(pasteImage[0], point.x, point.y);
                Rectangle rect = pasteImage[0].getBounds();
                Rectangle client = pasteImageCanvas.getClientArea();
                int marginWidth = client.width - rect.width;
                if (marginWidth > 0) {
                    gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                }
                if ((marginHeight = client.height - rect.height) > 0) {
                    gc.fillRectangle(0, rect.height, client.width, marginHeight);
                }
            }
        });
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ImageData imageData = (ImageData)this.clipboard.getContents((Transfer)ImageTransfer.getInstance());
            if (imageData != null) {
                if (pasteImage[0] != null) {
                    System.out.println("PasteImage");
                    pasteImage[0].dispose();
                }
                this.status.setText("");
                imageArray[0] = new Image((Device)e.display, (ImageDataProvider)new AutoScaleImageDataProvider(imageData));
                pasteVBar.setEnabled(true);
                pasteHBar.setEnabled(true);
                point.x = 0;
                point.y = 0;
                Rectangle rect = pasteImage[0].getBounds();
                Rectangle client = pasteImageCanvas.getClientArea();
                pasteHBar.setMaximum(rect.width);
                pasteVBar.setMaximum(rect.height);
                pasteHBar.setThumb(Math.min(rect.width, client.width));
                pasteVBar.setThumb(Math.min(rect.height, client.height));
                pasteImageCanvas.scroll(0, 0, 0, 0, rect.width, rect.height, true);
                pasteVBar.setSelection(0);
                pasteHBar.setSelection(0);
                pasteImageCanvas.redraw();
            } else {
                this.status.setText("No image to paste");
            }
        }));
    }

    void createMyTransfer(Composite copyParent, Composite pasteParent) {
    }

    void createControlTransfer(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Text:");
        Button b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.text.cut()));
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.text.copy()));
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.text.paste()));
        this.text = new Text(parent, 2818);
        GridData data = new GridData(768);
        data.widthHint = 100;
        data.heightHint = 60;
        this.text.setLayoutData((Object)data);
        l = new Label(parent, 0);
        l.setText("Combo:");
        b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.combo.cut()));
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.combo.copy()));
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.combo.paste()));
        this.combo = new Combo(parent, 0);
        this.combo.setItems(new String[]{"Item 1", "Item 2", "Item 3", "A longer Item"});
        this.combo.setLayoutData((Object)new GridData(768));
        l = new Label(parent, 0);
        l.setText("StyledText:");
        b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.styledText.cut()));
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.styledText.copy()));
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.styledText.paste()));
        this.styledText = new StyledText(parent, 2818);
        data = new GridData(768);
        data.widthHint = 100;
        data.heightHint = 60;
        this.styledText.setLayoutData((Object)data);
    }

    void createAvailableTypes(Composite parent) {
        List list = new List(parent, 2816);
        GridData data = new GridData(1808);
        data.heightHint = 60;
        list.setLayoutData((Object)data);
        Button b = new Button(parent, 8);
        b.setText("Get Available Types");
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String[] names;
            list.removeAll();
            String[] stringArray = names = this.clipboard.getAvailableTypeNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                list.add(name);
                ++n2;
            }
        }));
    }

    static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(ImageData data) {
            this.imageData = data;
            this.currentZoom = AutoScaleImageDataProvider.getDeviceZoom();
        }

        public ImageData getImageData(int zoom) {
            return AutoScaleImageDataProvider.autoScaleImageData(this.imageData, zoom, this.currentZoom);
        }

        static ImageData autoScaleImageData(ImageData imageData, int targetZoom, int currentZoom) {
            if (imageData == null || targetZoom == currentZoom) {
                return imageData;
            }
            float scaleFactor = (float)targetZoom / (float)currentZoom;
            return imageData.scaledTo(Math.round((float)imageData.width * scaleFactor), Math.round((float)imageData.height * scaleFactor));
        }

        static int getDeviceZoom() {
            int zoom = 100;
            String value = System.getProperty("org.eclipse.swt.internal.deviceZoom");
            if (value != null) {
                try {
                    zoom = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return zoom;
        }
    }
}

