/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

abstract class AlignableTab
extends Tab {
    Button leftButton;
    Button rightButton;
    Button centerButton;
    Group alignmentGroup;

    AlignableTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.alignmentGroup = new Group((Composite)this.otherGroup, 0);
        this.alignmentGroup.setLayout((Layout)new GridLayout());
        this.alignmentGroup.setLayoutData((Object)new GridData(272));
        this.alignmentGroup.setText(ControlExample.getResourceString("Alignment"));
        this.leftButton = new Button((Composite)this.alignmentGroup, 16);
        this.leftButton.setText(ControlExample.getResourceString("Left"));
        this.centerButton = new Button((Composite)this.alignmentGroup, 16);
        this.centerButton.setText(ControlExample.getResourceString("Center"));
        this.rightButton = new Button((Composite)this.alignmentGroup, 16);
        this.rightButton.setText(ControlExample.getResourceString("Right"));
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(event -> {
            if (!((Button)event.widget).getSelection()) {
                return;
            }
            this.setExampleWidgetAlignment();
        });
        this.leftButton.addSelectionListener(selectionListener);
        this.centerButton.addSelectionListener(selectionListener);
        this.rightButton.addSelectionListener(selectionListener);
    }

    abstract void setExampleWidgetAlignment();

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        Widget[] widgets = this.getExampleWidgets();
        if (widgets.length != 0) {
            this.leftButton.setSelection((widgets[0].getStyle() & 0x4000) != 0);
            this.centerButton.setSelection((widgets[0].getStyle() & 0x1000000) != 0);
            this.rightButton.setSelection((widgets[0].getStyle() & 0x20000) != 0);
        }
    }
}

