/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

class CanvasTab
extends Tab {
    static final int[] colors = new int[]{3, 5, 9, 11, 7, 13, 4, 6, 10, 12, 8, 14};
    static final String canvasString = "Canvas";
    Canvas canvas;
    Group canvasGroup;
    Button horizontalButton;
    Button verticalButton;
    Button noBackgroundButton;
    Button noFocusButton;
    Button noMergePaintsButton;
    Button noRedrawResizeButton;
    Button doubleBufferedButton;
    Button caretButton;
    Button fillDamageButton;
    int paintCount;
    int cx;
    int cy;
    int maxX;
    int maxY;

    CanvasTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.caretButton = new Button((Composite)this.otherGroup, 32);
        this.caretButton.setText(ControlExample.getResourceString("Caret"));
        this.fillDamageButton = new Button((Composite)this.otherGroup, 32);
        this.fillDamageButton.setText(ControlExample.getResourceString("FillDamage"));
        this.caretButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setCaret()));
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.canvasGroup = new Group((Composite)this.exampleGroup, 0);
        this.canvasGroup.setLayout((Layout)new GridLayout());
        this.canvasGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvasGroup.setText(canvasString);
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.noBackgroundButton.getSelection()) {
            style |= 0x40000;
        }
        if (this.noFocusButton.getSelection()) {
            style |= 0x80000;
        }
        if (this.noMergePaintsButton.getSelection()) {
            style |= 0x200000;
        }
        if (this.noRedrawResizeButton.getSelection()) {
            style |= 0x100000;
        }
        if (this.doubleBufferedButton.getSelection()) {
            style |= 0x20000000;
        }
        this.paintCount = 0;
        this.cx = 0;
        this.cy = 0;
        this.canvas = new Canvas((Composite)this.canvasGroup, style);
        this.canvas.addPaintListener(e -> {
            ++this.paintCount;
            GC gc = e.gc;
            if (this.fillDamageButton.getSelection()) {
                Color color = e.display.getSystemColor(colors[this.paintCount % colors.length]);
                gc.setBackground(color);
                gc.fillRectangle(e.x, e.y, e.width, e.height);
            }
            Point size = this.canvas.getSize();
            gc.drawArc(this.cx + 1, this.cy + 1, size.x - 2, size.y - 2, 0, 360);
            gc.drawRectangle(this.cx + (size.x - 10) / 2, this.cy + (size.y - 10) / 2, 10, 10);
            Point extent = gc.textExtent(canvasString);
            gc.drawString(canvasString, this.cx + (size.x - extent.x) / 2, this.cy - extent.y + (size.y - 10) / 2, true);
        });
        this.canvas.addControlListener(ControlListener.controlResizedAdapter(e -> {
            Point size = this.canvas.getSize();
            this.maxX = size.x * 3 / 2;
            this.maxY = size.y * 3 / 2;
            this.resizeScrollBars();
        }));
        ScrollBar bar = this.canvas.getHorizontalBar();
        if (bar != null) {
            this.hookListeners((Widget)bar);
            bar.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.scrollHorizontal((ScrollBar)event.widget)));
        }
        if ((bar = this.canvas.getVerticalBar()) != null) {
            this.hookListeners((Widget)bar);
            bar.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.scrollVertical((ScrollBar)event.widget)));
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 32);
        this.horizontalButton.setText("SWT.H_SCROLL");
        this.horizontalButton.setSelection(true);
        this.verticalButton = new Button((Composite)this.styleGroup, 32);
        this.verticalButton.setText("SWT.V_SCROLL");
        this.verticalButton.setSelection(true);
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.noBackgroundButton = new Button((Composite)this.styleGroup, 32);
        this.noBackgroundButton.setText("SWT.NO_BACKGROUND");
        this.noFocusButton = new Button((Composite)this.styleGroup, 32);
        this.noFocusButton.setText("SWT.NO_FOCUS");
        this.noMergePaintsButton = new Button((Composite)this.styleGroup, 32);
        this.noMergePaintsButton.setText("SWT.NO_MERGE_PAINTS");
        this.noRedrawResizeButton = new Button((Composite)this.styleGroup, 32);
        this.noRedrawResizeButton.setText("SWT.NO_REDRAW_RESIZE");
        this.doubleBufferedButton = new Button((Composite)this.styleGroup, 32);
        this.doubleBufferedButton.setText("SWT.DOUBLE_BUFFERED");
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener(ControlListener.controlResizedAdapter(e -> this.setExampleWidgetSize()));
        return this.tabFolderPage;
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.canvas};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ToolTipText"};
    }

    @Override
    String getTabText() {
        return canvasString;
    }

    void resizeScrollBars() {
        Rectangle clientArea = this.canvas.getClientArea();
        ScrollBar bar = this.canvas.getHorizontalBar();
        if (bar != null) {
            bar.setMaximum(this.maxX);
            bar.setThumb(clientArea.width);
            bar.setPageIncrement(clientArea.width);
        }
        if ((bar = this.canvas.getVerticalBar()) != null) {
            bar.setMaximum(this.maxY);
            bar.setThumb(clientArea.height);
            bar.setPageIncrement(clientArea.height);
        }
    }

    void scrollHorizontal(ScrollBar scrollBar) {
        Rectangle bounds = this.canvas.getClientArea();
        int x = -scrollBar.getSelection();
        if (x + this.maxX < bounds.width) {
            x = bounds.width - this.maxX;
        }
        this.canvas.scroll(x, this.cy, this.cx, this.cy, this.maxX, this.maxY, false);
        this.cx = x;
    }

    void scrollVertical(ScrollBar scrollBar) {
        Rectangle bounds = this.canvas.getClientArea();
        int y = -scrollBar.getSelection();
        if (y + this.maxY < bounds.height) {
            y = bounds.height - this.maxY;
        }
        this.canvas.scroll(this.cx, y, this.cx, this.cy, this.maxX, this.maxY, false);
        this.cy = y;
    }

    void setCaret() {
        Caret oldCaret = this.canvas.getCaret();
        if (this.caretButton.getSelection()) {
            Caret newCaret = new Caret(this.canvas, 0);
            Font font = this.canvas.getFont();
            newCaret.setFont(font);
            GC gc = new GC((Drawable)this.canvas);
            gc.setFont(font);
            newCaret.setBounds(1, 1, 1, gc.getFontMetrics().getHeight());
            gc.dispose();
            this.canvas.setCaret(newCaret);
            this.canvas.setFocus();
        } else {
            this.canvas.setCaret(null);
        }
        if (oldCaret != null) {
            oldCaret.dispose();
        }
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.canvas.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.canvas.getStyle() & 0x200) != 0);
        this.borderButton.setSelection((this.canvas.getStyle() & 0x800) != 0);
        this.noBackgroundButton.setSelection((this.canvas.getStyle() & 0x40000) != 0);
        this.noFocusButton.setSelection((this.canvas.getStyle() & 0x80000) != 0);
        this.noMergePaintsButton.setSelection((this.canvas.getStyle() & 0x200000) != 0);
        this.noRedrawResizeButton.setSelection((this.canvas.getStyle() & 0x100000) != 0);
        this.doubleBufferedButton.setSelection((this.canvas.getStyle() & 0x20000000) != 0);
        if (!this.instance.startup) {
            this.setCaret();
        }
    }
}

