/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class ColorTab
extends Tab {
    Table colors;
    Group colorsGroup;
    HashMap<Integer, String> hmap = new HashMap();
    static final int namedColorEnd = 8;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("ColorTitle_0"), ControlExample.getResourceString("ColorTitle_1"), ControlExample.getResourceString("ColorTitle_2"), ControlExample.getResourceString("ColorTitle_3")};
    Button packColumnsButton;

    ColorTab(ControlExample instance) {
        super(instance);
        this.addTableElements();
    }

    void addTableElements() {
        this.hmap.put(1, "COLOR_WHITE");
        this.hmap.put(2, "COLOR_BLACK");
        this.hmap.put(3, "COLOR_RED");
        this.hmap.put(4, "COLOR_DARK_RED");
        this.hmap.put(5, "COLOR_GREEN");
        this.hmap.put(6, "COLOR_DARK_GREEN");
        this.hmap.put(7, "COLOR_YELLOW");
        this.hmap.put(8, "COLOR_DARK_YELLOW");
        this.hmap.put(17, "COLOR_WIDGET_DARK_SHADOW");
        this.hmap.put(18, "COLOR_WIDGET_NORMAL_SHADOW");
        this.hmap.put(19, "COLOR_WIDGET_LIGHT_SHADOW");
        this.hmap.put(20, "COLOR_WIDGET_HIGHLIGHT_SHADOW");
        this.hmap.put(21, "COLOR_WIDGET_FOREGROUND");
        this.hmap.put(22, "COLOR_WIDGET_BACKGROUND");
        this.hmap.put(23, "COLOR_WIDGET_BORDER");
        this.hmap.put(24, "COLOR_LIST_FOREGROUND");
        this.hmap.put(25, "COLOR_LIST_BACKGROUND");
        this.hmap.put(26, "COLOR_LIST_SELECTION");
        this.hmap.put(27, "COLOR_LIST_SELECTION_TEXT");
        this.hmap.put(28, "COLOR_INFO_FOREGROUND");
        this.hmap.put(29, "COLOR_INFO_BACKGROUND");
        this.hmap.put(30, "COLOR_TITLE_FOREGROUND");
        this.hmap.put(31, "COLOR_TITLE_BACKGROUND");
        this.hmap.put(32, "COLOR_TITLE_BACKGROUND_GRADIENT");
        this.hmap.put(33, "COLOR_TITLE_INACTIVE_FOREGROUND");
        this.hmap.put(34, "COLOR_TITLE_INACTIVE_BACKGROUND");
        this.hmap.put(35, "COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT");
        this.hmap.put(36, "COLOR_LINK_FOREGROUND");
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.colorsGroup = new Group((Composite)this.exampleGroup, 0);
        this.colorsGroup.setLayout((Layout)new GridLayout());
        this.colorsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.colorsGroup.setText("Color");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        this.colors = new Table((Composite)this.colorsGroup, style);
        this.colors.setHeaderVisible(true);
        String[] stringArray = columnTitles;
        int n = columnTitles.length;
        int n2 = 0;
        while (n2 < n) {
            String columnTitle = stringArray[n2];
            TableColumn tableColumn = new TableColumn(this.colors, 0);
            tableColumn.setText(columnTitle);
            tableColumn.setToolTipText(ControlExample.getResourceString("Tooltip", columnTitle));
            ++n2;
        }
        boolean emptyLineFlag = false;
        for (Map.Entry<Integer, String> entry : this.hmap.entrySet()) {
            TableItem item;
            Integer key = entry.getKey();
            String value = entry.getValue();
            if (!emptyLineFlag) {
                item = new TableItem(this.colors, 0);
                item.setText(value);
                item.setText(0, value);
                item.setText(1, "Named");
                item.setText(2, this.getRGBcolor(key));
                item.setText(3, "            ");
                item.setBackground(3, this.display.getSystemColor(key.intValue()));
                if (key != 8) continue;
                TableItem emptyItem = new TableItem(this.colors, 0);
                emptyItem.setText("");
                emptyLineFlag = true;
                continue;
            }
            item = new TableItem(this.colors, 0);
            item.setText(value);
            item.setText(0, String.valueOf(value) + " ");
            item.setText(1, "System ");
            item.setText(2, String.valueOf(this.getRGBcolor(key)) + " ");
            item.setText(3, "            ");
            item.setBackground(3, this.display.getSystemColor(key.intValue()));
        }
        int i = 0;
        while (i < columnTitles.length) {
            this.colors.getColumn(i).pack();
            ++i;
        }
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.colors};
    }

    @Override
    String getTabText() {
        return "Color";
    }

    @Override
    void createSizeGroup() {
        super.createSizeGroup();
        this.packColumnsButton = new Button((Composite)this.sizeGroup, 8);
        this.packColumnsButton.setText(ControlExample.getResourceString("Pack_Columns"));
        this.packColumnsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.packColumns();
            this.setExampleWidgetSize();
        }));
    }

    void packColumns() {
        int columnCount = this.colors.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn tableColumn = this.colors.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    String getRGBcolor(int id) {
        Color color = this.display.getSystemColor(id);
        return String.format("(%d,%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    boolean rtlSupport() {
        return false;
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.createOtherGroup();
        this.createSetGetGroup();
        this.createSizeGroup();
        this.createOrientationGroup();
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(event -> {
            if ((event.widget.getStyle() & 0x10) != 0 && !((Button)event.widget).getSelection()) {
                return;
            }
            if (!this.handleTextDirection(event.widget)) {
                this.recreateExampleWidgets();
            }
        });
        this.rtlButton.addSelectionListener(selectionListener);
        this.ltrButton.addSelectionListener(selectionListener);
        this.defaultOrietationButton.addSelectionListener(selectionListener);
    }
}

