/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class DateTimeTab
extends Tab {
    DateTime dateTime1;
    Group dateTimeGroup;
    Button dateButton;
    Button timeButton;
    Button calendarButton;
    Button shortButton;
    Button mediumButton;
    Button longButton;
    Button dropDownButton;
    Button weekNumbersButton;

    DateTimeTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.dateTimeGroup = new Group((Composite)this.exampleGroup, 0);
        this.dateTimeGroup.setLayout((Layout)new GridLayout());
        this.dateTimeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dateTimeGroup.setText("DateTime");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.dateButton.getSelection()) {
            style |= 0x20;
        }
        if (this.timeButton.getSelection()) {
            style |= 0x80;
        }
        if (this.calendarButton.getSelection()) {
            style |= 0x400;
        }
        if (this.shortButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.mediumButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.longButton.getSelection()) {
            style |= 0x10000000;
        }
        if (this.dropDownButton.getSelection()) {
            style |= 4;
        }
        if (this.weekNumbersButton.getSelection()) {
            style |= 0x4000;
        }
        this.dateTime1 = new DateTime((Composite)this.dateTimeGroup, style);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.dateButton = new Button((Composite)this.styleGroup, 16);
        this.dateButton.setText("SWT.DATE");
        this.timeButton = new Button((Composite)this.styleGroup, 16);
        this.timeButton.setText("SWT.TIME");
        this.calendarButton = new Button((Composite)this.styleGroup, 16);
        this.calendarButton.setText("SWT.CALENDAR");
        Group formatGroup = new Group((Composite)this.styleGroup, 0);
        formatGroup.setLayout((Layout)new GridLayout());
        this.shortButton = new Button((Composite)formatGroup, 16);
        this.shortButton.setText("SWT.SHORT");
        this.mediumButton = new Button((Composite)formatGroup, 16);
        this.mediumButton.setText("SWT.MEDIUM");
        this.longButton = new Button((Composite)formatGroup, 16);
        this.longButton.setText("SWT.LONG");
        this.dropDownButton = new Button((Composite)this.styleGroup, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.weekNumbersButton = new Button((Composite)this.styleGroup, 32);
        this.weekNumbersButton.setText("SWT.CALENDAR_WEEKNUMBERS");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.dateTime1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Day", "Hours", "Minutes", "Month", "Seconds", "Year"};
    }

    @Override
    String getShortTabText() {
        return "DT";
    }

    @Override
    String getTabText() {
        return "DateTime";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.dateButton.setSelection((this.dateTime1.getStyle() & 0x20) != 0);
        this.timeButton.setSelection((this.dateTime1.getStyle() & 0x80) != 0);
        this.calendarButton.setSelection((this.dateTime1.getStyle() & 0x400) != 0);
        this.shortButton.setSelection((this.dateTime1.getStyle() & 0x8000) != 0);
        this.mediumButton.setSelection((this.dateTime1.getStyle() & 0x10000) != 0);
        this.longButton.setSelection((this.dateTime1.getStyle() & 0x10000000) != 0);
        if ((this.dateTime1.getStyle() & 0x20) != 0) {
            this.dropDownButton.setEnabled(true);
            this.dropDownButton.setSelection((this.dateTime1.getStyle() & 4) != 0);
        } else {
            this.dropDownButton.setSelection(false);
            this.dropDownButton.setEnabled(false);
        }
        if ((this.dateTime1.getStyle() & 0x400) != 0 || (this.dateTime1.getStyle() & 4) != 0) {
            this.weekNumbersButton.setEnabled(true);
        } else {
            this.weekNumbersButton.setEnabled(false);
            this.weekNumbersButton.setSelection(false);
        }
        this.borderButton.setEnabled(false);
    }
}

