/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class MenuTab
extends Tab {
    Button barButton;
    Button dropDownButton;
    Button popUpButton;
    Button noRadioGroupButton;
    Button leftToRightButton;
    Button rightToLeftButton;
    Button checkButton;
    Button cascadeButton;
    Button pushButton;
    Button radioButton;
    Button separatorButton;
    Button imagesButton;
    Button acceleratorsButton;
    Button mnemonicsButton;
    Button subMenuButton;
    Button subSubMenuButton;
    Button tooltipButton;
    Button createButton;
    Button closeAllButton;
    Group menuItemStyleGroup;
    int shellCount = 0;
    Shell[] shells = new Shell[4];

    MenuTab(ControlExample instance) {
        super(instance);
    }

    void closeAllShells() {
        int i = 0;
        while (i < this.shellCount) {
            if (this.shells[i] != null & !this.shells[i].isDisposed()) {
                this.shells[i].dispose();
            }
            ++i;
        }
        this.shellCount = 0;
    }

    public void createButtonSelected(SelectionEvent event) {
        Shell shell;
        if (this.shellCount >= this.shells.length) {
            Shell[] newShells = new Shell[this.shells.length + 4];
            System.arraycopy(this.shells, 0, newShells, 0, this.shells.length);
            this.shells = newShells;
        }
        int orientation = 0;
        if (this.leftToRightButton.getSelection()) {
            orientation |= 0x2000000;
        }
        if (this.rightToLeftButton.getSelection()) {
            orientation |= 0x4000000;
        }
        int radioBehavior = 0;
        if (this.noRadioGroupButton.getSelection()) {
            radioBehavior |= 0x400000;
        }
        this.shells[this.shellCount] = shell = new Shell(0x4F0 | orientation);
        if (this.barButton.getSelection()) {
            Menu menuBar = new Menu((Decorations)shell, 2 | radioBehavior);
            shell.setMenuBar(menuBar);
            this.hookListeners((Widget)menuBar);
            if (this.dropDownButton.getSelection() && this.cascadeButton.getSelection()) {
                MenuItem item = new MenuItem(menuBar, 64);
                item.setText(this.getMenuItemText("Cascade"));
                if (this.imagesButton.getSelection()) {
                    item.setImage(this.instance.images[1]);
                }
                if (this.tooltipButton.getSelection()) {
                    item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
                }
                this.hookListeners((Widget)item);
                Menu dropDownMenu = new Menu((Decorations)shell, 4 | radioBehavior);
                item.setMenu(dropDownMenu);
                this.hookListeners((Widget)dropDownMenu);
                this.createMenuItems(dropDownMenu, this.subMenuButton.getSelection(), this.subSubMenuButton.getSelection());
            }
        }
        if (this.popUpButton.getSelection()) {
            Menu popUpMenu = new Menu((Decorations)shell, 8 | radioBehavior);
            shell.setMenu(popUpMenu);
            this.hookListeners((Widget)popUpMenu);
            this.createMenuItems(popUpMenu, this.subMenuButton.getSelection(), this.subSubMenuButton.getSelection());
        }
        shell.setSize(300, 100);
        shell.setText(String.valueOf(ControlExample.getResourceString("Title")) + this.shellCount);
        shell.addPaintListener(e -> e.gc.drawString(ControlExample.getResourceString("PopupMenuHere"), 20, 20));
        shell.open();
        ++this.shellCount;
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(272));
        this.styleGroup.setText(ControlExample.getResourceString("Menu_Styles"));
        this.menuItemStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.menuItemStyleGroup.setLayout((Layout)new GridLayout());
        this.menuItemStyleGroup.setLayoutData((Object)new GridData(272));
        this.menuItemStyleGroup.setText(ControlExample.getResourceString("MenuItem_Styles"));
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(272));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
    }

    @Override
    void createControlWidgets() {
        this.barButton = new Button((Composite)this.styleGroup, 32);
        this.barButton.setText("SWT.BAR");
        this.dropDownButton = new Button((Composite)this.styleGroup, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.popUpButton = new Button((Composite)this.styleGroup, 32);
        this.popUpButton.setText("SWT.POP_UP");
        this.noRadioGroupButton = new Button((Composite)this.styleGroup, 32);
        this.noRadioGroupButton.setText("SWT.NO_RADIO_GROUP");
        this.leftToRightButton = new Button((Composite)this.styleGroup, 16);
        this.leftToRightButton.setText("SWT.LEFT_TO_RIGHT");
        this.leftToRightButton.setSelection(true);
        this.rightToLeftButton = new Button((Composite)this.styleGroup, 16);
        this.rightToLeftButton.setText("SWT.RIGHT_TO_LEFT");
        this.cascadeButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.cascadeButton.setText("SWT.CASCADE");
        this.checkButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.pushButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.pushButton.setText("SWT.PUSH");
        this.radioButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.radioButton.setText("SWT.RADIO");
        this.separatorButton = new Button((Composite)this.menuItemStyleGroup, 32);
        this.separatorButton.setText("SWT.SEPARATOR");
        this.enabledButton = new Button((Composite)this.otherGroup, 32);
        this.enabledButton.setText(ControlExample.getResourceString("Enabled"));
        this.enabledButton.setSelection(true);
        this.imagesButton = new Button((Composite)this.otherGroup, 32);
        this.imagesButton.setText(ControlExample.getResourceString("Images"));
        this.acceleratorsButton = new Button((Composite)this.otherGroup, 32);
        this.acceleratorsButton.setText(ControlExample.getResourceString("Accelerators"));
        this.mnemonicsButton = new Button((Composite)this.otherGroup, 32);
        this.mnemonicsButton.setText(ControlExample.getResourceString("Mnemonics"));
        this.subMenuButton = new Button((Composite)this.otherGroup, 32);
        this.subMenuButton.setText(ControlExample.getResourceString("SubMenu"));
        this.subSubMenuButton = new Button((Composite)this.otherGroup, 32);
        this.subSubMenuButton.setText(ControlExample.getResourceString("SubSubMenu"));
        this.tooltipButton = new Button((Composite)this.otherGroup, 32);
        this.tooltipButton.setText(ControlExample.getResourceString("Show_Tooltip"));
        new Label((Composite)this.controlGroup, 0);
        this.createButton = new Button((Composite)this.controlGroup, 0);
        this.createButton.setLayoutData((Object)new GridData(128));
        this.createButton.setText(ControlExample.getResourceString("Create_Shell"));
        this.closeAllButton = new Button((Composite)this.controlGroup, 0);
        this.closeAllButton.setLayoutData((Object)new GridData(32));
        this.closeAllButton.setText(ControlExample.getResourceString("Close_All_Shells"));
        this.createButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.createButtonSelected((SelectionEvent)e)));
        this.closeAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.closeAllShells()));
        this.subMenuButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.subSubMenuButton.setEnabled(this.subMenuButton.getSelection())));
        this.barButton.setSelection(true);
        this.dropDownButton.setSelection(true);
        this.popUpButton.setSelection(true);
        this.cascadeButton.setSelection(true);
        this.checkButton.setSelection(true);
        this.pushButton.setSelection(true);
        this.radioButton.setSelection(true);
        this.separatorButton.setSelection(true);
        this.subSubMenuButton.setEnabled(this.subMenuButton.getSelection());
    }

    void createMenuItems(Menu menu, boolean createSubMenu, boolean createSubSubMenu) {
        MenuItem item;
        if (this.pushButton.getSelection()) {
            item = new MenuItem(menu, 8);
            item.setText(this.getMenuItemText("Push"));
            if (this.acceleratorsButton.getSelection()) {
                item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 80);
            }
            if (this.imagesButton.getSelection()) {
                item.setImage(this.instance.images[0]);
            }
            item.setEnabled(this.enabledButton.getSelection());
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
            this.hookListeners((Widget)item);
        }
        if (this.separatorButton.getSelection()) {
            item = new MenuItem(menu, 2);
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
        }
        if (this.checkButton.getSelection()) {
            item = new MenuItem(menu, 32);
            item.setText(this.getMenuItemText("Check"));
            if (this.acceleratorsButton.getSelection()) {
                item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 67);
            }
            if (this.imagesButton.getSelection()) {
                item.setImage(this.instance.images[1]);
            }
            item.setEnabled(this.enabledButton.getSelection());
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
            this.hookListeners((Widget)item);
        }
        if (this.radioButton.getSelection()) {
            item = new MenuItem(menu, 16);
            item.setText(this.getMenuItemText("1Radio"));
            if (this.acceleratorsButton.getSelection()) {
                item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 49);
            }
            if (this.imagesButton.getSelection()) {
                item.setImage(this.instance.images[2]);
            }
            item.setSelection(true);
            item.setEnabled(this.enabledButton.getSelection());
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
            this.hookListeners((Widget)item);
            item = new MenuItem(menu, 16);
            item.setText(this.getMenuItemText("2Radio"));
            if (this.acceleratorsButton.getSelection()) {
                item.setAccelerator(SWT.MOD1 + SWT.MOD2 + 50);
            }
            if (this.imagesButton.getSelection()) {
                item.setImage(this.instance.images[2]);
            }
            item.setEnabled(this.enabledButton.getSelection());
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
            this.hookListeners((Widget)item);
        }
        if (createSubMenu && this.cascadeButton.getSelection()) {
            item = new MenuItem(menu, 64);
            item.setText(this.getMenuItemText("Cascade"));
            if (this.imagesButton.getSelection()) {
                item.setImage(this.instance.images[1]);
            }
            this.hookListeners((Widget)item);
            Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
            item.setMenu(subMenu);
            item.setEnabled(this.enabledButton.getSelection());
            this.hookListeners((Widget)subMenu);
            if (this.tooltipButton.getSelection()) {
                item.setToolTipText(ControlExample.getResourceString("Tooltip", item.getText()));
            }
            this.createMenuItems(subMenu, createSubSubMenu, false);
        }
    }

    String getMenuItemText(String item) {
        boolean cascade = item.equals("Cascade");
        boolean mnemonic = this.mnemonicsButton.getSelection();
        boolean accelerator = this.acceleratorsButton.getSelection();
        char acceleratorKey = item.charAt(0);
        if (mnemonic && accelerator && !cascade) {
            return String.valueOf(ControlExample.getResourceString(String.valueOf(item) + "WithMnemonic")) + "\tCtrl+Shift+" + acceleratorKey;
        }
        if (accelerator && !cascade) {
            return String.valueOf(ControlExample.getResourceString(item)) + "\tCtrl+Shift+" + acceleratorKey;
        }
        if (mnemonic) {
            return ControlExample.getResourceString(String.valueOf(item) + "WithMnemonic");
        }
        return ControlExample.getResourceString(item);
    }

    @Override
    String getTabText() {
        return "Menu";
    }
}

