/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

class SpinnerTab
extends RangeTab {
    Spinner spinner1;
    Group spinnerGroup;
    Button readOnlyButton;
    Button wrapButton;
    Spinner incrementSpinner;
    Spinner pageIncrementSpinner;
    Spinner digitsSpinner;

    SpinnerTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createControlWidgets() {
        super.createControlWidgets();
        this.createIncrementGroup();
        this.createPageIncrementGroup();
        this.createDigitsGroup();
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.spinnerGroup = new Group((Composite)this.exampleGroup, 0);
        this.spinnerGroup.setLayout((Layout)new GridLayout());
        this.spinnerGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.spinnerGroup.setText("Spinner");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        this.spinner1 = new Spinner((Composite)this.spinnerGroup, style);
    }

    void createIncrementGroup() {
        Group incrementGroup = new Group((Composite)this.controlGroup, 0);
        incrementGroup.setLayout((Layout)new GridLayout());
        incrementGroup.setText(ControlExample.getResourceString("Increment"));
        incrementGroup.setLayoutData((Object)new GridData(768));
        this.incrementSpinner = new Spinner((Composite)incrementGroup, 2048);
        this.incrementSpinner.setMaximum(100000);
        this.incrementSpinner.setSelection(this.getDefaultIncrement());
        this.incrementSpinner.setPageIncrement(100);
        this.incrementSpinner.setIncrement(1);
        this.incrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.incrementSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setWidgetIncrement()));
    }

    void createPageIncrementGroup() {
        Group pageIncrementGroup = new Group((Composite)this.controlGroup, 0);
        pageIncrementGroup.setLayout((Layout)new GridLayout());
        pageIncrementGroup.setText(ControlExample.getResourceString("Page_Increment"));
        pageIncrementGroup.setLayoutData((Object)new GridData(768));
        this.pageIncrementSpinner = new Spinner((Composite)pageIncrementGroup, 2048);
        this.pageIncrementSpinner.setMaximum(100000);
        this.pageIncrementSpinner.setSelection(this.getDefaultPageIncrement());
        this.pageIncrementSpinner.setPageIncrement(100);
        this.pageIncrementSpinner.setIncrement(1);
        this.pageIncrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pageIncrementSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetPageIncrement()));
    }

    void createDigitsGroup() {
        Group digitsGroup = new Group((Composite)this.controlGroup, 0);
        digitsGroup.setLayout((Layout)new GridLayout());
        digitsGroup.setText(ControlExample.getResourceString("Digits"));
        digitsGroup.setLayoutData((Object)new GridData(768));
        this.digitsSpinner = new Spinner((Composite)digitsGroup, 2048);
        this.digitsSpinner.setMaximum(100000);
        this.digitsSpinner.setSelection(this.getDefaultDigits());
        this.digitsSpinner.setPageIncrement(100);
        this.digitsSpinner.setIncrement(1);
        this.digitsSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.digitsSpinner.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setWidgetDigits()));
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener(ControlListener.controlResizedAdapter(e -> this.setExampleWidgetSize()));
        return this.tabFolderPage;
    }

    @Override
    void createStyleGroup() {
        this.orientationButtons = false;
        super.createStyleGroup();
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.spinner1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "TextLimit", "ToolTipText"};
    }

    @Override
    String getTabText() {
        return "Spinner";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.readOnlyButton.setSelection((this.spinner1.getStyle() & 8) != 0);
        this.wrapButton.setSelection((this.spinner1.getStyle() & 0x40) != 0);
        if (!this.instance.startup) {
            this.setWidgetIncrement();
            this.setWidgetPageIncrement();
            this.setWidgetDigits();
        }
    }

    @Override
    int getDefaultMaximum() {
        return this.spinner1.getMaximum();
    }

    @Override
    int getDefaultMinimum() {
        return this.spinner1.getMinimum();
    }

    @Override
    int getDefaultSelection() {
        return this.spinner1.getSelection();
    }

    int getDefaultIncrement() {
        return this.spinner1.getIncrement();
    }

    int getDefaultPageIncrement() {
        return this.spinner1.getPageIncrement();
    }

    int getDefaultDigits() {
        return this.spinner1.getDigits();
    }

    void setWidgetIncrement() {
        this.spinner1.setIncrement(this.incrementSpinner.getSelection());
    }

    @Override
    void setWidgetMaximum() {
        this.spinner1.setMaximum(this.maximumSpinner.getSelection());
    }

    @Override
    void setWidgetMinimum() {
        this.spinner1.setMinimum(this.minimumSpinner.getSelection());
    }

    void setWidgetPageIncrement() {
        this.spinner1.setPageIncrement(this.pageIncrementSpinner.getSelection());
    }

    void setWidgetDigits() {
        this.spinner1.setDigits(this.digitsSpinner.getSelection());
    }

    @Override
    void setWidgetSelection() {
        this.spinner1.setSelection(this.selectionSpinner.getSelection());
    }
}

