/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class TabFolderTab
extends Tab {
    TabFolder tabFolder1;
    Group tabFolderGroup;
    Button topButton;
    Button bottomButton;
    static String[] TabItems1 = new String[]{ControlExample.getResourceString("TabItem1_0"), ControlExample.getResourceString("TabItem1_1"), ControlExample.getResourceString("TabItem1_2")};

    TabFolderTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolderGroup.setText("TabFolder");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            style |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.tabFolder1 = new TabFolder((Composite)this.tabFolderGroup, style);
        int i = 0;
        while (i < TabItems1.length) {
            TabItem item = new TabItem(this.tabFolder1, 0);
            item.setText(TabItems1[i]);
            item.setToolTipText(ControlExample.getResourceString("Tooltip", TabItems1[i]));
            Text content = new Text((Composite)this.tabFolder1, 66);
            content.setText(String.valueOf(ControlExample.getResourceString("TabItem_content")) + ": " + i);
            item.setControl((Control)content);
            ++i;
        }
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.tabFolder1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "SelectionIndex", "ToolTipText"};
    }

    @Override
    String setMethodName(String methodRoot) {
        return methodRoot.equals("SelectionIndex") ? "setSelection" : "set" + methodRoot;
    }

    @Override
    Object[] parameterForType(String typeName, String value, Widget widget) {
        TabItem item;
        if (value.isEmpty()) {
            return new Object[]{new TabItem[0]};
        }
        if (typeName.equals("org.eclipse.swt.widgets.TabItem") && (item = this.findItem(value, ((TabFolder)widget).getItems())) != null) {
            return new Object[]{item};
        }
        if (typeName.equals("[Lorg.eclipse.swt.widgets.TabItem;")) {
            String[] values = this.split(value, ',');
            TabItem[] items = new TabItem[values.length];
            int i = 0;
            while (i < values.length) {
                items[i] = this.findItem(values[i], ((TabFolder)widget).getItems());
                ++i;
            }
            return new Object[]{items};
        }
        return super.parameterForType(typeName, value, widget);
    }

    TabItem findItem(String value, TabItem[] items) {
        TabItem[] tabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            if (item.getText().equals(value)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    @Override
    String getShortTabText() {
        return "TF";
    }

    @Override
    String getTabText() {
        return "TabFolder";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.topButton.setSelection((this.tabFolder1.getStyle() & 0x80) != 0);
        this.bottomButton.setSelection((this.tabFolder1.getStyle() & 0x400) != 0);
        this.borderButton.setEnabled(false);
    }
}

