/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

class ToolBarTab
extends Tab {
    ToolBar imageToolBar;
    ToolBar textToolBar;
    ToolBar imageTextToolBar;
    Group imageToolBarGroup;
    Group textToolBarGroup;
    Group imageTextToolBarGroup;
    Button horizontalButton;
    Button verticalButton;
    Button flatButton;
    Button shadowOutButton;
    Button wrapButton;
    Button rightButton;
    Button comboChildButton;

    ToolBarTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.imageToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageToolBarGroup.setLayout((Layout)new GridLayout());
        this.imageToolBarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageToolBarGroup.setText(ControlExample.getResourceString("Image_ToolBar"));
        this.textToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.textToolBarGroup.setLayout((Layout)new GridLayout());
        this.textToolBarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textToolBarGroup.setText(ControlExample.getResourceString("Text_ToolBar"));
        this.imageTextToolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageTextToolBarGroup.setLayout((Layout)new GridLayout());
        this.imageTextToolBarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageTextToolBarGroup.setText(ControlExample.getResourceString("ImageText_ToolBar"));
    }

    @Override
    void createExampleWidgets() {
        Combo combo;
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.shadowOutButton.getSelection()) {
            style |= 8;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        this.imageToolBar = new ToolBar((Composite)this.imageToolBarGroup, style);
        ToolItem item = new ToolItem(this.imageToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageToolBar, 2);
        item.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.imageToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            item.setWidth(combo.getSize().x);
            item.setControl((Control)combo);
        }
        item = new ToolItem(this.imageToolBar, 4);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.textToolBar = new ToolBar((Composite)this.textToolBarGroup, style);
        item = new ToolItem(this.textToolBar, 8);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.textToolBar, 8);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 32);
        item.setText(ControlExample.getResourceString("Check"));
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 16);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.textToolBar, 2);
        item.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.textToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            item.setWidth(combo.getSize().x);
            item.setControl((Control)combo);
        }
        item = new ToolItem(this.textToolBar, 4);
        item.setText(ControlExample.getResourceString("Drop_Down"));
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.imageTextToolBar = new ToolBar((Composite)this.imageTextToolBarGroup, style);
        item = new ToolItem(this.imageTextToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageTextToolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setText(ControlExample.getResourceString("Push"));
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(this.imageTextToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageTextToolBar, 16);
        item.setImage(this.instance.images[1]);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageTextToolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setText(ControlExample.getResourceString("Check"));
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(this.imageTextToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageTextToolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setText(ControlExample.getResourceString("Radio"));
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(this.imageTextToolBar, 2);
        item.setToolTipText("SWT.SEPARATOR");
        if (this.comboChildButton.getSelection()) {
            combo = new Combo((Composite)this.imageTextToolBar, 0);
            combo.setItems(new String[]{"250", "500", "750"});
            combo.setText(combo.getItem(0));
            combo.pack();
            item.setWidth(combo.getSize().x);
            item.setControl((Control)combo);
        }
        item = new ToolItem(this.imageTextToolBar, 4);
        item.setImage(this.instance.images[2]);
        item.setText(ControlExample.getResourceString("Drop_Down"));
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.comboChildButton = new Button((Composite)this.otherGroup, 32);
        this.comboChildButton.setText(ControlExample.getResourceString("Combo_child"));
        this.comboChildButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.recreateExampleWidgets()));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.shadowOutButton = new Button((Composite)this.styleGroup, 32);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.rightButton = new Button((Composite)this.styleGroup, 32);
        this.rightButton.setText("SWT.RIGHT");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    void disposeExampleWidgets() {
        super.disposeExampleWidgets();
    }

    @Override
    Item[] getExampleWidgetItems() {
        ToolItem[] imageToolBarItems = this.imageToolBar.getItems();
        ToolItem[] textToolBarItems = this.textToolBar.getItems();
        ToolItem[] imageTextToolBarItems = this.imageTextToolBar.getItems();
        Item[] allItems = new Item[imageToolBarItems.length + textToolBarItems.length + imageTextToolBarItems.length];
        System.arraycopy(imageToolBarItems, 0, allItems, 0, imageToolBarItems.length);
        System.arraycopy(textToolBarItems, 0, allItems, imageToolBarItems.length, textToolBarItems.length);
        System.arraycopy(imageTextToolBarItems, 0, allItems, imageToolBarItems.length + textToolBarItems.length, imageTextToolBarItems.length);
        return allItems;
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.imageToolBar, this.textToolBar, this.imageTextToolBar};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ToolTipText"};
    }

    @Override
    String getShortTabText() {
        return "TB";
    }

    @Override
    String getTabText() {
        return "ToolBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.imageToolBar.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.imageToolBar.getStyle() & 0x200) != 0);
        this.flatButton.setSelection((this.imageToolBar.getStyle() & 0x800000) != 0);
        this.wrapButton.setSelection((this.imageToolBar.getStyle() & 0x40) != 0);
        this.shadowOutButton.setSelection((this.imageToolBar.getStyle() & 8) != 0);
        this.rightButton.setSelection((this.imageToolBar.getStyle() & 0x20000) != 0);
        this.borderButton.setEnabled(false);
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.menu == null) {
                ToolBar toolbar = ((ToolItem)event.widget).getParent();
                int style = toolbar.getStyle() & 0x6000000;
                this.menu = new Menu((Decorations)ToolBarTab.this.shell, style | 8);
                int i = 0;
                while (i < 9) {
                    String text = ControlExample.getResourceString("DropDownData_" + i);
                    if (text.length() != 0) {
                        MenuItem menuItem = new MenuItem(this.menu, 0);
                        menuItem.setText(text);
                    } else {
                        new MenuItem(this.menu, 2);
                    }
                    ++i;
                }
            }
            if (event.detail == 4) {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar toolBar = toolItem.getParent();
                Point point = toolBar.toDisplay(new Point(event.x, event.y));
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
            }
        }
    }
}

