/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AdvancedGraphics {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("examples_graphics");

    static Image loadImage(Device device, Class<AdvancedGraphics> clazz, String string) {
        Image image;
        block12: {
            InputStream stream = clazz.getResourceAsStream(string);
            if (stream == null) {
                return null;
            }
            image = null;
            try {
                try {
                    image = new Image(device, stream);
                }
                catch (SWTException sWTException) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    public Shell open(Display display) {
        Shell shell = new Shell(display);
        shell.setText(RESOURCE_BUNDLE.getString("AdvancedGraphics"));
        try {
            Path path = new Path((Device)display);
            path.dispose();
        }
        catch (SWTException sWTException) {
            MessageBox dialog = new MessageBox(shell, 40);
            dialog.setText(RESOURCE_BUNDLE.getString("Warning"));
            dialog.setMessage(RESOURCE_BUNDLE.getString("LibNotFound"));
            dialog.open();
            shell.dispose();
            return null;
        }
        FontData fd = shell.getFont().getFontData()[0];
        Font font = new Font((Device)display, fd.getName(), 96, 3);
        Image image = AdvancedGraphics.loadImage((Device)display, AdvancedGraphics.class, "irmaos.jpg");
        Rectangle rect = image.getBounds();
        shell.addListener(9, event -> {
            GC gc = event.gc;
            Transform tr = new Transform((Device)display);
            tr.translate((float)(rectangle.width / 4), (float)(rectangle.height / 2));
            tr.rotate(-30.0f);
            if (image != null) {
                gc.drawImage(image, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle.width, rectangle.height);
            }
            gc.setAlpha(100);
            gc.setTransform(tr);
            Path path = new Path((Device)display);
            path.addString("SWT", 0.0f, 0.0f, font);
            gc.setBackground(display.getSystemColor(5));
            gc.setForeground(display.getSystemColor(9));
            gc.fillPath(path);
            gc.drawPath(path);
            tr.dispose();
            path.dispose();
        });
        shell.setSize(shell.computeSize(rect.width, rect.height));
        shell.open();
        shell.addListener(12, event -> {
            if (image != null) {
                image.dispose();
            }
            font.dispose();
        });
        return shell;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new AdvancedGraphics().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

