/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class AlphaTab
extends AnimatedGraphicsTab {
    int alphaValue;
    int alphaValue2;
    boolean reachedMax = false;
    int diameter;
    int randX;
    int randY;
    Image alphaImg1;
    Image alphaImg2;

    public AlphaTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Alpha");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Alpha");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("AlphaDescription");
    }

    @Override
    public int getInitialAnimationTime() {
        return 20;
    }

    @Override
    public void dispose() {
        if (this.alphaImg1 != null) {
            this.alphaImg1.dispose();
            this.alphaImg1 = null;
        }
        if (this.alphaImg2 != null) {
            this.alphaImg2.dispose();
            this.alphaImg2 = null;
        }
    }

    @Override
    public void next(int width, int height) {
        this.alphaValue = (this.alphaValue + 5) % 255;
        int n = this.alphaValue2 = this.reachedMax ? this.alphaValue2 - 5 : this.alphaValue2 + 5;
        if (this.alphaValue2 == 255) {
            this.reachedMax = true;
        } else if (this.alphaValue2 == 0) {
            this.reachedMax = false;
        }
        this.diameter = (this.diameter + 10) % (width > height ? width : height);
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.alphaImg1 == null) {
            this.alphaImg1 = GraphicsExample.loadImage(device, GraphicsExample.class, "alpha_img1.png");
            this.alphaImg2 = GraphicsExample.loadImage(device, GraphicsExample.class, "alpha_img2.png");
        }
        Rectangle rect = this.alphaImg1.getBounds();
        gc.setAlpha(this.alphaValue);
        gc.drawImage(this.alphaImg1, rect.x, rect.y, rect.width, rect.height, width / 2, height / 2, width / 4, height / 4);
        gc.drawImage(this.alphaImg1, rect.x, rect.y, rect.width, rect.height, 0, 0, width / 4, height / 4);
        gc.setAlpha(255 - this.alphaValue);
        gc.drawImage(this.alphaImg2, rect.x, rect.y, rect.width, rect.height, width / 2, 0, width / 4, height / 4);
        gc.drawImage(this.alphaImg2, rect.x, rect.y, rect.width, rect.height, 0, 3 * height / 4, width / 4, height / 4);
        gc.setBackground(device.getSystemColor(12));
        gc.fillPolygon(new int[]{width / 10, height / 2, 3 * width / 10, height / 2 - width / 6, 5 * width / 10, height / 2, 4 * width / 10, height / 2 + width / 6, 2 * width / 10, height / 2 + width / 6});
        gc.setBackground(device.getSystemColor(3));
        gc.setAlpha(this.alphaValue);
        gc.fillRectangle(width / 2, height - 75, 75, 75);
        gc.setAlpha(this.alphaValue + 15);
        gc.fillPolygon(new int[]{width / 2 + 75, height - 150, width / 2 + 75, height - 75, width / 2 + 150, height - 75});
        gc.setAlpha(this.alphaValue + 30);
        gc.fillPolygon(new int[]{width / 2 + 80, height - 150, width / 2 + 150, height - 150, width / 2 + 150, height - 80});
        gc.setAlpha(this.alphaValue + 45);
        gc.fillPolygon(new int[]{width / 2 + 150, height - 150, width / 2 + 225, height - 150, width / 2 + 225, height - 225});
        gc.setAlpha(this.alphaValue + 60);
        gc.fillPolygon(new int[]{width / 2 + 150, height - 155, width / 2 + 150, height - 225, width / 2 + 220, height - 225});
        gc.setAlpha(this.alphaValue + 75);
        gc.fillRectangle(width / 2 + 225, height - 300, 75, 75);
        gc.setBackground(device.getSystemColor(5));
        gc.setAlpha(this.alphaValue2);
        gc.fillOval(width - 100, 0, 100, 100);
        gc.setAlpha(this.alphaValue + 90);
        gc.fillPolygon(new int[]{width - 300, 10, width - 100, 10, width - 275, 50});
        gc.setAlpha(this.alphaValue + 105);
        gc.fillPolygon(new int[]{width - 10, 100, width - 10, 300, width - 50, 275});
        gc.setAlpha(this.alphaValue + 120);
        gc.fillPolygon(new int[]{width - 100, 100, width - 200, 150, width - 200, 200, width - 150, 200});
        gc.setBackground(device.getSystemColor(9));
        int size = 50;
        int alpha = 20;
        int i = 0;
        while (i < 10) {
            gc.setAlpha(this.alphaValue + alpha);
            if (i % 2 > 0) {
                gc.fillOval(width - (i + 1) * size, height - size, size, size);
            } else {
                gc.fillOval(width - (i + 1) * size, height - 3 * size / 2, size, size);
            }
            alpha += 20;
            ++i;
        }
        gc.setAlpha(this.alphaValue2);
        String text = GraphicsExample.getResourceString("SWT");
        Font font = AlphaTab.createFont(device, 100, 0);
        gc.setFont(font);
        Point textSize = gc.stringExtent(text);
        int textWidth = textSize.x;
        int textHeight = textSize.y;
        if (this.alphaValue2 == 0) {
            this.randX = (int)((double)width * Math.random());
            this.randY = (int)((double)height * Math.random());
            this.randX = this.randX > textWidth ? this.randX - textWidth : this.randX;
            this.randY = this.randY > textHeight ? this.randY - textHeight : this.randY;
        }
        gc.drawString(text, this.randX, this.randY, true);
        font.dispose();
        gc.setAlpha(100);
        Path path = new Path(device);
        path.addArc((float)((width - this.diameter) / 2), (float)((height - this.diameter) / 2), (float)this.diameter, (float)this.diameter, 0.0f, 360.0f);
        path.close();
        path.addArc((float)((width - this.diameter + 25) / 2), (float)((height - this.diameter + 25) / 2), (float)(this.diameter - 25), (float)(this.diameter - 25), 0.0f, 360.0f);
        path.close();
        gc.setBackground(device.getSystemColor(15));
        gc.fillPath(path);
        gc.drawPath(path);
        path.dispose();
    }

    static Font createFont(Device device, int points, int style) {
        if (SWT.getPlatform() == "win32") {
            return new Font(device, "Verdana", points, style);
        }
        if (SWT.getPlatform() == "gtk") {
            return new Font(device, "Baekmuk Batang", points, style);
        }
        return new Font(device, "Verdana", points, style);
    }
}

