/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AnimatedGraphicsTab
extends GraphicsTab {
    ToolBar toolBar;
    ToolItem playItem;
    ToolItem pauseItem;
    Spinner timerSpinner;
    private boolean animate = true;

    public AnimatedGraphicsTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public void createControlPanel(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.wrap = true;
        layout.spacing = 8;
        parent.setLayout((Layout)layout);
        this.createToolBar(parent);
    }

    void createToolBar(Composite parent) {
        Display display = parent.getDisplay();
        this.toolBar = new ToolBar(parent, 0x800000);
        Listener toolBarListener = event -> {
            switch (event.type) {
                case 13: {
                    if (event.widget == this.playItem) {
                        this.animate = true;
                        this.playItem.setEnabled(!this.animate);
                        this.pauseItem.setEnabled(this.animate);
                        break;
                    }
                    if (event.widget != this.pauseItem) break;
                    this.animate = false;
                    this.playItem.setEnabled(!this.animate);
                    this.pauseItem.setEnabled(this.animate);
                }
            }
        };
        this.playItem = new ToolItem(this.toolBar, 8);
        this.playItem.setText(GraphicsExample.getResourceString("Play"));
        this.playItem.setImage(this.example.loadImage((Device)display, "play.gif"));
        this.playItem.addListener(13, toolBarListener);
        this.pauseItem = new ToolItem(this.toolBar, 8);
        this.pauseItem.setText(GraphicsExample.getResourceString("Pause"));
        this.pauseItem.setImage(this.example.loadImage((Device)display, "pause.gif"));
        this.pauseItem.addListener(13, toolBarListener);
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0x1000000);
        label.setText(GraphicsExample.getResourceString("Animation"));
        this.timerSpinner = new Spinner(comp, 2112);
        this.timerSpinner.setMaximum(1000);
        this.playItem.setEnabled(false);
        this.animate = true;
        this.timerSpinner.setSelection(this.getInitialAnimationTime());
    }

    @Override
    public boolean getDoubleBuffered() {
        return true;
    }

    public int getInitialAnimationTime() {
        return 30;
    }

    public int getAnimationTime() {
        return this.timerSpinner.getSelection();
    }

    public boolean getAnimation() {
        return this.animate;
    }

    public void setAnimation(boolean flag) {
        this.animate = flag;
        this.playItem.setEnabled(!flag);
        this.pauseItem.setEnabled(flag);
    }

    public abstract void next(int var1, int var2);
}

