/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;

public class CurvesSWTTab
extends GraphicsTab {
    private Rectangle sRect1 = new Rectangle(-75, 50, 5, 5);
    private Rectangle sRect2 = new Rectangle(75, 100, 5, 5);
    private Rectangle wRect1 = new Rectangle(80, 300, 5, 5);
    private Rectangle wRect2 = new Rectangle(120, 300, 5, 5);
    private Rectangle tTopRect1 = new Rectangle(33, -20, 5, 5);
    private Rectangle tTopRect2 = new Rectangle(66, 20, 5, 5);
    private Rectangle tBottomRect1 = new Rectangle(-33, 50, 5, 5);
    private Rectangle tBottomRect2 = new Rectangle(33, 100, 5, 5);
    private float sXPos;
    private float sYPos;
    private float wXPos;
    private float wYPos;
    private float topTXPos;
    private float topTYPos;
    private float botTXPos;
    private float botTYPos;
    private float sDiffX1 = 0.0f;
    private float sDiffY1 = 0.0f;
    private float sDiffX2 = 0.0f;
    private float sDiffY2 = 0.0f;
    private float wDiffX1 = 0.0f;
    private float wDiffY1 = 0.0f;
    private float wDiffX2 = 0.0f;
    private float wDiffY2 = 0.0f;
    private float tTopDiffX1 = 0.0f;
    private float tTopDiffY1 = 0.0f;
    private float tTopDiffX2 = 0.0f;
    private float tTopDiffY2 = 0.0f;
    private float tBotDiffX1 = 0.0f;
    private float tBotDiffY1 = 0.0f;
    private float tBotDiffX2 = 0.0f;
    private float tBotDiffY2 = 0.0f;
    private boolean sLeftPtMoved;
    private boolean sRightPtMoved;
    private boolean wPt1Moved;
    private boolean wPt2Moved;
    private boolean tTopPt1Moved;
    private boolean tTopPt2Moved;
    private boolean tBotPt1Moved;
    private boolean tBotPt2Moved;
    private MouseMoveListener mouseMoveListener;
    private MouseListener mouseListener;
    private Cursor cursor;
    private boolean hovering = false;
    private boolean mouseDown = false;

    public CurvesSWTTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Curves");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("SWT");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CurvesSWTDescription");
    }

    @Override
    public boolean getDoubleBuffered() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.mouseListener != null) {
            this.example.canvas.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMoveListener != null) {
            this.example.canvas.removeMouseMoveListener(this.mouseMoveListener);
        }
        this.cursor = null;
    }

    private boolean isHovering(MouseEvent e) {
        Rectangle r1 = new Rectangle(this.sRect1.x + (int)this.sXPos - 1, this.sRect1.y + (int)this.sYPos - 1, this.sRect1.width + 2, this.sRect1.height + 2);
        Rectangle r2 = new Rectangle(this.sRect2.x + (int)this.sXPos - 1, this.sRect2.y + (int)this.sYPos - 1, this.sRect2.width + 2, this.sRect2.height + 2);
        Rectangle w1 = new Rectangle(this.wRect1.x + (int)this.wXPos - 1, this.wRect1.y + (int)this.wYPos - 1, this.wRect1.width + 2, this.wRect1.height + 2);
        Rectangle w2 = new Rectangle(this.wRect2.x + (int)this.wXPos - 1, this.wRect2.y + (int)this.wYPos - 1, this.wRect2.width + 2, this.wRect2.height + 2);
        Rectangle tTop1 = new Rectangle(this.tTopRect1.x + (int)this.topTXPos - 1, this.tTopRect1.y + (int)this.topTYPos - 1, this.tTopRect1.width + 2, this.tTopRect1.height + 2);
        Rectangle tTop2 = new Rectangle(this.tTopRect2.x + (int)this.topTXPos - 1, this.tTopRect2.y + (int)this.topTYPos - 1, this.tTopRect2.width + 2, this.tTopRect2.height + 2);
        Rectangle tBot1 = new Rectangle(this.tBottomRect1.x + (int)this.botTXPos - 1, this.tBottomRect1.y + (int)this.botTYPos - 1, this.tBottomRect1.width + 2, this.tBottomRect1.height + 2);
        Rectangle tBot2 = new Rectangle(this.tBottomRect2.x + (int)this.botTXPos - 1, this.tBottomRect2.y + (int)this.botTYPos - 1, this.tBottomRect2.width + 2, this.tBottomRect2.height + 2);
        return r1.contains(e.x, e.y) || r2.contains(e.x, e.y) || w1.contains(e.x, e.y) || w2.contains(e.x, e.y) || tTop1.contains(e.x, e.y) || tTop2.contains(e.x, e.y) || tBot1.contains(e.x, e.y) || tBot2.contains(e.x, e.y);
    }

    @Override
    public void createControlPanel(Composite parent) {
        if (this.cursor == null) {
            this.cursor = parent.getDisplay().getSystemCursor(21);
        }
        this.mouseMoveListener = e -> {
            if (this.hovering && this.mouseDown) {
                this.example.canvas.setCursor(this.cursor);
            } else if (this.isHovering(e)) {
                this.example.canvas.setCursor(this.cursor);
                this.hovering = true;
            } else {
                this.example.canvas.setCursor(null);
                this.hovering = false;
            }
            if (this.sLeftPtMoved) {
                this.sDiffX1 = this.sDiffX1 + (float)e.x - (float)((int)this.sXPos) - (float)this.sRect1.x;
                this.sDiffY1 = this.sDiffY1 + (float)e.y - (float)((int)this.sYPos) - (float)this.sRect1.y;
                this.sRect1.x = e.x - (int)this.sXPos;
                this.sRect1.y = e.y - (int)this.sYPos;
            } else if (this.sRightPtMoved) {
                this.sDiffX2 = this.sDiffX2 + (float)e.x - (float)((int)this.sXPos) - (float)this.sRect2.x;
                this.sDiffY2 = this.sDiffY2 + (float)e.y - (float)((int)this.sYPos) - (float)this.sRect2.y;
                this.sRect2.x = e.x - (int)this.sXPos;
                this.sRect2.y = e.y - (int)this.sYPos;
            } else if (this.wPt1Moved) {
                this.wDiffX1 = this.wDiffX1 + (float)e.x - (float)((int)this.wXPos) - (float)this.wRect1.x;
                this.wDiffY1 = this.wDiffY1 + (float)e.y - (float)((int)this.wYPos) - (float)this.wRect1.y;
                this.wRect1.x = e.x - (int)this.wXPos;
                this.wRect1.y = e.y - (int)this.wYPos;
            } else if (this.wPt2Moved) {
                this.wDiffX2 = this.wDiffX2 + (float)e.x - (float)((int)this.wXPos) - (float)this.wRect2.x;
                this.wDiffY2 = this.wDiffY2 + (float)e.y - (float)((int)this.wYPos) - (float)this.wRect2.y;
                this.wRect2.x = e.x - (int)this.wXPos;
                this.wRect2.y = e.y - (int)this.wYPos;
            } else if (this.tTopPt1Moved) {
                this.tTopDiffX1 = this.tTopDiffX1 + (float)e.x - (float)((int)this.topTXPos) - (float)this.tTopRect1.x;
                this.tTopDiffY1 = this.tTopDiffY1 + (float)e.y - (float)((int)this.topTYPos) - (float)this.tTopRect1.y;
                this.tTopRect1.x = e.x - (int)this.topTXPos;
                this.tTopRect1.y = e.y - (int)this.topTYPos;
            } else if (this.tTopPt2Moved) {
                this.tTopDiffX2 = this.tTopDiffX2 + (float)e.x - (float)((int)this.topTXPos) - (float)this.tTopRect2.x;
                this.tTopDiffY2 = this.tTopDiffY2 + (float)e.y - (float)((int)this.topTYPos) - (float)this.tTopRect2.y;
                this.tTopRect2.x = e.x - (int)this.topTXPos;
                this.tTopRect2.y = e.y - (int)this.topTYPos;
            } else if (this.tBotPt1Moved) {
                this.tBotDiffX1 = this.tBotDiffX1 + (float)e.x - (float)((int)this.botTXPos) - (float)this.tBottomRect1.x;
                this.tBotDiffY1 = this.tBotDiffY1 + (float)e.y - (float)((int)this.botTYPos) - (float)this.tBottomRect1.y;
                this.tBottomRect1.x = e.x - (int)this.botTXPos;
                this.tBottomRect1.y = e.y - (int)this.botTYPos;
            } else if (this.tBotPt2Moved) {
                this.tBotDiffX2 = this.tBotDiffX2 + (float)e.x - (float)((int)this.botTXPos) - (float)this.tBottomRect2.x;
                this.tBotDiffY2 = this.tBotDiffY2 + (float)e.y - (float)((int)this.botTYPos) - (float)this.tBottomRect2.y;
                this.tBottomRect2.x = e.x - (int)this.botTXPos;
                this.tBottomRect2.y = e.y - (int)this.botTYPos;
            }
            this.example.redraw();
        };
        this.mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Rectangle r1 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).sRect1.x + (int)CurvesSWTTab.this.sXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).sRect1.y + (int)CurvesSWTTab.this.sYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).sRect1.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).sRect1.height + 2);
                Rectangle r2 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).sRect2.x + (int)CurvesSWTTab.this.sXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).sRect2.y + (int)CurvesSWTTab.this.sYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).sRect2.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).sRect2.height + 2);
                Rectangle w1 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).wRect1.x + (int)CurvesSWTTab.this.wXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).wRect1.y + (int)CurvesSWTTab.this.wYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).wRect1.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).wRect1.height + 2);
                Rectangle w2 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).wRect2.x + (int)CurvesSWTTab.this.wXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).wRect2.y + (int)CurvesSWTTab.this.wYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).wRect2.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).wRect2.height + 2);
                Rectangle tTop1 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).tTopRect1.x + (int)CurvesSWTTab.this.topTXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect1.y + (int)CurvesSWTTab.this.topTYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect1.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect1.height + 2);
                Rectangle tTop2 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).tTopRect2.x + (int)CurvesSWTTab.this.topTXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect2.y + (int)CurvesSWTTab.this.topTYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect2.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).tTopRect2.height + 2);
                Rectangle tBot1 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).tBottomRect1.x + (int)CurvesSWTTab.this.botTXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect1.y + (int)CurvesSWTTab.this.botTYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect1.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect1.height + 2);
                Rectangle tBot2 = new Rectangle(((CurvesSWTTab)CurvesSWTTab.this).tBottomRect2.x + (int)CurvesSWTTab.this.botTXPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect2.y + (int)CurvesSWTTab.this.botTYPos - 1, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect2.width + 2, ((CurvesSWTTab)CurvesSWTTab.this).tBottomRect2.height + 2);
                if (r1.contains(e.x, e.y)) {
                    CurvesSWTTab.this.sLeftPtMoved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (r2.contains(e.x, e.y)) {
                    CurvesSWTTab.this.sRightPtMoved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (w1.contains(e.x, e.y)) {
                    CurvesSWTTab.this.wPt1Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (w2.contains(e.x, e.y)) {
                    CurvesSWTTab.this.wPt2Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (tTop1.contains(e.x, e.y)) {
                    CurvesSWTTab.this.tTopPt1Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (tTop2.contains(e.x, e.y)) {
                    CurvesSWTTab.this.tTopPt2Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (tBot1.contains(e.x, e.y)) {
                    CurvesSWTTab.this.tBotPt1Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                } else if (tBot2.contains(e.x, e.y)) {
                    CurvesSWTTab.this.tBotPt2Moved = true;
                    CurvesSWTTab.this.mouseDown = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                CurvesSWTTab.this.mouseDown = false;
                if (CurvesSWTTab.this.isHovering(e)) {
                    CurvesSWTTab.this.example.canvas.setCursor(CurvesSWTTab.this.cursor);
                } else {
                    CurvesSWTTab.this.example.canvas.setCursor(null);
                }
                if (CurvesSWTTab.this.sLeftPtMoved) {
                    CurvesSWTTab.this.sLeftPtMoved = false;
                }
                if (CurvesSWTTab.this.sRightPtMoved) {
                    CurvesSWTTab.this.sRightPtMoved = false;
                }
                if (CurvesSWTTab.this.wPt1Moved) {
                    CurvesSWTTab.this.wPt1Moved = false;
                }
                if (CurvesSWTTab.this.wPt2Moved) {
                    CurvesSWTTab.this.wPt2Moved = false;
                }
                if (CurvesSWTTab.this.tTopPt1Moved) {
                    CurvesSWTTab.this.tTopPt1Moved = false;
                }
                if (CurvesSWTTab.this.tTopPt2Moved) {
                    CurvesSWTTab.this.tTopPt2Moved = false;
                }
                if (CurvesSWTTab.this.tBotPt1Moved) {
                    CurvesSWTTab.this.tBotPt1Moved = false;
                }
                if (CurvesSWTTab.this.tBotPt2Moved) {
                    CurvesSWTTab.this.tBotPt2Moved = false;
                }
                CurvesSWTTab.this.example.redraw();
            }
        };
        this.example.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.example.canvas.addMouseListener(this.mouseListener);
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Font font = new Font(device, CurvesSWTTab.getPlatformFont(), 16, 2);
        gc.setFont(font);
        gc.setLineWidth(2);
        this.sXPos = 4 * width / 16;
        this.sYPos = (height - 150) / 2;
        Transform transform = new Transform(device);
        transform.translate(this.sXPos, this.sYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(10));
        gc.drawString(GraphicsExample.getResourceString("Cubic"), 0, 175, true);
        Path path = new Path(device);
        path.cubicTo(-200.0f + this.sDiffX1, 50.0f + this.sDiffY1, 200.0f + this.sDiffX2, 100.0f + this.sDiffY2, 0.0f, 150.0f);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.drawRectangle(this.sRect1.x + (int)this.sXPos, this.sRect1.y + (int)this.sYPos, this.sRect1.width, this.sRect1.height);
        gc.drawRectangle(this.sRect2.x + (int)this.sXPos, this.sRect2.y + (int)this.sYPos, this.sRect2.width, this.sRect2.height);
        this.wXPos = 6 * width / 16;
        this.wYPos = (height - 150) / 2;
        transform = new Transform(device);
        transform.translate(this.wXPos, this.wYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(15));
        gc.drawString(GraphicsExample.getResourceString("Quadratic"), 0, -50, true);
        gc.drawString(GraphicsExample.getResourceString("Quadratic"), 110, -50, true);
        path = new Path(device);
        path.quadTo(100.0f + this.wDiffX1, 300.0f + this.wDiffY1, 100.0f, 0.0f);
        path.quadTo(100.0f + this.wDiffX2, 300.0f + this.wDiffY2, 200.0f, 0.0f);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.drawRectangle(this.wRect1.x + (int)this.wXPos, this.wRect1.y + (int)this.wYPos, this.wRect1.width, this.wRect1.height);
        gc.drawRectangle(this.wRect2.x + (int)this.wXPos, this.wRect2.y + (int)this.wYPos, this.wRect2.width, this.wRect2.height);
        this.topTXPos = 11 * width / 16;
        this.topTYPos = (height - 150) / 2;
        transform = new Transform(device);
        transform.translate(this.topTXPos, this.topTYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(7));
        gc.drawString(GraphicsExample.getResourceString("Cubic"), 25, -50, true);
        path = new Path(device);
        path.cubicTo(33.0f + this.tTopDiffX1, -20.0f + this.tTopDiffY1, 66.0f + this.tTopDiffX2, 20.0f + this.tTopDiffY2, 100.0f, 0.0f);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.drawRectangle(this.tTopRect1.x + (int)this.topTXPos, this.tTopRect1.y + (int)this.topTYPos, this.tTopRect1.width, this.tTopRect1.height);
        gc.drawRectangle(this.tTopRect2.x + (int)this.topTXPos, this.tTopRect2.y + (int)this.topTYPos, this.tTopRect2.width, this.tTopRect2.height);
        this.botTXPos = 12 * width / 16;
        this.botTYPos = (height - 150) / 2;
        transform = new Transform(device);
        transform.translate(this.botTXPos, this.botTYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(3));
        gc.drawString(GraphicsExample.getResourceString("Cubic"), 0, 175, true);
        path = new Path(device);
        path.cubicTo(-33.0f + this.tBotDiffX1, 50.0f + this.tBotDiffY1, 33.0f + this.tBotDiffX2, 100.0f + this.tBotDiffY2, 0.0f, 150.0f);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.drawRectangle(this.tBottomRect1.x + (int)this.botTXPos, this.tBottomRect1.y + (int)this.botTYPos, this.tBottomRect1.width, this.tBottomRect1.height);
        gc.drawRectangle(this.tBottomRect2.x + (int)this.botTXPos, this.tBottomRect2.y + (int)this.botTYPos, this.tBottomRect2.width, this.tBottomRect2.height);
        font.dispose();
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        return "Verdana";
    }
}

