/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class GraphicAntialiasTab
extends GraphicsTab {
    Combo aliasCombo;
    int[] aliasValues;
    Button colorButton;
    Menu menu;
    GraphicsBackground ovalColorGB;

    public GraphicAntialiasTab(GraphicsExample example) {
        super(example);
        int[] nArray = new int[3];
        nArray[1] = -1;
        nArray[2] = 1;
        this.aliasValues = nArray;
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Antialiasing");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Graphics");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("AntialiasingGraphicsDesc");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Antialiasing"));
        this.aliasCombo = new Combo(comp, 4);
        this.aliasCombo.add("OFF");
        this.aliasCombo.add("DEFAULT");
        this.aliasCombo.add("ON");
        this.aliasCombo.select(0);
        this.aliasCombo.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        cm.setColorItems(true);
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.ovalColorGB = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.ovalColorGB = (GraphicsBackground)this.menu.getItem(4).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.ovalColorGB.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.ovalColorGB != null && this.ovalColorGB.getBgColor1() != null) {
            gc.setBackground(this.ovalColorGB.getBgColor1());
        }
        gc.setAntialias(this.aliasValues[this.aliasCombo.getSelectionIndex()]);
        Path path = new Path(device);
        float offsetX = (float)(2 * width) / 3.0f;
        float offsetY = (float)height / 3.0f;
        int i = 0;
        while (i < 25) {
            path.addArc(offsetX - (float)(50 * i), offsetY - (float)(25 * i), (float)(50 + 100 * i), (float)(25 + 50 * i), 0.0f, 360.0f);
            ++i;
        }
        gc.fillPath(path);
        path.dispose();
    }
}

