/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class ImageFlipTab
extends GraphicsTab {
    public ImageFlipTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Image");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Flip");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("FlipDescription");
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Image image = GraphicsExample.loadImage(device, GraphicsExample.class, "houses.png");
        Rectangle bounds = image.getBounds();
        Transform transform = new Transform(device);
        transform.translate((float)((width - bounds.width) / 2), (float)((height - bounds.height) / 2));
        transform.scale(1.0f, -1.0f);
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)((width - bounds.width) / 2), (float)(2 * bounds.height + (height - bounds.height) / 2));
        transform.scale(1.0f, -1.0f);
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)((width - bounds.width) / 2), (float)((height - bounds.height) / 2));
        transform.scale(-1.0f, 1.0f);
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)(2 * bounds.width + (width - bounds.width) / 2), (float)((height - bounds.height) / 2));
        transform.scale(-1.0f, 1.0f);
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        transform.dispose();
        gc.setTransform(null);
        gc.drawImage(image, (width - bounds.width) / 2, (height - bounds.height) / 2);
        image.dispose();
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        return "Verdana";
    }
}

