/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.Random;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class IntroTab
extends AnimatedGraphicsTab {
    Font font;
    Image image;
    Random random = new Random();
    float x;
    float y;
    float incX = 10.0f;
    float incY = 5.0f;
    int textWidth;
    int textHeight;
    String text = GraphicsExample.getResourceString("SWT");

    public IntroTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = null;
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Introduction");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("SWT");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("IntroductionDescription");
    }

    @Override
    public void next(int width, int height) {
        this.x += this.incX;
        this.y += this.incY;
        float random = (float)Math.random();
        if (this.x + (float)this.textWidth > (float)width) {
            this.x = width - this.textWidth;
            this.incX = random * (float)(-width) / 16.0f - 1.0f;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.incX = random * (float)width / 16.0f + 1.0f;
        }
        if (this.y + (float)this.textHeight > (float)height) {
            this.y = height - this.textHeight - 2;
            this.incY = random * (float)(-height) / 16.0f - 1.0f;
        }
        if (this.y < 0.0f) {
            this.y = 0.0f;
            this.incY = random * (float)height / 16.0f + 1.0f;
        }
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.image == null) {
            this.image = this.example.loadImage(device, "irmaos.jpg");
            Rectangle rect = this.image.getBounds();
            FontData fd = device.getSystemFont().getFontData()[0];
            this.font = new Font(device, fd.getName(), rect.height / 4, 1);
            gc.setFont(this.font);
            Point size = gc.stringExtent(this.text);
            this.textWidth = size.x;
            this.textHeight = size.y;
        }
        Path path = new Path(device);
        path.addString(this.text, this.x, this.y, this.font);
        gc.setClipping(path);
        Rectangle rect = this.image.getBounds();
        gc.drawImage(this.image, 0, 0, rect.width, rect.height, 0, 0, width, height);
        gc.setClipping(null);
        gc.setForeground(device.getSystemColor(9));
        gc.drawPath(path);
        path.dispose();
    }
}

